/*
 *  Copyright 1999-2021 Alibaba Group Holding Ltd.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package com.alibaba.nacos.naming.selector.context;

import com.alibaba.nacos.api.naming.pojo.Instance;
import org.junit.jupiter.api.Test;

import java.util.Collections;
import java.util.List;

import static org.junit.jupiter.api.Assertions.assertEquals;

/**
 * {@link NoneSelectorContextBuilder} unit tests.
 *
 * @author chenglu
 * @date 2021-08-05 19:44
 */
class NoneSelectorContextBuilderTest {
    
    @Test
    void testBuild() {
        NoneSelectorContextBuilder<Instance> contextBuilder = new NoneSelectorContextBuilder<>();
        List<Instance> providers = Collections.emptyList();
        assertEquals(providers, contextBuilder.build("1.1.1.1", providers));
    }
}
