/*
 *  Copyright 1999-2018 Alibaba Group Holding Ltd.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package com.alibaba.nacos.core.distributed.id;

import com.alibaba.nacos.sys.env.EnvUtil;
import org.junit.jupiter.api.Test;
import org.springframework.core.env.StandardEnvironment;

import java.util.stream.IntStream;

import static org.junit.jupiter.api.Assertions.assertEquals;

class SnowFlowerInstanceIdGeneratorTest {
    
    @Test
    void nextId() {
        
        EnvUtil.setEnvironment(new StandardEnvironment());
        SnowFlowerIdGenerator generator = new SnowFlowerIdGenerator();
        generator.initialize(1);
        
        long count = IntStream.range(0, 10).mapToObj(i -> generator.nextId()).distinct().count();
        
        assertEquals(10, count);
    }
}