/*
 * Copyright 1999-2025 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.nacos.console.config;

import com.alibaba.nacos.sys.env.NacosDuplicateConfigurationBeanPostProcessor;
import com.alibaba.nacos.sys.env.NacosDuplicateSpringBeanPostProcessor;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.context.ConfigurableApplicationContext;

import static org.junit.jupiter.api.Assertions.assertInstanceOf;

@ExtendWith(MockitoExtension.class)
class NacosConsoleBeanPostProcessorConfigurationTest {
    
    @Mock
    ConfigurableApplicationContext applicationContext;
    
    @Test
    void nacosDuplicateSpringBeanPostProcessor() {
        NacosConsoleBeanPostProcessorConfiguration configuration = new NacosConsoleBeanPostProcessorConfiguration();
        assertInstanceOf(NacosDuplicateSpringBeanPostProcessor.class,
                configuration.nacosDuplicateSpringBeanPostProcessor(applicationContext));
    }
    
    @Test
    void nacosDuplicateConfigurationBeanPostProcessor() {
        NacosConsoleBeanPostProcessorConfiguration configuration = new NacosConsoleBeanPostProcessorConfiguration();
        assertInstanceOf(NacosDuplicateConfigurationBeanPostProcessor.class,
                configuration.nacosDuplicateConfigurationBeanPostProcessor(applicationContext));
    }
}