/*
 * Copyright 1999-2018 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.nacos.config.server.constant;

/**
 * PropertiesConstant.
 *
 * @author lixiaoshuang
 */
public class PropertiesConstant {
    
    public static final String NOTIFY_CONNECT_TIMEOUT = "notifyConnectTimeout";
    
    public static final String NOTIFY_SOCKET_TIMEOUT = "notifySocketTimeout";
    
    public static final String IS_HEALTH_CHECK = "isHealthCheck";
    
    public static final String MAX_HEALTH_CHECK_FAIL_COUNT = "maxHealthCheckFailCount";
    
    public static final String MAX_CONTENT = "maxContent";
    
    public static final String IS_MANAGE_CAPACITY = "isManageCapacity";
    
    public static final String IS_CAPACITY_LIMIT_CHECK = "isCapacityLimitCheck";
    
    public static final String DEFAULT_CLUSTER_QUOTA = "defaultClusterQuota";
    
    public static final String DEFAULT_GROUP_QUOTA = "defaultGroupQuota";
    
    public static final String DEFAULT_TENANT_QUOTA = "defaultTenantQuota";
    
    public static final String DEFAULT_MAX_SIZE = "defaultMaxSize";
    
    public static final String DEFAULT_MAX_AGGR_COUNT = "defaultMaxAggrCount";
    
    public static final String DEFAULT_MAX_AGGR_SIZE = "defaultMaxAggrSize";
    
    public static final String CORRECT_USAGE_DELAY = "correctUsageDelay";
    
    public static final String INITIAL_EXPANSION_PERCENT = "initialExpansionPercent";
    
    public static final String SEARCH_MAX_CAPACITY = "nacos.config.search.max_capacity";
    
    public static final String SEARCH_MAX_THREAD = "nacos.config.search.max_thread";
    
    public static final String SEARCH_WAIT_TIMEOUT = "nacos.config.search.wait_timeout";
    
    public static final String DUMP_CHANGE_ON = "dumpChangeOn";
    
    public static final String DUMP_CHANGE_WORKER_INTERVAL = "dumpChangeWorkerInterval";

    public static final String CONFIG_RENTENTION_DAYS = "nacos.config.retention.days";
    
    public static final String GRAY_CAPATIBEL_MODEL = "nacos.config.gray.compatible.model";
    
    public static final String NAMESPACE_COMPATIBLE_MODE = "nacos.config.namespace.compatible.mode";
    
}
