# Recv router CSI example

(See the README.md file in the upper level 'examples' directory for more information about examples.)

The device triggers the router to send packets through the Ping command to obtain the CSI data between the device and the router

## How to use example
Before project configuration and build, be sure to set the correct chip target using `idf.py set-target <chip_name>`.

### Hardware Required

* A development board with ESP32/ESP32-S2/ESP32-C3 SoC (e.g., ESP32-DevKitC, ESP-WROVER-KIT, etc.)
* A USB cable for power supply and programming

### Configure the project

```
idf.py menuconfig
```
Open the project configuration menu (`idf.py menuconfig`) to configure Wi-Fi or Ethernet. See "Establishing Wi-Fi or Ethernet Connection" section in [examples/protocols/README.md](https://github.com/espressif/esp-idf/tree/master/examples/protocols#establishing-wi-fi-or-ethernet-connection) for more details.

### Build and Flash

Build the project and flash it to the board, then run monitor tool to view serial output:

```
idf.py -p PORT flash monitor
```

(Replace PORT with the name of the serial port to use.)

(To exit the serial monitor, type ``Ctrl-]``.)

See the Getting Started Guide for full steps to configure and use ESP-IDF to build projects.

## Example Output

```shell
I (0) cpu_start: App cpu up.
I (288) cpu_start: Pro cpu start user code
I (288) cpu_start: cpu freq: 240000000
I (288) cpu_start: Application information:
I (289) cpu_start: Project name:     csi_recv_router
I (289) cpu_start: App version:      e1dd673-dirty
I (290) cpu_start: Compile time:     Jul 14 2022 18:55:08
I (291) cpu_start: ELF file SHA256:  81680e58e5d0e53c...
I (292) cpu_start: ESP-IDF:          v4.4.1-dirty
I (293) heap_init: Initializing. RAM available for dynamic allocation:
I (293) heap_init: At 3FFAE6E0 len 00001920 (6 KiB): DRAM
I (294) heap_init: At 3FFB7310 len 00028CF0 (163 KiB): DRAM
I (295) heap_init: At 3FFE0440 len 00003AE0 (14 KiB): D/IRAM
I (296) heap_init: At 3FFE4350 len 0001BCB0 (111 KiB): D/IRAM
I (296) heap_init: At 40093AA4 len 0000C55C (49 KiB): IRAM
I (298) spi_flash: detected chip: generic
I (299) spi_flash: flash io: dio
W (299) spi_flash: Detected size(4096k) larger than the size in the binary image header(2048k). Using the size in the binary image header.
I (301) cpu_start: Starting scheduler on PRO CPU.
I (0) cpu_start: Starting scheduler on APP CPU.
I (331) wifi:wifi driver task: 3ffbfa74, prio:23, stack:6656, core=0
I (332) system_api: Base MAC address is not set
I (332) system_api: read default base MAC address from EFUSE
I (335) wifi:wifi firmware version: 63017e0
I (335) wifi:wifi certification version: v7.0
I (335) wifi:config NVS flash: enabled
I (335) wifi:config nano formating: disabled
I (336) wifi:Init data frame dynamic rx buffer num: 128
I (336) wifi:Init management frame dynamic rx buffer num: 128
I (337) wifi:Init management short buffer num: 32
I (337) wifi:Init dynamic tx buffer num: 32
I (338) wifi:Init static rx buffer size: 2212
I (338) wifi:Init static rx buffer num: 10
I (339) wifi:Init dynamic rx buffer num: 128
I (340) wifi_init: tcpip mbox: 32
I (340) wifi_init: udp mbox: 6
I (340) wifi_init: tcp mbox: 6
I (341) wifi_init: tcp tx win: 5744
I (341) wifi_init: tcp rx win: 5744
I (342) wifi_init: tcp mss: 1440
I (342) wifi_init: WiFi IRAM OP enabled
I (343) wifi_init: WiFi RX IRAM OP enabled
I (344) example_connect: Connecting to TP-LINK_8C81...
I (345) phy_init: phy_version 4670,719f9f6,Feb 18 2021,17:07:07
I (433) wifi:mode : sta (ac:67:b2:53:78:d0)
I (434) wifi:enable tsf
I (437) example_connect: Waiting for IP(s)
I (2483) wifi:new:<13,2>, old:<1,0>, ap:<255,255>, sta:<13,2>, prof:1
I (2485) wifi:state: init -> auth (b0)
I (2503) wifi:state: auth -> assoc (0)
I (2509) wifi:state: assoc -> run (10)
I (2510) wifi:connected with TP-LINK_8C81, aid = 1, channel 13, 40D, bssid = 94:d9:b3:80:8c:81
I (2511) wifi:security: Open Auth, phy: bgn, rssi: -28
I (2511) wifi:pm start, type: 1

I (2535) wifi:AP's beacon interval = 102400 us, DTIM period = 1
I (3331) esp_netif_handlers: example_connect: sta ip: 192.168.0.107, mask: 255.255.255.0, gw: 192.168.0.1
I (3332) example_connect: Got IPv4 event: Interface "example_connect: sta" address: 192.168.0.107
I (4330) example_connect: Got IPv6 event: Interface "example_connect: sta" address: fe80:0000:0000:0000:ae67:b2ff:fe53:78d0, type: ESP_IP6_ADDR_IS_LINK_LOCAL
I (4332) example_connect: Connected to example_connect: sta
I (4332) example_connect: - IPv4 address: 192.168.0.107
I (4333) example_connect: - IPv6 address: fe80:0000:0000:0000:ae67:b2ff:fe53:78d0, type: ESP_IP6_ADDR_IS_LINK_LOCAL
I (4335) csi_recv_router: got ip:192.168.0.107, gw: 192.168.0.1
I (4346) csi_recv_router: ================ CSI RECV ================
type,seq,mac,rssi,rate,sig_mode,mcs,bandwidth,smoothing,not_sounding,aggregation,stbc,fec_coding,sgi,noise_floor,ampdu_cnt,channel,secondary_channel,local_timestamp,ant,sig_len,rx_state,len,first_word,data
CSI_DATA,0,94:d9:b3:80:8c:81,-30,11,1,6,1,0,1,0,1,0,0,-93,0,13,2,2751923,0,67,0,128,1,"[67,48,4,0,0,0,0,0,0,0,5,0,20,1,20,1,19,0,17,1,16,2,15,2,14,1,12,0,12,-1,12,-3,12,-4,13,-6,15,-7,16,-8,16,-8,16,-8,16,-6,15,-5,15,-4,14,-4,13,-4,12,-4,11,-4,10,-4,9,-5,8,-6,4,-4,8,-9,9,-10,9,-10,10,-11,11,-10,11,-10,12,-9,11,-8,11,-7,10,-6,9,-6,7,-6,6,-7,5,-7,5,-8,5,-9,5,-10,5,-11,5,-11,6,-11,7,-11,8,-11,9,-10,9,-9,8,-8,8,-7,1,-2,0,0,0,0,0,0,0,0]"
CSI_DATA,1,94:d9:b3:80:8c:81,-31,11,1,6,1,0,1,0,1,0,0,-93,0,13,2,2794394,0,67,0,128,1,"[67,48,4,0,0,0,0,0,0,0,5,-2,21,-7,20,-7,20,-6,19,-6,17,-5,15,-5,13,-5,11,-6,11,-7,10,-9,9,-10,10,-11,11,-13,12,-14,13,-14,13,-13,13,-12,13,-12,13,-11,13,-9,12,-8,10,-8,9,-8,8,-8,7,-9,6,-10,2,-6,5,-13,5,-13,5,-14,6,-14,7,-14,8,-14,8,-13,8,-12,7,-11,7,-11,6,-10,5,-10,4,-9,3,-10,2,-10,1,-11,1,-11,1,-12,1,-13,2,-14,3,-14,4,-14,5,-13,5,-12,5,-11,4,-10,1,-3,0,0,0,0,0,0,0,0]"
CSI_DATA,2,94:d9:b3:80:8c:81,-30,11,1,7,1,0,1,0,1,0,0,-93,0,13,2,2801990,0,67,0,128,1,"[67,48,4,0,0,0,0,0,0,0,-4,-7,-16,-27,-15,-27,-13,-27,-12,-25,-10,-24,-10,-21,-10,-19,-11,-16,-12,-14,-14,-13,-16,-12,-18,-12,-20,-12,-21,-13,-22,-14,-22,-15,-21,-16,-20,-16,-19,-16,-17,-16,-16,-14,-15,-13,-14,-11,-14,-9,-15,-7,-15,-6,-9,-2,-19,-3,-19,-3,-21,-3,-22,-3,-22,-4,-22,-5,-21,-6,-20,-6,-19,-7,-17,-6,-16,-5,-15,-4,-14,-2,-14,-1,-14,1,-15,2,-16,3,-18,4,-19,4,-20,3,-21,2,-21,1,-20,0,-19,-1,-18,-3,-16,-3,-4,-1,0,0,0,0,0,0,0,0]"
CSI_DATA,3,94:d9:b3:80:8c:81,-31,11,1,7,1,0,1,0,1,0,0,-93,0,13,2,2810526,0,67,0,128,1,"[67,48,4,0,0,0,0,0,0,0,-6,-1,-22,-3,-22,-4,-21,-5,-20,-5,-18,-5,-17,-4,-15,-3,-14,-2,-14,0,-14,2,-14,3,-15,4,-16,5,-17,5,-18,5,-18,4,-18,3,-18,3,-18,2,-17,2,-15,2,-14,2,-13,2,-12,3,-11,4,-10,5,-5,3,-10,8,-11,8,-11,9,-12,9,-13,9,-13,9,-13,8,-13,7,-12,6,-11,5,-10,5,-9,5,-8,6,-7,7,-7,7,-6,8,-7,9,-7,10,-7,10,-8,10,-9,10,-10,10,-10,9,-10,8,-9,7,-9,6,-2,1,0,0,0,0,0,0,0,0]"
CSI_DATA,4,94:d9:b3:80:8c:81,-31,11,1,7,1,0,1,0,1,0,0,-93,0,13,2,2835649,0,67,0,128,1,"[67,48,4,0,0,0,0,0,0,0,-5,3,-19,15,-19,14,-19,13,-19,11,-17,10,-16,10,-14,9,-12,9,-10,10,-8,12,-7,13,-7,15,-7,16,-8,17,-9,18,-10,18,-10,17,-10,17,-11,15,-11,14,-10,13,-9,12,-7,11,-6,11,-4,11,-3,11,-1,6,-1,14,-1,14,-1,15,-1,16,-2,17,-3,17,-3,16,-4,15,-4,14,-3,13,-3,12,-2,11,-1,10,0,10,2,10,3,10,4,11,4,12,4,13,3,14,2,14,1,15,0,14,0,13,-1,12,-1,11,-1,2,0,0,0,0,0,0,0,0]"
CSI_DATA,5,94:d9:b3:80:8c:81,-31,11,1,7,1,0,1,0,1,0,0,-93,0,13,2,2848462,0,67,0,128,1,"[67,48,4,0,0,0,0,0,0,0,-1,5,-2,21,-3,21,-4,20,-4,18,-4,17,-3,16,-2,14,-1,13,1,12,2,12,4,13,5,13,6,14,6,15,6,16,6,17,5,17,4,17,3,16,3,15,2,14,3,12,3,11,4,10,5,9,6,8,3,4,9,9,9,9,10,9,10,10,10,11,9,11,9,11,8,11,7,11,7,10,6,9,6,7,6,6,7,6,8,5,9,5,9,4,10,4,11,5,11,6,11,7,11,7,10,8,9,8,8,8,7,7,1,1,0,0,0,0,0,0,0,0]"
CSI_DATA,6,94:d9:b3:80:8c:81,-31,11,1,7,1,0,1,0,1,0,0,-93,0,13,2,2860318,0,67,0,128,1,"[67,48,4,0,0,0,0,0,0,0,-2,-6,-7,-22,-6,-21,-5,-21,-4,-20,-3,-19,-3,-17,-4,-15,-5,-13,-6,-12,-8,-12,-9,-12,-10,-12,-12,-13,-12,-13,-12,-14,-12,-15,-11,-15,-11,-15,-10,-15,-9,-14,-8,-13,-8,-12,-8,-11,-8,-9,-9,-8,-10,-7,-6,-4,-12,-6,-13,-6,-13,-7,-14,-8,-14,-8,-13,-9,-13,-9,-12,-9,-11,-9,-10,-8,-10,-7,-9,-6,-9,-5,-9,-4,-10,-3,-11,-3,-11,-2,-12,-2,-13,-3,-14,-3,-14,-4,-13,-5,-13,-5,-12,-6,-11,-6,-10,-6,-3,-2,0,0,0,0,0,0,0,0]"
CSI_DATA,7,94:d9:b3:80:8c:81,-30,11,1,7,1,0,1,0,1,0,0,-93,0,13,2,2867650,0,67,0,128,1,"[67,48,4,0,0,0,0,0,0,0,6,3,25,15,25,15,24,16,22,15,20,14,18,13,16,11,16,8,16,6,17,4,19,2,20,1,22,1,24,1,25,1,25,2,25,3,24,4,23,4,21,5,19,4,18,4,17,2,16,1,15,-1,15,-3,7,-3,17,-6,17,-7,18,-8,19,-7,20,-7,20,-6,20,-5,20,-4,19,-3,17,-3,16,-3,14,-4,13,-5,12,-6,12,-8,12,-9,12,-11,13,-11,14,-12,15,-11,17,-11,17,-10,18,-9,17,-7,16,-6,14,-5,3,-2,0,0,0,0,0,0,0,0]"
CSI_DATA,8,94:d9:b3:80:8c:81,-31,11,1,7,1,0,1,0,1,0,0,-93,0,13,2,2874562,0,67,0,128,1,"[67,48,4,0,0,0,0,0,0,0,-6,0,-22,1,-22,0,-21,-1,-20,-2,-18,-2,-17,-1,-15,-1,-14,1,-14,2,-13,4,-13,5,-14,6,-15,7,-16,8,-17,8,-17,7,-17,6,-17,5,-17,5,-16,4,-15,4,-13,4,-12,4,-11,4,-10,5,-9,6,-5,4,-9,9,-10,10,-10,10,-11,10,-12,10,-12,10,-12,9,-12,8,-11,7,-11,6,-10,6,-9,6,-8,7,-7,7,-6,8,-6,8,-6,9,-6,10,-6,11,-7,11,-8,11,-9,10,-10,9,-10,8,-9,7,-8,7,-2,1,0,0,0,0,0,0,0,0]"
CSI_DATA,9,94:d9:b3:80:8c:81,-31,11,1,7,1,0,1,0,1,0,0,-93,0,13,2,2881588,0,67,0,128,1,"[67,48,4,0,0,0,0,0,0,0,3,-7,13,-26,13,-25,14,-23,14,-22,13,-20,11,-18,9,-17,7,-16,4,-16,2,-17,0,-18,-1,-20,-1,-22,-1,-23,-1,-24,0,-25,1,-25,1,-24,2,-23,3,-21,3,-19,2,-18,0,-16,-1,-15,-3,-14,-4,-14,-4,-8,-8,-16,-9,-16,-9,-17,-10,-18,-9,-19,-8,-19,-7,-19,-6,-19,-6,-18,-5,-17,-5,-15,-5,-13,-6,-12,-8,-11,-9,-10,-11,-10,-12,-10,-13,-11,-14,-12,-14,-13,-13,-14,-12,-15,-11,-15,-10,-15,-9,-14,-8,-13,-2,-4,0,0,0,0,0,0,0,0]"
CSI_DATA,10,94:d9:b3:80:8c:81,-32,11,1,7,1,0,1,0,1,0,0,-93,0,13,2,2893341,0,67,0,128,1,"[67,48,4,0,0,0,0,0,0,0,-5,-3,-20,-13,-20,-13,-18,-14,-17,-13,-15,-13,-14,-11,-13,-9,-13,-7,-13,-5,-14,-4,-15,-2,-16,-2,-18,-1,-19,-1,-20,-2,-20,-3,-20,-4,-19,-4,-18,-4,-17,-4,-15,-4,-14,-4,-13,-3,-12,-1,-12,0,-12,2,-7,1,-13,4,-14,4,-15,5,-15,5,-16,5,-16,4,-16,3,-15,2,-15,2,-13,1,-12,2,-11,2,-10,3,-9,4,-9,5,-9,6,-9,7,-10,8,-11,8,-12,8,-13,8,-13,7,-13,6,-13,5,-12,4,-11,4,-3,1,0,0,0,0,0,0,0,0]"
CSI_DATA,11,94:d9:b3:80:8c:81,-32,11,1,7,1,0,1,0,1,0,0,-93,0,13,2,2912696,0,67,0,128,1,"[67,48,4,0,0,0,0,0,0,0,5,1,22,4,22,5,21,5,19,5,17,5,16,5,14,3,13,1,13,0,13,-2,14,-4,15,-5,16,-6,17,-6,18,-6,18,-5,18,-4,18,-4,17,-3,16,-2,15,-2,13,-2,12,-3,11,-4,10,-5,9,-6,4,-4,10,-10,10,-10,11,-11,11,-10,12,-10,13,-10,13,-9,13,-8,12,-7,11,-7,10,-6,8,-7,7,-7,6,-8,6,-9,5,-10,5,-11,5,-12,6,-12,7,-12,8,-12,9,-12,9,-11,9,-10,9,-9,8,-7,2,-2,0,0,0,0,0,0,0,0]"
CSI_DATA,12,94:d9:b3:80:8c:81,-32,11,1,7,1,0,1,0,1,0,0,-93,0,13,2,2921403,0,67,0,128,1,"[67,48,4,0,0,0,0,0,0,0,-6,0,-24,2,-23,1,-22,0,-21,-1,-20,-1,-18,-1,-16,0,-15,1,-14,3,-13,5,-13,7,-14,8,-15,9,-16,10,-17,10,-17,9,-18,9,-17,8,-17,7,-16,6,-15,5,-13,5,-12,6,-10,6,-9,7,-8,8,-4,5,-8,11,-8,12,-8,12,-9,13,-10,13,-11,12,-11,12,-11,11,-10,10,-9,9,-8,8,-7,8,-6,8,-4,9,-3,9,-3,10,-3,11,-3,12,-3,12,-4,13,-5,13,-6,13,-6,12,-7,11,-6,10,-6,9,-2,2,0,0,0,0,0,0,0,0]"
CSI_DATA,13,94:d9:b3:80:8c:81,-32,11,1,7,1,0,1,0,1,0,0,-93,0,13,2,2936234,0,67,0,128,1,"[67,48,4,0,0,0,0,0,0,0,-6,-1,-23,-1,-23,-1,-22,-2,-21,-3,-19,-3,-18,-2,-16,-1,-14,0,-14,2,-13,4,-14,5,-14,7,-16,8,-17,8,-18,8,-18,7,-18,6,-18,6,-18,5,-17,5,-15,4,-14,4,-12,4,-11,5,-9,6,-9,7,-5,4,-9,10,-9,11,-10,12,-10,12,-11,12,-12,11,-12,10,-11,9,-11,9,-10,8,-9,7,-8,7,-6,8,-5,8,-5,9,-4,10,-4,11,-4,11,-5,12,-5,12,-6,13,-7,12,-8,12,-8,10,-8,9,-7,8,-2,2,0,0,0,0,0,0,0,0]"
C
```
