/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.storage;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.bidi.network.BytesValue;
import org.openqa.selenium.bidi.network.Cookie;

public class PartialCookie {
    private final Map<String, Object> map = new HashMap<String, Object>();

    public PartialCookie(String name, BytesValue value, String domain) {
        this.map.put("name", name);
        this.map.put("value", value);
        this.map.put("domain", domain);
    }

    public PartialCookie path(String path) {
        this.map.put("path", path);
        return this;
    }

    public PartialCookie size(long size) {
        this.map.put("size", size);
        return this;
    }

    public PartialCookie httpOnly(boolean httpOnly) {
        this.map.put("httpOnly", httpOnly);
        return this;
    }

    public PartialCookie secure(boolean secure) {
        this.map.put("secure", secure);
        return this;
    }

    public PartialCookie sameSite(Cookie.SameSite sameSite) {
        this.map.put("sameSite", sameSite.toString());
        return this;
    }

    public PartialCookie expiry(long expiry) {
        this.map.put("expiry", expiry);
        return this;
    }

    public Map<String, Object> toMap() {
        return Map.copyOf(this.map);
    }
}

