# Contributing to Eclipse Open VSX

Thank you for your interest in the Open VSX project! The following is a set of guidelines for contributing.

## Code of Conduct

This project is governed by the [Eclipse Community Code of Conduct](CODE_OF_CONDUCT.md). By participating, you are expected to uphold this code.

## Communication

The following communication channels are available:

 * [openvsx issues](https://github.com/eclipse/openvsx/issues) - for general issues (bug reports, feature requests, etc.)
 * [open-vsx.org issues](https://github.com/EclipseFdn/open-vsx.org/issues) - for issues related to [open-vsx.org](https://open-vsx.org/) (outage reports, requests about extensions and namespaces, etc.)
 * [Slack workspace](https://join.slack.com/t/openvsxworkinggroup/shared_invite/zt-2y07y1ggy-ct3IfJljjGI6xWUQ9llv6A) - for questions and project-related discussion
 * [Developer mailing list](https://accounts.eclipse.org/mailing-list/openvsx-dev) - for organizational issues (e.g. elections of new committers)

## How to Contribute

Before your pull request can be accepted, you must electronically sign the [Eclipse Contributor Agreement](https://www.eclipse.org/legal/ECA.php).

Unless you are an [elected committer of the Open VSX project](https://projects.eclipse.org/projects/ecd.openvsx/who), you must include a `Signed-off-by` line in the commit message. This line can be generated with the [-s flag of git commit](https://git-scm.com/docs/git-commit#Documentation/git-commit.txt--s). By doing this you confirm that your contribution conforms to the Eclipse Contributor Agreement.

For more information, see the [Eclipse Foundation Project Handbook](https://www.eclipse.org/projects/handbook/#resources-commit).
