/********************************************************************************
 * Copyright (c) 2020 TypeFox and others
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 ********************************************************************************/

import React, { FunctionComponent } from 'react';

const OpenVSXLogo: FunctionComponent<{width: string, height: string, marginTop: string, prefersDarkMode: boolean }> = props => {
    return (
        <svg viewBox='0 0 725.4 131' style={{ width: props.width, height: props.height, marginTop: props.marginTop }}>
            <path
                d='M30 44.2L52.6 5H7.3zM4.6 88.5h45.3L27.2 49.4zm51 0l22.6 39.2 22.6-39.2z'
                fill='#c160ef' />
            <path
                d='M52.6 5L30 44.2h45.2zM27.2 49.4l22.7 39.1 22.6-39.1zm51 0L55.6 88.5h45.2z'
                fill='#a60ee5' />
            <path
                d='M160.2 50.1c-.1 12.7-8.1 24.9-24.3 24.9-16.2 0-24.3-12.3-24.3-25 0-13 8.1-24.8 24.3-24.8 16.3-.1 24.4 11.8 24.3 24.9zm-44.9-.1c.1 10.9 7 21.5 20.7 21.5 13.8 0 20.7-10.6 20.7-21.5 0-11.2-6.9-21.4-20.7-21.4-13.9 0-20.8 10-20.7 21.4zm53.1 38.3V40.1h3.3v8.1c2.7-5.2 8.1-8.5 14.7-8.5 9.2.3 16.5 6.5 16.5 17.5 0 11.4-7.7 17.6-17.3 17.6-5.8 0-11.2-2.8-14.1-8.5v22h-3.1zm31.2-31.2c0-9.6-6.2-14.3-13.9-14.3-7.9 0-13.8 6-13.8 14.3s6 14.3 13.8 14.3c7.7.1 13.9-4.7 13.9-14.3zm9.8 0c0-10.2 7.7-17.6 17.3-17.6 9.6 0 18.1 5.9 16.8 19.1h-30.7c.7 8 6.8 12.6 13.8 12.6 4.5 0 9.7-1.8 12.3-5.2l2.4 1.9c-3.3 4.3-9.2 6.5-14.7 6.5-9.5.2-17.2-6.5-17.2-17.3zm31-1.4c-.1-8.4-5.6-13.1-13.8-13.1-7 0-13.1 4.8-13.8 13.1h27.6zm15.1-15.6v6.1c2.6-4.7 7.4-6.6 12.1-6.7 9.1 0 15.4 5.6 15.4 15v19.6h-3.4V54.5c0-7.7-4.8-11.8-12.1-11.8-7 .1-11.9 5.4-11.9 12.4V74h-3.4V40h3.3zm95.9-14.2l-19.8 48.4h-4l-19.8-48.4h4L329.6 70l17.8-44.1h4zm37.7 9.3c-3.5-5.6-9.2-6.5-14.6-6.5-5.6 0-14.6 2.1-14.6 9.8 0 6.1 6.6 7.6 14.7 9.1 9.3 1.8 18.9 3.4 18.9 13.8-.1 10.9-11 13.5-19.1 13.5-7.5 0-16.1-3.1-19.8-10.5l3.3-1.7c3 5.9 10.5 8.7 16.5 8.7s15.4-1.7 15.4-10.2c.1-7.2-7.9-8.8-15.8-10.3-8.8-1.7-17.8-3.5-17.8-12.4-.2-10.2 10.4-13.4 18.3-13.4 6.9 0 12.9 1.1 17.6 8.2l-3 1.9zm44.6-9.3h4v.1l-16.4 23.4L439 74v.1h-4.4l-15.6-22-15.6 22H399V74l17.7-24.7L400.4 26v-.1h4.1L419 46.5l14.7-20.6zm69.7 48.2h-4.9l-16.7-18.3h-13.2v18.3h-3.7V25.9h21.2c10.5 0 15.8 7.5 15.8 15 .1 7.9-5.1 14.7-15.6 14.7l17.1 18.5zm-34.8-21.8h17.1c8.4 0 12.1-4.8 12.2-11.5.1-5.6-3.8-11.5-11.8-11.5h-17.5v23zm38.4 4.8c0-10.2 7.7-17.6 17.3-17.6 9.6 0 18.1 5.9 16.8 19.1h-30.7c.7 8 6.8 12.6 13.8 12.6 4.5 0 9.7-1.8 12.3-5.2l2.5 2c-3.3 4.3-9.2 6.5-14.7 6.5-9.6.1-17.3-6.6-17.3-17.4zm31.1-1.4c-.1-8.4-5.6-13.1-13.8-13.1-7 0-13.1 4.8-13.8 13.1h27.6zm39.1-17l2.2 1.9-3.3 3.9c2.4 2.6 4.2 6.1 4.2 11.6 0 5.9-3.5 11.9-9.2 14.5 6 2.1 9.3 6.3 9.3 12.2 0 9.2-7.2 13.6-16.2 13.6s-16.1-5-16.1-13.6h3.4c0 7 5.9 10.3 12.7 10.3s12.9-3 12.9-10.3c0-7.3-6.5-10.2-12.9-10.2-9.9 0-16-7.4-16-16.5 0-10.6 7.2-16.6 16-16.6 3.4 0 7 1.2 9.6 3.1l3.4-3.9zm-25.6 17.4c0 7 4.8 13.1 12.6 13.1 7 0 12.7-6.1 12.7-13.1 0-8.6-5.7-13.2-12.7-13.2-6.9-.1-12.6 4.3-12.6 13.2zM591.7 29c0 3.6-5.4 3.6-5.4 0s5.4-3.6 5.4 0zm-4.4 10.9v34.2h3.4V39.9h-3.4zm36.3 6.4c-3.4-3-6.8-3.6-10.6-3.6-5.3-.1-10.4 1.9-10.3 6.3.1 4.5 6.1 5.4 10.3 6.2 6.1 1 14.4 2.1 14.1 10-.2 7.5-8 9.5-14 9.5s-11.9-2.3-14.9-6.8l2.5-2.2c2.8 4.1 7.9 5.8 12.5 5.8 4.1 0 10.4-1.1 10.6-6.5.1-4.9-5.5-5.9-11.1-6.8-6.6-1.1-13.2-2.3-13.2-9.2-.1-6.7 6.6-9.6 13.5-9.5 5 0 9.3 1.4 12.7 4.5l-2.1 2.3zm18.8-16.5v10.3H654v2.8h-11.6v20.7c0 4.6 1 7.9 6.3 7.9 1.7 0 3.5-.6 5.2-1.4l1.2 2.8c-2.1 1-4.3 1.7-6.4 1.7-7.2 0-9.6-4.3-9.6-11V42.9h-7.2v-2.8h7.2v-9.9l3.3-.4zM665 40.1l.1 6.1c2.1-4.6 7-6.4 11.3-6.4 2.5-.1 5 .6 7.3 2l-1.5 2.8c-1.8-1.1-3.8-1.6-5.8-1.6-6.3.1-11.2 5.2-11.2 11.4v19.8h-3.4v-34h3.2zm55 0l-20.7 48.2h-3.6l6.3-14.6-13.6-33.6h3.7l7.9 20.1 4 9.9 3.9-9.9 8.5-20h3.6z'
                fill={props.prefersDarkMode ? '#fff' : '#000'} />
        </svg>
    );
};

export default OpenVSXLogo;
