# macOS 右键菜单 PDF 翻译功能配置教程

本教程将指导您配置 macOS 右键菜单，实现在任意位置对 PDF 文件进行快速翻译。

## 版本说明

- **当前版本**: v3.0.29
- **更新日期**: 2025-09-22
- **适配**: 新版服务器架构

## 功能效果

- 在 Finder 中右键点击任意 PDF 文件
- 选择"翻译 PDF 文档"
- 自动在原文件位置生成翻译后的 `-dual.pdf` 文件
- 全程显示进度通知
- 支持多种翻译服务（Grok、OpenAI、DeepSeek 等）

## 前置要求

1. 已完成 Zotero PDF 翻译服务的基础配置
2. 已安装必要的 Python 依赖包：
    ```bash
    conda activate zotero-pdf2zh-venv
    pip install -r server/requirements.txt
    ```
3. 服务运行在端口 8888

## 配置步骤

### 步骤 1：验证脚本安装

确认以下文件已正确创建：

- `/Users/你的用户名/Documents/zotero-pdf2zh/server/translate_pdf_client.py`
- `/Users/你的用户名/Documents/zotero-pdf2zh/macos/translate_pdf_quick_action.sh`

运行测试验证功能：

```bash
cd /Users/你的用户名/Documents/zotero-pdf2zh
conda activate zotero-pdf2zh-venv
python server/translate_pdf_client.py test.pdf
```

### 步骤 2：创建 Automator Quick Action

1. **打开 Automator**

    - 在 Spotlight 中搜索 "Automator" 并打开
    - 或者：应用程序 → Automator

2. **创建新的 Quick Action**

    - 选择"新建文稿"
    - 选择"快速操作"（Quick Action）
    - 点击"选取"

3. **配置工作流接收设置**

    - 在顶部设置：
        - 工作流程接收当前：**PDF 文件**
        - 位于：**Finder.app**
        - 图像：选择一个合适的图标（可选）
        - 颜色：选择喜欢的颜色（可选）

4. **添加运行 Shell 脚本动作**

    - 在左侧动作库中搜索"运行 Shell 脚本"
    - 双击或拖拽到右侧工作区

5. **配置 Shell 脚本**

    - Shell：**/bin/bash**
    - 传递输入：**作为自变量**
    - 脚本内容：

    ```bash
    #!/bin/bash

    # 配置路径
    SCRIPT_PATH="/Users/你的用户名/Documents/zotero-pdf2zh/macos/translate_pdf_quick_action.sh"

    # 检查脚本是否存在
    if [ ! -f "$SCRIPT_PATH" ]; then
        osascript -e "display notification \"找不到翻译脚本\" with title \"PDF翻译错误\""
        exit 1
    fi

    # 执行翻译脚本
    "$SCRIPT_PATH" "$@"
    ```

6. **保存 Quick Action**
    - 按 ⌘+S 保存
    - 名称：**翻译 PDF 文档**
    - 位置：默认（iCloud Drive 或本地）

### 步骤 3：授予必要权限

首次使用时，macOS 可能要求授予以下权限：

1. **Finder 访问权限**

    - 系统设置 → 隐私与安全性 → 隐私
    - 选择"自动化"
    - 确保 Automator 和 Finder 已勾选

2. **辅助功能权限**

    - 系统设置 → 隐私与安全性 → 辅助功能
    - 添加 Automator.app 和 Finder.app

3. **通知权限**
    - 系统设置 → 通知与专注模式
    - 找到 Terminal 或 terminal-notifier
    - 允许通知

### 步骤 4：配置 API 密钥

编辑配置文件，添加翻译服务 API：

```bash
nano ~/Documents/zotero-pdf2zh/server/config/config.json
```

示例配置（使用 Grok）：

```json
{
    "translators": [
        {
            "name": "grok",
            "envs": {
                "GROK_API_KEY": "你的API密钥",
                "GROK_MODEL": "grok-2-1212"
            }
        }
    ]
}
```

支持的翻译服务：

- **Grok** - 推荐，快速准确
- **OpenAI** - GPT-4 高质量
- **DeepSeek** - 中文优化
- **Gemini** - Google AI
- **Bing** - 免费选项

### 步骤 5：使用方法

1. 在 Finder 中找到要翻译的 PDF 文件
2. 右键点击文件
3. 选择"快速操作" → "翻译 PDF 文档"
4. 等待翻译完成（会显示通知）
5. 翻译完成后，会在同目录生成翻译文件：
    - `-mono.pdf`：纯翻译版
    - `-dual.pdf`：双栏对照版

## 故障排除

### 问题 1：右键菜单中没有出现选项

- 确认 Quick Action 已正确保存
- 重启 Finder：按住 Option 键，右键点击 Finder 图标，选择"重新开启"
- 检查系统设置 → 扩展 → Finder，确保已启用

### 问题 2：点击后没有反应

- 查看日志文件：
    ```bash
    tail -f ~/Documents/zotero-pdf2zh/logs/server.log
    ```
- 确认 Shell 脚本有执行权限：
    ```bash
    chmod +x /Users/你的用户名/Documents/zotero-pdf2zh/macos/translate_pdf_quick_action.sh
    ```

### 问题 3：服务未启动

- 检查服务状态：
    ```bash
    lsof -i :8888
    ```
- 手动启动服务：
    ```bash
    cd /Users/你的用户名/Documents/zotero-pdf2zh/macos
    ./start_server.sh start
    ```

### 问题 4：API 密钥错误

- 确认 API 密钥已正确配置
- 检查配置文件格式：
    ```bash
    python -m json.tool server/config/config.json
    ```
- 使用 v3.0.30 或更高版本（解决了 API 密钥自动清除问题）

### 问题 5：权限错误 (Operation not permitted)

如果遇到权限错误：

```bash
# 清除扩展属性
xattr -cr /Users/你的用户名/Documents/zotero-pdf2zh/macos/

# 重新设置权限
chmod +x macos/*.sh
```

## 高级配置

### 自定义翻译参数

编辑 `server/translate_pdf_client.py`，修改默认翻译参数：

```python
# 检查配置文件中的服务
for translator in config.get('translators', []):
    if translator['name'] == 'grok':
        # 使用 Grok
        service_name = 'grok'
        break
    elif translator['name'] == 'deepseek':
        # 使用 DeepSeek
        service_name = 'deepseek'
        break
```

### 添加更多输出格式

支持的输出格式：

- `-mono.pdf`：单栏翻译
- `-dual.pdf`：双栏对照（默认）
- `-compare.pdf`：左右对比
- `-single-compare.pdf`：单页对比

### 批量处理

创建批量翻译的 Quick Action：

```bash
#!/bin/bash
for pdf in "$@"; do
    /Users/你的用户名/Documents/zotero-pdf2zh/macos/translate_pdf_quick_action.sh "$pdf" &
done
wait
osascript -e "display notification \"批量翻译完成\" with title \"PDF翻译\""
```

## 性能优化

### 配置建议

1. **线程数优化**

    - 根据 CPU 核心数调整 `threadNum`
    - 建议设置为 CPU 核心数的 1.5 倍

2. **缓存管理**

    - 定期清理 `translated/` 目录
    - 保留常用翻译结果以加快访问

3. **API 配额管理**
    - 监控 API 使用量
    - 设置合理的并发限制

## 注意事项

1. **性能考虑**

    - 大文件翻译可能需要较长时间
    - 建议同时翻译的文件不超过 3 个

2. **磁盘空间**

    - 翻译后的文件会保存在原位置
    - 临时文件保存在 `server/translated/` 目录

3. **API 限制**

    - 注意翻译服务的 API 调用限制
    - 某些服务可能有并发限制

4. **隐私安全**
    - 敏感文档建议使用本地翻译（Ollama）
    - API 密钥请妥善保管

## 卸载方法

如需移除此功能：

1. 删除 Quick Action：

    - 打开 Finder
    - 前往 `~/Library/Services/`
    - 删除"翻译 PDF 文档.workflow"

2. 停止服务：

    ```bash
    cd /Users/你的用户名/Documents/zotero-pdf2zh/macos
    ./start_server.sh stop

    # 卸载 LaunchAgent
    launchctl unload ~/Library/LaunchAgents/com.user.zotero.monitor.plist
    ```

3. 删除相关文件（可选）：
    ```bash
    rm -rf ~/Documents/zotero-pdf2zh/macos/
    ```

## 更新日志

### v3.0.29 (2025-09-22)

- ✅ 适配新版服务器架构
- ✅ 修复 API 密钥自动清除问题
- ✅ 添加多种翻译服务支持
- ✅ 改进错误处理机制
- ✅ 优化通知系统

---

配置完成后，您就可以在任意位置快速翻译 PDF 文件了！如有问题，请查看日志文件或参考主文档 [README.md](README.md)。
