/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public final class InjectedClassHelper {
    private static volatile BiPredicate<ClassLoader, String> helperClassDetector;
    private static volatile BiFunction<ClassLoader, String, Class<?>> helperClassLoader;

    private InjectedClassHelper() {
    }

    public static void internalSetHelperClassDetector(BiPredicate<ClassLoader, String> helperClassDetector) {
        if (InjectedClassHelper.helperClassDetector != null) {
            return;
        }
        InjectedClassHelper.helperClassDetector = helperClassDetector;
    }

    public static boolean isHelperClass(Class<?> clazz) {
        return InjectedClassHelper.isHelperClass(clazz.getClassLoader(), clazz.getName());
    }

    public static boolean isHelperClass(ClassLoader classLoader, String className) {
        if (helperClassDetector == null) {
            return false;
        }
        return helperClassDetector.test(classLoader, className);
    }

    public static void internalSetHelperClassLoader(BiFunction<ClassLoader, String, Class<?>> helperClassLoader) {
        if (InjectedClassHelper.helperClassLoader != null) {
            return;
        }
        InjectedClassHelper.helperClassLoader = helperClassLoader;
    }

    public static Class<?> loadHelperClass(ClassLoader classLoader, String className) {
        if (helperClassLoader == null) {
            return null;
        }
        return helperClassLoader.apply(classLoader, className);
    }
}

