/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.knowm.xchart.internal.chartpart.Chart;

public class PdfboxGraphicsEncoder {
    private static final String PDF_FILE_EXTENSION = ".pdf";

    private PdfboxGraphicsEncoder() {
    }

    public static void savePdfboxGraphics(Chart chart, String fileName) throws IOException {
        PdfboxGraphicsEncoder.savePdfboxGraphics(chart, new File(PdfboxGraphicsEncoder.addFileExtension(fileName)));
    }

    public static void savePdfboxGraphics(Chart chart, File file) throws IOException {
        PdfboxGraphicsEncoder.savePdfboxGraphics(chart, (OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
    }

    public static void savePdfboxGraphics(Chart chart, OutputStream os) throws IOException {
        ArrayList<Chart> charts = new ArrayList<Chart>();
        charts.add(chart);
        PdfboxGraphicsEncoder.savePdfboxGraphics(charts, os);
    }

    public static void savePdfboxGraphics(List<? extends Chart> charts, String fileName) throws IOException {
        PdfboxGraphicsEncoder.savePdfboxGraphics(charts, new File(PdfboxGraphicsEncoder.addFileExtension(fileName)));
    }

    public static void savePdfboxGraphics(List<? extends Chart> charts, File file) throws IOException {
        PdfboxGraphicsEncoder.savePdfboxGraphics(charts, (OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
    }

    public static void savePdfboxGraphics(List<? extends Chart> charts, OutputStream os) throws IOException {
        PDDocument document = new PDDocument();
        PDRectangle mediaBox = null;
        PDPage page = null;
        PDPageContentStream contentStream = null;
        PdfBoxGraphics2D pdfBoxGraphics2D = null;
        PDFormXObject xform = null;
        for (Chart chart : charts) {
            mediaBox = new PDRectangle(chart.getWidth(), chart.getHeight());
            page = new PDPage(mediaBox);
            document.addPage(page);
            pdfBoxGraphics2D = new PdfBoxGraphics2D(document, chart.getWidth(), chart.getHeight());
            chart.paint(pdfBoxGraphics2D, chart.getWidth(), chart.getHeight());
            pdfBoxGraphics2D.dispose();
            xform = pdfBoxGraphics2D.getXFormObject();
            contentStream = new PDPageContentStream(document, page);
            contentStream.drawForm(xform);
            contentStream.close();
        }
        document.save(os);
        document.close();
    }

    private static String addFileExtension(String fileName) {
        String fileNameWithFileExtension = fileName;
        if (fileName.length() <= PDF_FILE_EXTENSION.length() || !fileName.substring(fileName.length() - PDF_FILE_EXTENSION.length(), fileName.length()).equalsIgnoreCase(PDF_FILE_EXTENSION)) {
            fileNameWithFileExtension = fileName + PDF_FILE_EXTENSION;
        }
        return fileNameWithFileExtension;
    }
}

