/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.utils.ui;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.ccbluex.liquidbounce.config.ColorValue;
import net.ccbluex.liquidbounce.config.TextValue;
import net.ccbluex.liquidbounce.config.Value;
import net.ccbluex.liquidbounce.utils.render.ColorUtils;
import net.ccbluex.liquidbounce.utils.ui.GuiExtensionsKt;
import net.minecraft.client.gui.GuiScreen;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b(\n\u0002\u0010\f\n\u0002\b\u000e\b\u0086\b\u0018\u0000 B2\u00020\u0001:\u0001BBO\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\u0005J\u000e\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0007J\u000e\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\u0005J\u000e\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\u0007J\u0006\u0010/\u001a\u00020\fJ\u0006\u00100\u001a\u00020\nJ\b\u00101\u001a\u00020\fH\u0002J\b\u00102\u001a\u00020\fH\u0002J0\u00103\u001a\u00020\f2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00072\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\tH\u0086\b\u00f8\u0001\u0000J\r\u00108\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u00109\u001a\u00020\u0005H\u00c6\u0003J\t\u0010:\u001a\u00020\u0007H\u00c6\u0003J\u0015\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\u0015\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0003JW\u0010=\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0001J\u0013\u0010>\u001a\u00020\n2\b\u0010?\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010@\u001a\u00020\u0007H\u00d6\u0001J\t\u0010A\u001a\u00020\u0005H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001e\u0010\"\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b#\u0010\u001e\"\u0004\b$\u0010 R\u0011\u0010%\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006C"}, d2={"Lnet/ccbluex/liquidbounce/utils/ui/EditableText;", "", "value", "Lnet/ccbluex/liquidbounce/config/Value;", "string", "", "cursorIndex", "", "validator", "Lkotlin/Function1;", "", "onUpdate", "", "<init>", "(Lnet/ccbluex/liquidbounce/config/Value;Ljava/lang/String;ILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getValue", "()Lnet/ccbluex/liquidbounce/config/Value;", "getString", "()Ljava/lang/String;", "setString", "(Ljava/lang/String;)V", "getCursorIndex", "()I", "setCursorIndex", "(I)V", "getValidator", "()Lkotlin/jvm/functions/Function1;", "getOnUpdate", "selectionStart", "getSelectionStart", "()Ljava/lang/Integer;", "setSelectionStart", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "selectionEnd", "getSelectionEnd", "setSelectionEnd", "cursorString", "getCursorString", "updateText", "newString", "moveCursorBy", "delta", "insertAtCursor", "newText", "deleteAtCursor", "length", "selectAll", "selectionActive", "deleteSelectionIfActive", "clearSelection", "processInput", "typedChar", "", "keyCode", "onIndexUpdate", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "Companion", "FDPClient"})
public final class EditableText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Value<?> value;
    @NotNull
    private String string;
    private int cursorIndex;
    @NotNull
    private final Function1<String, Boolean> validator;
    @NotNull
    private final Function1<String, Unit> onUpdate;
    @Nullable
    private Integer selectionStart;
    @Nullable
    private Integer selectionEnd;

    public EditableText(@NotNull Value<?> value, @NotNull String string, int cursorIndex, @NotNull Function1<? super String, Boolean> validator, @NotNull Function1<? super String, Unit> onUpdate2) {
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(string, "string");
        Intrinsics.checkNotNullParameter(validator, "validator");
        Intrinsics.checkNotNullParameter(onUpdate2, "onUpdate");
        this.value = value;
        this.string = string;
        this.cursorIndex = cursorIndex;
        this.validator = validator;
        this.onUpdate = onUpdate2;
    }

    public /* synthetic */ EditableText(Value value, String string, int n, Function1 function1, Function1 function12, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = string.length();
        }
        if ((n2 & 8) != 0) {
            function1 = EditableText::_init_$lambda$0;
        }
        this(value, string, n, function1, function12);
    }

    @NotNull
    public final Value<?> getValue() {
        return this.value;
    }

    @NotNull
    public final String getString() {
        return this.string;
    }

    public final void setString(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.string = string;
    }

    public final int getCursorIndex() {
        return this.cursorIndex;
    }

    public final void setCursorIndex(int n) {
        this.cursorIndex = n;
    }

    @NotNull
    public final Function1<String, Boolean> getValidator() {
        return this.validator;
    }

    @NotNull
    public final Function1<String, Unit> getOnUpdate() {
        return this.onUpdate;
    }

    @Nullable
    public final Integer getSelectionStart() {
        return this.selectionStart;
    }

    public final void setSelectionStart(@Nullable Integer n) {
        this.selectionStart = n;
    }

    @Nullable
    public final Integer getSelectionEnd() {
        return this.selectionEnd;
    }

    public final void setSelectionEnd(@Nullable Integer n) {
        this.selectionEnd = n;
    }

    @NotNull
    public final String getCursorString() {
        return StringsKt.take(this.string, this.cursorIndex);
    }

    public final void updateText(@NotNull String newString) {
        Intrinsics.checkNotNullParameter(newString, "newString");
        if (this.validator.invoke(newString).booleanValue()) {
            this.onUpdate.invoke(newString);
        }
    }

    public final void moveCursorBy(int delta) {
        this.cursorIndex = RangesKt.coerceIn(this.cursorIndex + delta, 0, this.string.length());
        this.clearSelection();
    }

    public final void insertAtCursor(@NotNull String newText) {
        Intrinsics.checkNotNullParameter(newText, "newText");
        this.deleteSelectionIfActive();
        String newString = StringsKt.take(this.string, this.cursorIndex) + newText + StringsKt.drop(this.string, this.cursorIndex);
        if (this.validator.invoke(newString).booleanValue()) {
            this.string = newString;
            this.cursorIndex += newText.length();
        }
    }

    public final void deleteAtCursor(int length) {
        if (this.selectionActive()) {
            this.deleteSelectionIfActive();
        } else if (this.cursorIndex > 0) {
            this.string = StringsKt.take(this.string, this.cursorIndex - length) + StringsKt.drop(this.string, this.cursorIndex);
            this.cursorIndex -= length;
        }
    }

    public final void selectAll() {
        this.selectionStart = 0;
        this.selectionEnd = this.string.length();
        this.cursorIndex = this.string.length();
    }

    public final boolean selectionActive() {
        return this.selectionStart != null && this.selectionEnd != null;
    }

    private final void deleteSelectionIfActive() {
        if (this.selectionActive()) {
            Integer n = this.selectionStart;
            Intrinsics.checkNotNull(n);
            int n2 = n;
            Integer n3 = this.selectionEnd;
            Intrinsics.checkNotNull(n3);
            int start = Math.min(n2, n3);
            Integer n4 = this.selectionStart;
            Intrinsics.checkNotNull(n4);
            int n5 = n4;
            Integer n6 = this.selectionEnd;
            Intrinsics.checkNotNull(n6);
            int end = Math.max(n5, n6);
            this.string = StringsKt.take(this.string, start) + StringsKt.drop(this.string, end);
            this.cursorIndex = start;
            this.clearSelection();
        }
    }

    private final void clearSelection() {
        this.selectionStart = null;
        this.selectionEnd = null;
    }

    public final void processInput(char typedChar, int keyCode, @NotNull Function1<? super Integer, Unit> onIndexUpdate) {
        Intrinsics.checkNotNullParameter(onIndexUpdate, "onIndexUpdate");
        boolean $i$f$processInput = false;
        if (keyCode == 14) {
            this.deleteAtCursor(1);
        } else {
            int[] nArray = new int[]{203, 205};
            if (ArraysKt.contains(nArray, keyCode)) {
                this.moveCursorBy(keyCode == 203 ? -1 : 1);
            } else {
                nArray = new int[]{208, 200};
                if (ArraysKt.contains(nArray, keyCode)) {
                    onIndexUpdate.invoke((Integer)(keyCode == 208 ? 1 : -1));
                } else if (keyCode == 46 && GuiExtensionsKt.isCtrlPressed() && this.selectionActive()) {
                    Integer n = this.getSelectionStart();
                    Intrinsics.checkNotNull(n);
                    int n2 = n;
                    Integer n3 = this.getSelectionEnd();
                    Intrinsics.checkNotNull(n3);
                    int start = Math.min(n2, n3);
                    Integer n4 = this.getSelectionStart();
                    Intrinsics.checkNotNull(n4);
                    int n5 = n4;
                    Integer n6 = this.getSelectionEnd();
                    Intrinsics.checkNotNull(n6);
                    int end = Math.max(n5, n6);
                    String string = this.getString().substring(start, end);
                    Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                    GuiScreen.func_146275_d((String)string);
                } else if (keyCode == 47 && GuiExtensionsKt.isCtrlPressed()) {
                    String string = GuiScreen.func_146277_j();
                    if (string != null) {
                        String pastedText = string;
                        boolean bl = false;
                        this.insertAtCursor(pastedText);
                    }
                } else if (keyCode == 30 && GuiExtensionsKt.isCtrlPressed()) {
                    this.selectAll();
                } else if (GuiExtensionsKt.isValidInput(typedChar, this)) {
                    this.insertAtCursor(String.valueOf(typedChar));
                }
            }
        }
        this.updateText(this.getString());
    }

    @NotNull
    public final Value<?> component1() {
        return this.value;
    }

    @NotNull
    public final String component2() {
        return this.string;
    }

    public final int component3() {
        return this.cursorIndex;
    }

    @NotNull
    public final Function1<String, Boolean> component4() {
        return this.validator;
    }

    @NotNull
    public final Function1<String, Unit> component5() {
        return this.onUpdate;
    }

    @NotNull
    public final EditableText copy(@NotNull Value<?> value, @NotNull String string, int cursorIndex, @NotNull Function1<? super String, Boolean> validator, @NotNull Function1<? super String, Unit> onUpdate2) {
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(string, "string");
        Intrinsics.checkNotNullParameter(validator, "validator");
        Intrinsics.checkNotNullParameter(onUpdate2, "onUpdate");
        return new EditableText(value, string, cursorIndex, validator, onUpdate2);
    }

    public static /* synthetic */ EditableText copy$default(EditableText editableText, Value value, String string, int n, Function1 function1, Function1 function12, int n2, Object object) {
        if ((n2 & 1) != 0) {
            value = editableText.value;
        }
        if ((n2 & 2) != 0) {
            string = editableText.string;
        }
        if ((n2 & 4) != 0) {
            n = editableText.cursorIndex;
        }
        if ((n2 & 8) != 0) {
            function1 = editableText.validator;
        }
        if ((n2 & 0x10) != 0) {
            function12 = editableText.onUpdate;
        }
        return editableText.copy(value, string, n, function1, function12);
    }

    @NotNull
    public String toString() {
        return "EditableText(value=" + this.value + ", string=" + this.string + ", cursorIndex=" + this.cursorIndex + ", validator=" + this.validator + ", onUpdate=" + this.onUpdate + ')';
    }

    public int hashCode() {
        int result2 = this.value.hashCode();
        result2 = result2 * 31 + this.string.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.cursorIndex);
        result2 = result2 * 31 + this.validator.hashCode();
        result2 = result2 * 31 + this.onUpdate.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EditableText)) {
            return false;
        }
        EditableText editableText = (EditableText)other;
        if (!Intrinsics.areEqual(this.value, editableText.value)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.string, editableText.string)) {
            return false;
        }
        if (this.cursorIndex != editableText.cursorIndex) {
            return false;
        }
        if (!Intrinsics.areEqual(this.validator, editableText.validator)) {
            return false;
        }
        return Intrinsics.areEqual(this.onUpdate, editableText.onUpdate);
    }

    private static final boolean _init_$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lnet/ccbluex/liquidbounce/utils/ui/EditableText$Companion;", "", "<init>", "()V", "forTextValue", "Lnet/ccbluex/liquidbounce/utils/ui/EditableText;", "value", "Lnet/ccbluex/liquidbounce/config/TextValue;", "forRGBA", "Lnet/ccbluex/liquidbounce/config/ColorValue;", "index", "", "FDPClient"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EditableText forTextValue(@NotNull TextValue value) {
            Intrinsics.checkNotNullParameter(value, "value");
            return new EditableText(value, (String)value.get(), 0, null, arg_0 -> Companion.forTextValue$lambda$0(value, arg_0), 12, null);
        }

        @NotNull
        public final EditableText forRGBA(@NotNull ColorValue value, int index) {
            int n;
            Intrinsics.checkNotNullParameter(value, "value");
            Color color = (Color)value.get();
            switch (index) {
                case 0: {
                    n = color.getRed();
                    break;
                }
                case 1: {
                    n = color.getGreen();
                    break;
                }
                case 2: {
                    n = color.getBlue();
                    break;
                }
                case 3: {
                    n = color.getAlpha();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid RGBA index");
                }
            }
            int component = n;
            value.setRgbaIndex(index);
            return new EditableText(value, String.valueOf(component), 0, Companion::forRGBA$lambda$1, arg_0 -> Companion.forRGBA$lambda$2(component, value, index, arg_0), 4, null);
        }

        private static final Unit forTextValue$lambda$0(TextValue $value, String it) {
            Intrinsics.checkNotNullParameter(it, "it");
            Value.set$default($value, it, false, 2, null);
            return Unit.INSTANCE;
        }

        private static final boolean forRGBA$lambda$1(String it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return ColorUtils.INSTANCE.isValidColorInput(it);
        }

        private static final Unit forRGBA$lambda$2(int $component, ColorValue $value, int $index, String newText) {
            Color color;
            Intrinsics.checkNotNullParameter(newText, "newText");
            Integer n = StringsKt.toIntOrNull(newText);
            int newValue = n != null ? RangesKt.coerceIn(n, 0, 255) : $component;
            Color currentColor = (Color)$value.get();
            switch ($index) {
                case 0: {
                    color = new Color(newValue, currentColor.getGreen(), currentColor.getBlue(), currentColor.getAlpha());
                    break;
                }
                case 1: {
                    color = new Color(currentColor.getRed(), newValue, currentColor.getBlue(), currentColor.getAlpha());
                    break;
                }
                case 2: {
                    color = new Color(currentColor.getRed(), currentColor.getGreen(), newValue, currentColor.getAlpha());
                    break;
                }
                case 3: {
                    color = new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), newValue);
                    break;
                }
                default: {
                    color = currentColor;
                }
            }
            Color newColor = color;
            Value.set$default($value, newColor, false, 2, null);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

