/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.utils.rotation;

import javax.vecmath.Vector2f;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.ccbluex.liquidbounce.event.StrafeEvent;
import net.ccbluex.liquidbounce.utils.client.MinecraftInstance;
import net.ccbluex.liquidbounce.utils.extensions.MathExtensionsKt;
import net.ccbluex.liquidbounce.utils.rotation.RotationUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 .2\u00020\u0001:\u0001.B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000J$\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cJ\u0010\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u001f\u001a\u00020\u0003J\u0018\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u001cJ\u0010\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0014\u001a\u00020\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010(\u001a\u00020\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020-H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006/"}, d2={"Lnet/ccbluex/liquidbounce/utils/rotation/Rotation;", "Lnet/ccbluex/liquidbounce/utils/client/MinecraftInstance;", "yaw", "", "pitch", "<init>", "(FF)V", "getYaw", "()F", "setYaw", "(F)V", "getPitch", "setPitch", "abs", "getAbs", "()Lnet/ccbluex/liquidbounce/utils/rotation/Rotation;", "minus", "other", "plus", "times", "value", "div", "plusDiff", "toPlayer", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "changeYaw", "", "changePitch", "fixedSensitivity", "sensitivity", "applyStrafeToPlayer", "event", "Lnet/ccbluex/liquidbounce/event/StrafeEvent;", "strict", "withLimitedPitch", "component1", "component2", "copy", "equals", "", "hashCode", "", "toString", "", "Companion", "FDPClient"})
public final class Rotation
implements MinecraftInstance {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float yaw;
    private float pitch;
    @NotNull
    private static final Rotation ZERO = new Rotation(0.0f, 0.0f);

    public Rotation(float yaw, float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public final float getYaw() {
        return this.yaw;
    }

    public final void setYaw(float f) {
        this.yaw = f;
    }

    public final float getPitch() {
        return this.pitch;
    }

    public final void setPitch(float f) {
        this.pitch = f;
    }

    @NotNull
    public final Rotation getAbs() {
        return new Rotation(Math.abs(this.yaw), Math.abs(this.pitch));
    }

    @NotNull
    public final Rotation minus(@NotNull Rotation other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Rotation(this.yaw - other.yaw, this.pitch - other.pitch);
    }

    @NotNull
    public final Rotation plus(@NotNull Rotation other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Rotation(this.yaw + other.yaw, this.pitch + other.pitch);
    }

    @NotNull
    public final Rotation times(float value) {
        return new Rotation(this.yaw * value, this.pitch * value);
    }

    @NotNull
    public final Rotation div(float value) {
        return new Rotation(this.yaw / value, this.pitch / value);
    }

    @NotNull
    public final Rotation plusDiff(@NotNull Rotation other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.plus(Companion.of(RotationUtils.INSTANCE.angleDifferences(other, this)));
    }

    public final void toPlayer(@NotNull EntityPlayer player, boolean changeYaw, boolean changePitch) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (Float.isNaN(this.yaw) || Float.isNaN(this.pitch) || this.pitch > 90.0f || this.pitch < -90.0f) {
            return;
        }
        Rotation.fixedSensitivity$default(this, 0.0f, 1, null);
        if (changeYaw) {
            player.field_70177_z = this.yaw;
        }
        if (changePitch) {
            player.field_70125_A = this.pitch;
        }
    }

    public static /* synthetic */ void toPlayer$default(Rotation rotation, EntityPlayer entityPlayer, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            entityPlayer = (EntityPlayer)rotation.getMc().field_71439_g;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        rotation.toPlayer(entityPlayer, bl, bl2);
    }

    @NotNull
    public final Rotation fixedSensitivity(float sensitivity) {
        float gcd = RotationUtils.INSTANCE.getFixedAngleDelta(sensitivity);
        this.yaw = RotationUtils.INSTANCE.getFixedSensitivityAngle(this.yaw, RotationUtils.INSTANCE.getServerRotation().yaw, gcd);
        this.pitch = RotationUtils.INSTANCE.getFixedSensitivityAngle(this.pitch, RotationUtils.INSTANCE.getServerRotation().pitch, gcd);
        return Rotation.withLimitedPitch$default(this, 0.0f, 1, null);
    }

    public static /* synthetic */ Rotation fixedSensitivity$default(Rotation rotation, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = rotation.getMc().field_71474_y.field_74341_c;
        }
        return rotation.fixedSensitivity(f);
    }

    public final void applyStrafeToPlayer(@NotNull StrafeEvent event, boolean strict2) {
        Intrinsics.checkNotNullParameter(event, "event");
        EntityPlayerSP player = this.getMc().field_71439_g;
        float diff = MathExtensionsKt.toRadians(player.field_70177_z - this.yaw);
        float friction = event.getFriction();
        float calcForward = 0.0f;
        float calcStrafe = 0.0f;
        if (!strict2) {
            Pair<Float, Float> pair = new Pair<Float, Float>(Float.valueOf(event.getStrafe() / 0.98f), Float.valueOf(event.getForward() / 0.98f));
            float strafe = ((Number)pair.component1()).floatValue();
            float forward = ((Number)pair.component2()).floatValue();
            float modifiedForward = (float)Math.ceil(Math.abs(forward)) * Math.signum(forward);
            float modifiedStrafe = (float)Math.ceil(Math.abs(strafe)) * Math.signum(strafe);
            calcForward = (float)Math.rint(modifiedForward * MathHelper.func_76134_b((float)diff) + modifiedStrafe * MathHelper.func_76126_a((float)diff));
            calcStrafe = (float)Math.rint(modifiedStrafe * MathHelper.func_76134_b((float)diff) - modifiedForward * MathHelper.func_76126_a((float)diff));
            float f = !(event.getForward() == 0.0f) ? event.getForward() : event.getStrafe();
            calcForward *= Math.abs(f);
            calcStrafe *= Math.abs(f);
        } else {
            calcForward = event.getForward();
            calcStrafe = event.getStrafe();
        }
        float d2 = calcStrafe * calcStrafe + calcForward * calcForward;
        if (d2 >= 1.0E-4f) {
            d2 = friction / RangesKt.coerceAtLeast((float)Math.sqrt(d2), 1.0f);
            float yawRad = MathExtensionsKt.toRadians(this.yaw);
            float yawSin = MathHelper.func_76126_a((float)yawRad);
            float yawCos = MathHelper.func_76134_b((float)yawRad);
            player.field_70159_w += (double)((calcStrafe *= d2) * yawCos - (calcForward *= d2) * yawSin);
            player.field_70179_y += (double)(calcForward * yawCos + calcStrafe * yawSin);
        }
    }

    public static /* synthetic */ void applyStrafeToPlayer$default(Rotation rotation, StrafeEvent strafeEvent, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        rotation.applyStrafeToPlayer(strafeEvent, bl);
    }

    @NotNull
    public final Rotation withLimitedPitch(float value) {
        this.pitch = RangesKt.coerceIn(this.pitch, -value, value);
        return this;
    }

    public static /* synthetic */ Rotation withLimitedPitch$default(Rotation rotation, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 90.0f;
        }
        return rotation.withLimitedPitch(f);
    }

    public final float component1() {
        return this.yaw;
    }

    public final float component2() {
        return this.pitch;
    }

    @NotNull
    public final Rotation copy(float yaw, float pitch) {
        return new Rotation(yaw, pitch);
    }

    public static /* synthetic */ Rotation copy$default(Rotation rotation, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            f = rotation.yaw;
        }
        if ((n & 2) != 0) {
            f2 = rotation.pitch;
        }
        return rotation.copy(f, f2);
    }

    @NotNull
    public String toString() {
        return "Rotation(yaw=" + this.yaw + ", pitch=" + this.pitch + ')';
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.yaw);
        result2 = result2 * 31 + Float.hashCode(this.pitch);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rotation)) {
            return false;
        }
        Rotation rotation = (Rotation)other;
        if (Float.compare(this.yaw, rotation.yaw) != 0) {
            return false;
        }
        return Float.compare(this.pitch, rotation.pitch) == 0;
    }

    @Override
    @NotNull
    public Minecraft getMc() {
        return MinecraftInstance.DefaultImpls.getMc(this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lnet/ccbluex/liquidbounce/utils/rotation/Rotation$Companion;", "", "<init>", "()V", "ZERO", "Lnet/ccbluex/liquidbounce/utils/rotation/Rotation;", "getZERO", "()Lnet/ccbluex/liquidbounce/utils/rotation/Rotation;", "of", "vec", "Ljavax/vecmath/Vector2f;", "FDPClient"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Rotation getZERO() {
            return ZERO;
        }

        @NotNull
        public final Rotation of(@NotNull Vector2f vec) {
            Intrinsics.checkNotNullParameter(vec, "vec");
            return new Rotation(vec.x, vec.y);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

