/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.utils.render.animation;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.ccbluex.liquidbounce.utils.render.animation.Animation;
import net.ccbluex.liquidbounce.utils.render.animation.AnimationType;
import net.ccbluex.liquidbounce.utils.render.animation.AnimationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u001f\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020 J\u0006\u0010&\u001a\u00020 J&\u0010*\u001a\u00020 2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010,\u001a\u00020 2\u0006\u0010'\u001a\u00020\u001aR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010'\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001a8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010\u001c\"\u0004\b)\u0010\u001e\u00a8\u0006-"}, d2={"Lnet/ccbluex/liquidbounce/utils/render/animation/ColorAnimation;", "", "<init>", "()V", "r", "Lnet/ccbluex/liquidbounce/utils/render/animation/Animation;", "getR", "()Lnet/ccbluex/liquidbounce/utils/render/animation/Animation;", "setR", "(Lnet/ccbluex/liquidbounce/utils/render/animation/Animation;)V", "g", "getG", "setG", "b", "getB", "setB", "a", "getA", "setA", "first", "", "getFirst", "()Z", "setFirst", "(Z)V", "end", "Ljava/awt/Color;", "getEnd", "()Ljava/awt/Color;", "setEnd", "(Ljava/awt/Color;)V", "start", "", "duration", "", "type", "Lnet/ccbluex/liquidbounce/utils/render/animation/AnimationType;", "update", "reset", "color", "getColor", "setColor", "fstart", "color1", "base", "FDPClient"})
public final class ColorAnimation {
    @NotNull
    private Animation r = new Animation();
    @NotNull
    private Animation g = new Animation();
    @NotNull
    private Animation b = new Animation();
    @NotNull
    private Animation a = new Animation();
    private boolean first = true;
    @Nullable
    private Color end;

    @NotNull
    public final Animation getR() {
        return this.r;
    }

    public final void setR(@NotNull Animation animation) {
        Intrinsics.checkNotNullParameter(animation, "<set-?>");
        this.r = animation;
    }

    @NotNull
    public final Animation getG() {
        return this.g;
    }

    public final void setG(@NotNull Animation animation) {
        Intrinsics.checkNotNullParameter(animation, "<set-?>");
        this.g = animation;
    }

    @NotNull
    public final Animation getB() {
        return this.b;
    }

    public final void setB(@NotNull Animation animation) {
        Intrinsics.checkNotNullParameter(animation, "<set-?>");
        this.b = animation;
    }

    @NotNull
    public final Animation getA() {
        return this.a;
    }

    public final void setA(@NotNull Animation animation) {
        Intrinsics.checkNotNullParameter(animation, "<set-?>");
        this.a = animation;
    }

    public final boolean getFirst() {
        return this.first;
    }

    public final void setFirst(boolean bl) {
        this.first = bl;
    }

    @Nullable
    public final Color getEnd() {
        return this.end;
    }

    public final void setEnd(@Nullable Color color) {
        this.end = color;
    }

    public final void start(@NotNull Color start, @NotNull Color end, float duration, @NotNull AnimationType type) {
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(end, "end");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        this.end = end;
        this.r.start(start.getRed(), end.getRed(), duration, type);
        this.g.start(start.getGreen(), end.getGreen(), duration, type);
        this.b.start(start.getBlue(), end.getBlue(), duration, type);
        this.a.start(start.getAlpha(), end.getAlpha(), duration, type);
    }

    public final void update() {
        if (this.end == null) {
            return;
        }
        if (this.first) {
            Color color = this.end;
            Intrinsics.checkNotNull(color, "null cannot be cast to non-null type java.awt.Color");
            this.setColor(color);
            this.first = false;
            return;
        }
        this.r.update();
        this.g.update();
        this.b.update();
        this.a.update();
    }

    public final void reset() {
        this.r.reset();
        this.g.reset();
        this.b.reset();
        this.a.reset();
    }

    @NotNull
    public final Color getColor() {
        return new Color((int)RangesKt.coerceIn(this.r.getValue(), 0.0, 255.0), (int)RangesKt.coerceIn(this.g.getValue(), 0.0, 255.0), (int)RangesKt.coerceIn(this.b.getValue(), 0.0, 255.0), (int)RangesKt.coerceIn(this.a.getValue(), 0.0, 255.0));
    }

    public final void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        this.r.setValue(color.getRed());
        this.g.setValue(color.getGreen());
        this.b.setValue(color.getBlue());
        this.a.setValue(color.getAlpha());
    }

    public final void fstart(@NotNull Color color, @NotNull Color color1, float duration, @NotNull AnimationType type) {
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(color1, "color1");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        this.end = color1;
        this.r.fstart(color.getRed(), color1.getRed(), duration, type);
        this.g.fstart(color.getGreen(), color1.getGreen(), duration, type);
        this.b.fstart(color.getBlue(), color1.getBlue(), duration, type);
        this.a.fstart(color.getAlpha(), color1.getAlpha(), duration, type);
    }

    public final void base(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        this.r.setValue(AnimationUtil.INSTANCE.base(this.r.getValue(), color.getRed(), 0.1));
        this.g.setValue(AnimationUtil.INSTANCE.base(this.g.getValue(), color.getGreen(), 0.1));
        this.b.setValue(AnimationUtil.INSTANCE.base(this.b.getValue(), color.getBlue(), 0.1));
        this.a.setValue(AnimationUtil.INSTANCE.base(this.a.getValue(), color.getAlpha(), 0.1));
    }
}

