/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.utils.pathfinding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Vector3d;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import me.liuli.path.Cell;
import me.liuli.path.Pathfinder;
import net.ccbluex.liquidbounce.utils.block.MinecraftWorldProvider;
import net.ccbluex.liquidbounce.utils.client.MinecraftInstance;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bJ,\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJD\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bJ,\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bJ8\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002J>\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u001bj\b\u0012\u0004\u0012\u00020\u000b`\u001c2\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u001bj\b\u0012\u0004\u0012\u00020\u001e`\u001c2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 \u00a8\u0006!"}, d2={"Lnet/ccbluex/liquidbounce/utils/pathfinding/PathUtils;", "Lnet/ccbluex/liquidbounce/utils/client/MinecraftInstance;", "<init>", "()V", "findBlinkPath", "", "Ljavax/vecmath/Vector3d;", "tpX", "", "tpY", "tpZ", "Lnet/minecraft/util/Vec3;", "dist", "curX", "curY", "curZ", "dashDistance", "findPath", "offset", "getDistance", "x1", "y1", "z1", "x2", "y2", "z2", "simplifyPath", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "path", "Lme/liuli/path/Cell;", "worldProvider", "Lnet/ccbluex/liquidbounce/utils/block/MinecraftWorldProvider;", "FDPClient"})
public final class PathUtils
implements MinecraftInstance {
    @NotNull
    public static final PathUtils INSTANCE = new PathUtils();

    private PathUtils() {
    }

    @NotNull
    public final List<Vector3d> findBlinkPath(double tpX, double tpY, double tpZ) {
        List positions = new ArrayList();
        double curX = this.getMc().field_71439_g.field_70165_t;
        double curY = this.getMc().field_71439_g.field_70163_u;
        double curZ = this.getMc().field_71439_g.field_70161_v;
        double distance = Math.abs(curX - tpX) + Math.abs(curY - tpY) + Math.abs(curZ - tpZ);
        int count2 = 0;
        while (distance > 0.0) {
            distance = Math.abs(curX - tpX) + Math.abs(curY - tpY) + Math.abs(curZ - tpZ);
            double diffX = curX - tpX;
            double diffY = curY - tpY;
            double diffZ = curZ - tpZ;
            double offset = !(count2 & true) ? 0.4 : 0.1;
            double minX = RangesKt.coerceIn(diffX, -offset, offset);
            double minY = RangesKt.coerceIn(diffY, -0.25, 0.25);
            double minZ = RangesKt.coerceIn(diffZ, -offset, offset);
            ((Collection)positions).add(new Vector3d(curX -= minX, curY -= minY, curZ -= minZ));
            ++count2;
        }
        return positions;
    }

    @NotNull
    public final List<Vec3> findBlinkPath(double tpX, double tpY, double tpZ, double dist) {
        return this.findBlinkPath(this.getMc().field_71439_g.field_70165_t, this.getMc().field_71439_g.field_70163_u, this.getMc().field_71439_g.field_70161_v, tpX, tpY, tpZ, dist);
    }

    @NotNull
    public final List<Vec3> findBlinkPath(double curX, double curY, double curZ, double tpX, double tpY, double tpZ, double dashDistance) {
        MinecraftWorldProvider worldProvider = new MinecraftWorldProvider((World)this.getMc().field_71441_e);
        Pathfinder pathfinder = new Pathfinder(new Cell((int)curX, (int)curY, (int)curZ), new Cell((int)tpX, (int)tpY, (int)tpZ), Pathfinder.COMMON_NEIGHBORS, worldProvider);
        ArrayList<Cell> arrayList = pathfinder.findPath(3000);
        Intrinsics.checkNotNullExpressionValue(arrayList, "findPath(...)");
        return this.simplifyPath(arrayList, dashDistance, worldProvider);
    }

    @NotNull
    public final List<Vector3d> findPath(double tpX, double tpY, double tpZ, double offset) {
        List positions = new ArrayList();
        double steps = Math.ceil(this.getDistance(this.getMc().field_71439_g.field_70165_t, this.getMc().field_71439_g.field_70163_u, this.getMc().field_71439_g.field_70161_v, tpX, tpY, tpZ) / offset);
        double dX = tpX - this.getMc().field_71439_g.field_70165_t;
        double dY = tpY - this.getMc().field_71439_g.field_70163_u;
        double dZ = tpZ - this.getMc().field_71439_g.field_70161_v;
        for (double d2 = 1.0; d2 <= steps; d2 += 1.0) {
            ((Collection)positions).add(new Vector3d(this.getMc().field_71439_g.field_70165_t + dX * d2 / steps, this.getMc().field_71439_g.field_70163_u + dY * d2 / steps, this.getMc().field_71439_g.field_70161_v + dZ * d2 / steps));
        }
        return positions;
    }

    private final double getDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double xDiff = x1 - x2;
        double yDiff = y1 - y2;
        double zDiff = z1 - z2;
        return Math.sqrt(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff);
    }

    @NotNull
    public final ArrayList<Vec3> simplifyPath(@NotNull ArrayList<Cell> path2, double dashDistance, @NotNull MinecraftWorldProvider worldProvider) {
        Vec3 lastLoc;
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(worldProvider, "worldProvider");
        ArrayList<Vec3> finalPath = new ArrayList<Vec3>();
        Cell cell = path2.get(0);
        Intrinsics.checkNotNullExpressionValue(cell, "get(...)");
        Cell cell2 = cell;
        Vec3 vec3 = null;
        Vec3 lastDashLoc = lastLoc = new Vec3((double)cell2.x + 0.5, (double)cell2.y, (double)cell2.z + 0.5);
        int n = path2.size() - 1;
        for (int i = 1; i < n; ++i) {
            cell2 = path2.get(i);
            vec3 = new Vec3((double)cell2.x + 0.5, (double)cell2.y, (double)cell2.z + 0.5);
            boolean canContinue = true;
            if (vec3.func_72436_e(lastDashLoc) > dashDistance * dashDistance) {
                canContinue = false;
            } else {
                double smallX = Math.min(lastDashLoc.field_72450_a, vec3.field_72450_a);
                double smallY = Math.min(lastDashLoc.field_72448_b, vec3.field_72448_b);
                double smallZ = Math.min(lastDashLoc.field_72449_c, vec3.field_72449_c);
                double bigX = Math.max(lastDashLoc.field_72450_a, vec3.field_72450_a);
                double bigY = Math.max(lastDashLoc.field_72448_b, vec3.field_72448_b);
                double bigZ = Math.max(lastDashLoc.field_72449_c, vec3.field_72449_c);
                int x = (int)smallX;
                block1: while ((double)x <= bigX) {
                    int y = (int)smallY;
                    while ((double)y <= bigY) {
                        int z = (int)smallZ;
                        while ((double)z <= bigZ) {
                            if (worldProvider.isBlocked(x, y, z)) {
                                canContinue = false;
                                break block1;
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            if (!canContinue) {
                finalPath.add(lastLoc);
                lastDashLoc = lastLoc;
            }
            lastLoc = vec3;
        }
        return finalPath;
    }

    @Override
    @NotNull
    public Minecraft getMc() {
        return MinecraftInstance.DefaultImpls.getMc(this);
    }
}

