/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.file.configs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.ccbluex.liquidbounce.FDPClient;
import net.ccbluex.liquidbounce.config.Value;
import net.ccbluex.liquidbounce.features.module.Module;
import net.ccbluex.liquidbounce.features.module.ModuleManager;
import net.ccbluex.liquidbounce.features.module.modules.client.IRCModule;
import net.ccbluex.liquidbounce.features.module.modules.client.TargetModule;
import net.ccbluex.liquidbounce.file.FileConfig;
import net.ccbluex.liquidbounce.file.FileManager;
import net.ccbluex.liquidbounce.file.configs.models.ClientConfiguration;
import net.ccbluex.liquidbounce.handler.cape.CapeService;
import net.ccbluex.liquidbounce.handler.payload.ClientFixes;
import net.ccbluex.liquidbounce.utils.io.FileExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lnet/ccbluex/liquidbounce/file/configs/ValuesConfig;", "Lnet/ccbluex/liquidbounce/file/FileConfig;", "file", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "loadConfig", "", "saveConfig", "FDPClient"})
public final class ValuesConfig
extends FileConfig {
    public ValuesConfig(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        super(file);
    }

    @Override
    public void loadConfig() throws IOException {
        Object prevVersion;
        JsonElement jsonElement = FileExtensionsKt.readJson(this.getFile());
        JsonObject jsonObject = jsonElement instanceof JsonObject ? (JsonObject)jsonElement : null;
        if (jsonObject == null) {
            return;
        }
        JsonObject json = jsonObject;
        Object object = json.get("ClientVersion");
        if (object == null || (object = object.getAsString()) == null) {
            object = "unknown";
        }
        if (!Intrinsics.areEqual(prevVersion = object, FDPClient.INSTANCE.getClientVersionText())) {
            FileManager.INSTANCE.backupAllConfigs((String)prevVersion, FDPClient.INSTANCE.getClientVersionText());
        }
        for (Map.Entry entry : json.entrySet()) {
            Module module2;
            JsonObject jsonValue;
            Intrinsics.checkNotNull(entry);
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (StringsKt.equals(key, "CommandPrefix", true)) {
                FDPClient.INSTANCE.getCommandManager().setPrefix(value.getAsString());
                continue;
            }
            if (StringsKt.equals(key, "targets", true)) {
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type com.google.gson.JsonObject");
                jsonValue = (JsonObject)value;
                if (jsonValue.has("TargetPlayer")) {
                    TargetModule.INSTANCE.setPlayerValue(jsonValue.get("TargetPlayer").getAsBoolean());
                }
                if (jsonValue.has("TargetMobs")) {
                    TargetModule.INSTANCE.setMobValue(jsonValue.get("TargetMobs").getAsBoolean());
                }
                if (jsonValue.has("TargetAnimals")) {
                    TargetModule.INSTANCE.setAnimalValue(jsonValue.get("TargetAnimals").getAsBoolean());
                }
                if (jsonValue.has("TargetInvisible")) {
                    TargetModule.INSTANCE.setInvisibleValue(jsonValue.get("TargetInvisible").getAsBoolean());
                }
                if (!jsonValue.has("TargetDead")) continue;
                TargetModule.INSTANCE.setDeadValue(jsonValue.get("TargetDead").getAsBoolean());
                continue;
            }
            if (StringsKt.equals(key, ClientFixes.INSTANCE.getName(), true)) {
                Intrinsics.checkNotNull(value);
                ClientFixes.INSTANCE.fromJson(value);
                continue;
            }
            if (StringsKt.equals(key, "liquidchat", true)) {
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type com.google.gson.JsonObject");
                jsonValue = (JsonObject)value;
                if (!jsonValue.has("token")) continue;
                IRCModule.INSTANCE.setJwtToken(jsonValue.get("token").getAsString());
                continue;
            }
            if (StringsKt.equals(key, "DonatorCape", true)) {
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type com.google.gson.JsonObject");
                jsonValue = (JsonObject)value;
                if (!jsonValue.has("TransferCode")) continue;
                CapeService.INSTANCE.setKnownToken(jsonValue.get("TransferCode").getAsString());
                continue;
            }
            if (StringsKt.equals(key, ClientConfiguration.INSTANCE.getName(), true)) {
                Intrinsics.checkNotNull(value);
                ClientConfiguration.INSTANCE.fromJson(value);
                continue;
            }
            if (StringsKt.equals(key, "background", true)) {
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type com.google.gson.JsonObject");
                jsonValue = (JsonObject)value;
                if (jsonValue.has("Enabled")) {
                    ClientConfiguration.INSTANCE.setCustomBackground(jsonValue.get("Enabled").getAsBoolean());
                }
                if (!jsonValue.has("Particles")) continue;
                ClientConfiguration.INSTANCE.setParticles(jsonValue.get("Particles").getAsBoolean());
                continue;
            }
            ModuleManager moduleManager = FDPClient.INSTANCE.getModuleManager();
            Intrinsics.checkNotNull(key);
            if (moduleManager.get(key) == null) continue;
            Intrinsics.checkNotNull(value, "null cannot be cast to non-null type com.google.gson.JsonObject");
            JsonObject jsonModule = (JsonObject)value;
            for (Value<?> moduleValue : module2.getValues()) {
                JsonElement element = jsonModule.get(moduleValue.getName());
                if (element == null) continue;
                moduleValue.fromJson(element);
            }
        }
    }

    @Override
    public void saveConfig() throws IOException {
        JsonObject jsonObject;
        JsonObject $this$saveConfig_u24lambda_u240 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$saveConfig_u24lambda_u240.addProperty("CommandPrefix", FDPClient.INSTANCE.getCommandManager().getPrefix());
        $this$saveConfig_u24lambda_u240.addProperty("ClientVersion", FDPClient.INSTANCE.getClientVersionText());
        JsonObject jsonObject2 = jsonObject;
        JsonObject $this$saveConfig_u24lambda_u241 = $this$saveConfig_u24lambda_u240 = new JsonObject();
        boolean bl2 = false;
        $this$saveConfig_u24lambda_u241.addProperty("TargetPlayer", Boolean.valueOf(TargetModule.INSTANCE.getPlayerValue()));
        $this$saveConfig_u24lambda_u241.addProperty("TargetMobs", Boolean.valueOf(TargetModule.INSTANCE.getMobValue()));
        $this$saveConfig_u24lambda_u241.addProperty("TargetAnimals", Boolean.valueOf(TargetModule.INSTANCE.getAnimalValue()));
        $this$saveConfig_u24lambda_u241.addProperty("TargetInvisible", Boolean.valueOf(TargetModule.INSTANCE.getInvisibleValue()));
        $this$saveConfig_u24lambda_u241.addProperty("TargetDead", Boolean.valueOf(TargetModule.INSTANCE.getDeadValue()));
        JsonObject jsonTargets = $this$saveConfig_u24lambda_u240;
        jsonObject2.add("targets", (JsonElement)jsonTargets);
        jsonObject2.add(ClientFixes.INSTANCE.getName(), ClientFixes.INSTANCE.toJson());
        JsonObject $this$saveConfig_u24lambda_u242 = $this$saveConfig_u24lambda_u241 = new JsonObject();
        boolean bl3 = false;
        $this$saveConfig_u24lambda_u242.addProperty("token", IRCModule.INSTANCE.getJwtToken());
        JsonObject liquidChatObject = $this$saveConfig_u24lambda_u241;
        jsonObject2.add("liquidchat", (JsonElement)liquidChatObject);
        JsonObject jsonObject3 = new JsonObject();
        JsonObject $this$saveConfig_u24lambda_u243 = jsonObject3;
        boolean bl4 = false;
        $this$saveConfig_u24lambda_u243.addProperty("TransferCode", CapeService.INSTANCE.getKnownToken());
        JsonObject capeObject = jsonObject3;
        jsonObject2.add("DonatorCape", (JsonElement)capeObject);
        jsonObject2.add(ClientConfiguration.INSTANCE.getName(), ClientConfiguration.INSTANCE.toJson());
        for (Module module2 : FDPClient.INSTANCE.getModuleManager()) {
            if (module2.getValues().isEmpty()) continue;
            JsonObject jsonModule = new JsonObject();
            for (Value<?> value : module2.getValues()) {
                jsonModule.add(value.getName(), value.toJson());
            }
            jsonObject2.add(module2.getName(), (JsonElement)jsonModule);
        }
        File file = this.getFile();
        String string = FileManager.INSTANCE.getPRETTY_GSON().toJson((JsonElement)jsonObject2);
        Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
        FilesKt.writeText$default(file, string, null, 2, null);
    }
}

