/*
 * Decompiled with CFR 0.152.
 */
package moe.lasoleil.axochat4j.client;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HttpsURLConnection;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UserProfileUtils {
    private static final Gson GSON = new Gson();
    private static final String SERVICE_URL = "https://api.minecraftservices.com/users/profiles/minecraft/";
    private static final ConcurrentHashMap<String, String> CACHE = new ConcurrentHashMap();

    @Nullable
    static String tryParseUUID(@Nullable String uuid) {
        if (uuid == null || uuid.length() != 36 && uuid.length() != 32) {
            return null;
        }
        try {
            uuid = uuid.length() == 32 ? UserProfileUtils.insertDashes(uuid) : uuid;
            return UUID.fromString(uuid).toString();
        }
        catch (IllegalArgumentException e2) {
            return null;
        }
    }

    @NotNull
    private static String insertDashes(@NotNull String uuid) {
        byte[] bytes = new byte[36];
        byte[] inputBytes = uuid.getBytes(StandardCharsets.ISO_8859_1);
        System.arraycopy(inputBytes, 0, bytes, 0, 8);
        System.arraycopy(inputBytes, 8, bytes, 9, 4);
        System.arraycopy(inputBytes, 12, bytes, 14, 4);
        System.arraycopy(inputBytes, 16, bytes, 19, 4);
        System.arraycopy(inputBytes, 20, bytes, 24, 12);
        bytes[8] = 45;
        bytes[13] = 45;
        bytes[18] = 45;
        bytes[23] = 45;
        return new String(bytes, StandardCharsets.ISO_8859_1);
    }

    @NotNull
    static String toUUIDOrError(@NotNull String usernameOrUUID) throws IllegalArgumentException {
        String uuid = UserProfileUtils.toUUID(usernameOrUUID);
        if (uuid == null) {
            throw new IllegalArgumentException("Invalid username or UUID: " + usernameOrUUID);
        }
        return uuid;
    }

    @Nullable
    static String toUUID(@NotNull String usernameOrUUID) {
        if (usernameOrUUID.length() == 36) {
            return UserProfileUtils.tryParseUUID(usernameOrUUID);
        }
        if (usernameOrUUID.length() == 32) {
            return UserProfileUtils.tryParseUUID(usernameOrUUID);
        }
        return CACHE.computeIfAbsent(usernameOrUUID, UserProfileUtils::getUUIDFromService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    private static String getUUIDFromService(@NotNull String username) {
        HttpURLConnection httpsURLConnection = null;
        try {
            String string;
            Throwable throwable;
            InputStreamReader reader;
            block20: {
                block21: {
                    httpsURLConnection = (HttpsURLConnection)new URL(SERVICE_URL + username).openConnection();
                    httpsURLConnection.setRequestMethod("GET");
                    httpsURLConnection.setRequestProperty("Accept", "application/json");
                    int responseCode = httpsURLConnection.getResponseCode();
                    if (responseCode != 200) {
                        String string2 = null;
                        return string2;
                    }
                    reader = new InputStreamReader(httpsURLConnection.getInputStream(), StandardCharsets.UTF_8);
                    throwable = null;
                    UserProfile userProfile = (UserProfile)GSON.fromJson((Reader)reader, UserProfile.class);
                    string = UserProfileUtils.tryParseUUID(userProfile.id);
                    if (reader == null) break block20;
                    if (throwable == null) break block21;
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                reader.close();
            }
            return string;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                reader.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e2) {
                    String string3 = null;
                    return string3;
                }
            }
        }
        finally {
            if (httpsURLConnection != null) {
                httpsURLConnection.disconnect();
            }
        }
    }

    @Generated
    private UserProfileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class UserProfile {
        @SerializedName(value="id")
        private final String id;
        @SerializedName(value="name")
        private final String name;

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserProfile)) {
                return false;
            }
            UserProfile other = (UserProfile)o;
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            String $id = this.getId();
            result2 = result2 * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result2 = result2 * 59 + ($name == null ? 43 : $name.hashCode());
            return result2;
        }

        @Generated
        public String toString() {
            return "UserProfileUtils.UserProfile(id=" + this.getId() + ", name=" + this.getName() + ")";
        }

        @Generated
        public UserProfile(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

