/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Component;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.util.function.Function;
import javax.swing.JComponent;

public class MigLayoutVisualPadding {
    public static String VISUAL_PADDING_PROPERTY = "visualPadding";
    private static final FlatMigInsets ZERO = new FlatMigInsets(0, 0, 0, 0);
    private static final boolean migLayoutAvailable;

    public static void install(JComponent c2, Insets insets) {
        if (!migLayoutAvailable) {
            return;
        }
        MigLayoutVisualPadding.setVisualPadding(c2, insets);
    }

    public static void install(JComponent c3) {
        if (!migLayoutAvailable) {
            return;
        }
        MigLayoutVisualPadding.install(c3, c2 -> {
            FlatBorder border = FlatUIUtils.getOutsideFlatBorder(c2);
            if (border != null) {
                int focusWidth = border.getFocusWidth((Component)c2);
                return new Insets(focusWidth, focusWidth, focusWidth, focusWidth);
            }
            return null;
        }, "border", "FlatLaf.style", "FlatLaf.styleClass");
    }

    public static void install(JComponent c2, Function<JComponent, Insets> getPaddingFunction, String ... propertyNames) {
        if (!migLayoutAvailable) {
            return;
        }
        MigLayoutVisualPadding.setVisualPadding(c2, getPaddingFunction.apply(c2));
        c2.addPropertyChangeListener(e2 -> {
            String propertyName = e2.getPropertyName();
            for (String name : propertyNames) {
                if (!name.equals(propertyName)) continue;
                MigLayoutVisualPadding.setVisualPadding(c2, (Insets)getPaddingFunction.apply(c2));
                break;
            }
        });
    }

    private static void setVisualPadding(JComponent c2, Insets visualPadding) {
        Object oldPadding = c2.getClientProperty(VISUAL_PADDING_PROPERTY);
        if (oldPadding == null || oldPadding instanceof FlatMigInsets) {
            FlatMigInsets flatVisualPadding = visualPadding != null ? new FlatMigInsets(UIScale.scale2(visualPadding.top), UIScale.scale2(visualPadding.left), UIScale.scale2(visualPadding.bottom), UIScale.scale2(visualPadding.right)) : ZERO;
            c2.putClientProperty(VISUAL_PADDING_PROPERTY, flatVisualPadding);
        }
    }

    public static void uninstall(JComponent c2) {
        if (!migLayoutAvailable) {
            return;
        }
        for (PropertyChangeListener l : c2.getPropertyChangeListeners()) {
            if (!(l instanceof FlatMigListener)) continue;
            c2.removePropertyChangeListener(l);
            break;
        }
        if (c2.getClientProperty(VISUAL_PADDING_PROPERTY) instanceof FlatMigInsets) {
            c2.putClientProperty(VISUAL_PADDING_PROPERTY, null);
        }
    }

    static {
        boolean available = false;
        try {
            Class.forName("net.miginfocom.swing.MigLayout");
            available = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        migLayoutAvailable = available;
    }

    private static interface FlatMigListener
    extends PropertyChangeListener {
    }

    private static class FlatMigInsets
    extends Insets {
        FlatMigInsets(int top, int left, int bottom, int right) {
            super(top, left, bottom, right);
        }
    }
}

