/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatTextFieldUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.StackUtils;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Utilities;

public class FlatCaret
extends DefaultCaret
implements UIResource {
    private static final String KEY_CARET_INFO = "FlatLaf.internal.caretInfo";
    private static final int NEVER = 0;
    private static final int ONCE = 1;
    private static final int ALWAYS = 2;
    private final String selectAllOnFocusPolicy;
    private final boolean selectAllOnMouseClick;
    private boolean inInstall;
    private boolean wasFocused;
    private boolean wasFocusTemporaryLost;
    private boolean isMousePressed;
    private boolean isWordSelection;
    private boolean isLineSelection;
    private int dragSelectionStart;
    private int dragSelectionEnd;

    public FlatCaret(String selectAllOnFocusPolicy, boolean selectAllOnMouseClick) {
        this.selectAllOnFocusPolicy = selectAllOnFocusPolicy;
        this.selectAllOnMouseClick = selectAllOnMouseClick;
    }

    @Override
    public void install(JTextComponent c2) {
        long[] ci = (long[])c2.getClientProperty(KEY_CARET_INFO);
        if (ci != null) {
            c2.putClientProperty(KEY_CARET_INFO, null);
            if (System.currentTimeMillis() - 500L > ci[3]) {
                ci = null;
            }
        }
        if (ci != null) {
            this.setBlinkRate((int)ci[2]);
        }
        this.inInstall = true;
        try {
            super.install(c2);
        }
        finally {
            this.inInstall = false;
        }
        if (ci != null) {
            this.select((int)ci[1], (int)ci[0]);
            if (ci[4] != 0L) {
                this.wasFocused = true;
            }
            if (this.isSelectionVisible()) {
                EventQueue.invokeLater(() -> {
                    if (this.getComponent() == null) {
                        return;
                    }
                    if (this.isSelectionVisible()) {
                        this.setSelectionVisible(false);
                        this.setSelectionVisible(true);
                    }
                });
            }
        }
    }

    @Override
    public void deinstall(JTextComponent c2) {
        c2.putClientProperty(KEY_CARET_INFO, new long[]{this.getDot(), this.getMark(), this.getBlinkRate(), System.currentTimeMillis(), this.wasFocused ? 1L : 0L});
        super.deinstall(c2);
    }

    @Override
    protected void adjustVisibility(Rectangle nloc) {
        Rectangle r;
        JTextComponent c2 = this.getComponent();
        if (c2 != null && c2.getUI() instanceof FlatTextFieldUI && (r = ((FlatTextFieldUI)c2.getUI()).getVisibleEditorRect()) != null) {
            nloc.x -= r.x - c2.getInsets().left;
        }
        super.adjustVisibility(nloc);
    }

    @Override
    public void setDot(int dot) {
        super.setDot(dot);
        if (!this.wasFocused && this.getSelectAllOnFocusPolicy() == 1 && StackUtils.wasInvokedFrom(JTextComponent.class.getName(), "setCaretPosition", 6)) {
            this.wasFocused = true;
        }
    }

    @Override
    public void moveDot(int dot) {
        super.moveDot(dot);
        if (!this.wasFocused && this.getSelectAllOnFocusPolicy() == 1 && StackUtils.wasInvokedFrom(JTextComponent.class.getName(), "moveCaretPosition", 6)) {
            this.wasFocused = true;
        }
    }

    @Override
    public void focusGained(FocusEvent e2) {
        if (!(this.inInstall || this.wasFocusTemporaryLost || this.isMousePressed && !this.isSelectAllOnMouseClick())) {
            this.selectAllOnFocusGained();
        }
        this.wasFocusTemporaryLost = false;
        this.wasFocused = true;
        super.focusGained(e2);
    }

    @Override
    public void focusLost(FocusEvent e2) {
        this.wasFocusTemporaryLost = e2.isTemporary();
        super.focusLost(e2);
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.isMousePressed = true;
        super.mousePressed(e2);
        JTextComponent c2 = this.getComponent();
        this.isWordSelection = e2.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e2) && !e2.isConsumed();
        boolean bl = this.isLineSelection = e2.getClickCount() == 3 && SwingUtilities.isLeftMouseButton(e2) && (!e2.isConsumed() || c2.getDragEnabled());
        if (this.isLineSelection) {
            Action selectLineAction;
            ActionMap actionMap = c2.getActionMap();
            Action action = selectLineAction = actionMap != null ? actionMap.get("select-line") : null;
            if (selectLineAction != null) {
                selectLineAction.actionPerformed(new ActionEvent(c2, 1001, null, e2.getWhen(), e2.getModifiers()));
            }
        }
        if (this.isWordSelection || this.isLineSelection) {
            int mark = this.getMark();
            int dot = this.getDot();
            this.dragSelectionStart = Math.min(dot, mark);
            this.dragSelectionEnd = Math.max(dot, mark);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.isMousePressed = false;
        this.isWordSelection = false;
        this.isLineSelection = false;
        super.mouseReleased(e2);
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        block7: {
            if ((this.isWordSelection || this.isLineSelection) && !e2.isConsumed() && SwingUtilities.isLeftMouseButton(e2)) {
                JTextComponent c2 = this.getComponent();
                int pos = c2.viewToModel(e2.getPoint());
                if (pos < 0) {
                    return;
                }
                try {
                    if (pos > this.dragSelectionEnd) {
                        this.select(this.dragSelectionStart, this.isWordSelection ? Utilities.getWordEnd(c2, pos) : Utilities.getRowEnd(c2, pos));
                        break block7;
                    }
                    if (pos < this.dragSelectionStart) {
                        this.select(this.dragSelectionEnd, this.isWordSelection ? Utilities.getWordStart(c2, pos) : Utilities.getRowStart(c2, pos));
                        break block7;
                    }
                    this.select(this.dragSelectionStart, this.dragSelectionEnd);
                }
                catch (BadLocationException ex) {
                    UIManager.getLookAndFeel().provideErrorFeedback(c2);
                }
            } else {
                super.mouseDragged(e2);
            }
        }
    }

    protected void selectAllOnFocusGained() {
        JTextComponent c2 = this.getComponent();
        Document doc = c2.getDocument();
        if (doc == null || !c2.isEnabled() || !c2.isEditable() || FlatUIUtils.isCellEditor(c2)) {
            return;
        }
        int selectAllOnFocusPolicy = this.getSelectAllOnFocusPolicy();
        if (selectAllOnFocusPolicy == 0) {
            return;
        }
        if (selectAllOnFocusPolicy == 1 && !this.isMousePressed && this.wasFocused && !(c2 instanceof JFormattedTextField)) {
            return;
        }
        if (c2 instanceof JFormattedTextField) {
            EventQueue.invokeLater(() -> {
                JTextComponent c2 = this.getComponent();
                if (c2 == null) {
                    return;
                }
                this.select(0, c2.getDocument().getLength());
            });
        } else {
            this.select(0, doc.getLength());
        }
    }

    private void select(int mark, int dot) {
        if (mark != this.getMark()) {
            this.setDot(mark, Position.Bias.Forward);
        }
        if (dot != this.getDot()) {
            this.moveDot(dot, Position.Bias.Forward);
        }
    }

    private int getSelectAllOnFocusPolicy() {
        Object value = this.getClientProperty("JTextField.selectAllOnFocusPolicy");
        switch (String.valueOf(value instanceof String ? value : this.selectAllOnFocusPolicy)) {
            default: {
                return 0;
            }
            case "once": {
                return 1;
            }
            case "always": 
        }
        return 2;
    }

    private boolean isSelectAllOnMouseClick() {
        Object value = this.getClientProperty("JTextField.selectAllOnMouseClick");
        return value instanceof Boolean ? (Boolean)value : this.selectAllOnMouseClick;
    }

    private Object getClientProperty(String key) {
        JTextComponent c2 = this.getComponent();
        if (c2 == null) {
            return null;
        }
        Object value = c2.getClientProperty(key);
        if (value != null) {
            return value;
        }
        Container parent = c2.getParent();
        if (parent instanceof JComboBox) {
            return ((JComboBox)parent).getClientProperty(key);
        }
        if (parent instanceof JSpinner.DefaultEditor && (parent = parent.getParent()) instanceof JSpinner) {
            return ((JSpinner)parent).getClientProperty(key);
        }
        return null;
    }

    public void scrollCaretToVisible() {
        JTextComponent c2 = this.getComponent();
        if (c2 == null || c2.getUI() == null) {
            return;
        }
        try {
            Rectangle loc = c2.getUI().modelToView(c2, this.getDot(), this.getDotBias());
            if (loc != null) {
                this.adjustVisibility(loc);
                this.damage(loc);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

