
BEGIN{
    GEMINI_RESPONSE_CONTENT = ""
    GEMINI_RESPONSE_REASONING_CONTENT = ""
    GEMINI_RESPONSE_ERROR_MSG = ""
    GEMINI_HAS_RESPONSE_CONTENT = 0
    GEMINI_RESPONSE_HAS_REASONING = 0
    GEMINI_RESPONSE_IS_ERROR_CONTENT = 0

    KP_PART = "\"candidates\"" SUBSEP "\"1\"" SUBSEP "\"content\"" SUBSEP "\"parts\""
    KP_FINISH_REASON = "\"candidates\"" SUBSEP "\"1\"" SUBSEP "\"finishReason\""
    Q2_1 = SUBSEP "\"1\""
}

function gemini_parse_response_data( text, obj,       _arr, _arrl, i, _current_kp, _finish_reason, _part_l, j, _kp_part_idx  ){
    _arrl = json_split2tokenarr( _arr, text )
    for (i=1; i<=_arrl; ++i) {
        jiparse( obj, _arr[i] )
        if ( IS_STREAM == true ) {
            if (( JITER_LEVEL != 1 ) || ( JITER_CURLEN <= 0) || ( _arr[i] ~ "^[,:]?$")) continue
            _current_kp = Q2_1 SUBSEP "\""JITER_CURLEN"\""
        } else {
            if ( JITER_LEVEL != 0 ) continue
            _current_kp = Q2_1
        }

        if (( JITER_CURLEN == 1 ) && ( obj[ _current_kp, "\"error\"" ] != "" )) {
            GEMINI_RESPONSE_IS_ERROR_CONTENT = 1
            o_error[ L ] = 1
            jmerge_force___value( o_error, Q2_1, obj, _current_kp )
            continue
        } else if (( JITER_CURLEN != 1 ) && ( IS_STREAM == true )){
            jmerge_force___value( o_response, Q2_1 SUBSEP "\"1\"", o_response, Q2_1 SUBSEP "\""JITER_CURLEN"\"" )
        }

        _finish_reason = obj[ _current_kp, KP_FINISH_REASON ]
        if (( _finish_reason != "" ) && ( _finish_reason != "\"STOP\"" )){
            _finish_reason = juq(_finish_reason)
            GEMINI_RESPONSE_IS_ERROR_CONTENT = 1
            GEMINI_RESPONSE_EXITCODE = 2
            if ( _finish_reason == "MAX_TOKENS" )                   GEMINI_RESPONSE_ERROR_MSG = "The maximum number of tokens as specified in the request was reached."
            else if ( _finish_reason == "SAFETY" )                  GEMINI_RESPONSE_ERROR_MSG = "The response candidate content was flagged for safety reasons."
            else if ( _finish_reason == "RECITATION" )              GEMINI_RESPONSE_ERROR_MSG = "The response candidate content was flagged for recitation reasons."
            else if ( _finish_reason == "LANGUAGE" )                GEMINI_RESPONSE_ERROR_MSG = "The response candidate content was flagged for using an unsupported language."
            else if ( _finish_reason == "OTHER" )                   GEMINI_RESPONSE_ERROR_MSG = "Unknown reason."
            else if ( _finish_reason == "BLOCKLIST" )               GEMINI_RESPONSE_ERROR_MSG = "Token generation stopped because the content contains forbidden terms."
            else if ( _finish_reason == "PROHIBITED_CONTENT" )      GEMINI_RESPONSE_ERROR_MSG = "Token generation stopped for potentially containing prohibited content."
            else if ( _finish_reason == "SPII" )                    GEMINI_RESPONSE_ERROR_MSG = "Token generation stopped because the content potentially contains Sensitive Personally Identifiable Information (SPII)."
            else if ( _finish_reason == "MALFORMED_FUNCTION_CALL" ) GEMINI_RESPONSE_ERROR_MSG = "The function call generated by the model is invalid."
            else if ( _finish_reason == "IMAGE_SAFETY" )            GEMINI_RESPONSE_ERROR_MSG = "Token generation stopped because generated images contain safety violations."
            else if ( _finish_reason == "UNEXPECTED_TOOL_CALL" )    GEMINI_RESPONSE_ERROR_MSG = "Model generated a tool call but no tools were enabled in the request."
            else if ( _finish_reason == "TOO_MANY_TOOL_CALLS" )     GEMINI_RESPONSE_ERROR_MSG = "Model called too many tools consecutively, thus the system exited execution."
            else GEMINI_RESPONSE_ERROR_MSG = _finish_reason
            exit( GEMINI_RESPONSE_EXITCODE )
        }

        _part_l = obj[ _current_kp, KP_PART L ]
        for (j=1; j<=_part_l; ++j){
            _kp_part_idx    = _current_kp SUBSEP KP_PART SUBSEP "\""j"\""
            gemini_record_response___text_content( obj, _kp_part_idx )
            gemini_record_response___tool_call( obj, _kp_part_idx )
        }
    }
}

function gemini_record_response___text_content( obj, kp,          item, is_thought ){
    item =  obj[ kp, "\"text\"" ]
    if ( chat_str_is_null(item) ) return
    item = juq(item)
    is_thought = obj[ kp, "\"thought\"" ]
    if ( is_thought == "true" ) {
        if ( GEMINI_RESPONSE_HAS_REASONING  == 0 ) {
            if ( IS_REASONING == true ) chat_record_str_to_drawfile( "---------- REASONING BEGIN ----------\n", DRAW_PREFIX )
        }
        GEMINI_RESPONSE_HAS_REASONING = 1
        GEMINI_RESPONSE_REASONING_CONTENT = GEMINI_RESPONSE_REASONING_CONTENT item
        if ( IS_REASONING == true ) chat_record_str_to_drawfile( item, DRAW_PREFIX )
        return
    } else if (GEMINI_RESPONSE_HAS_REASONING == 1){
        GEMINI_RESPONSE_HAS_REASONING = 0
        if ( IS_REASONING == true ) chat_record_str_to_drawfile( "\n---------- REASONING END ----------\n", DRAW_PREFIX )
    }

    GEMINI_RESPONSE_CONTENT = GEMINI_RESPONSE_CONTENT item
    chat_record_str_to_drawfile( item, DRAW_PREFIX )
}

function gemini_record_response___tool_call( obj, kp,        name, args, desc, dir, idx){
    kp = kp SUBSEP "\"functionCall\""
    if ( obj[ kp L ] <= 0 ) return
    name = juq( obj[ kp, "\"name\"" ] )
    if ( name == "" ) return
    o_tool[ Q2_1 ] = "["
    jlist_put( o_tool, Q2_1, "{" )
    idx = o_tool[ Q2_1 L ]
    jdict_put( o_tool, Q2_1 SUBSEP "\""idx"\"", "\"index\"",    idx)
    jdict_put( o_tool, Q2_1 SUBSEP "\""idx"\"", "\"name\"",     jqu(name))

    desc = obj[ kp, "\"args\"", "\"desc\"" ]
    if ( desc != "" ) {
        jdict_put( o_tool, Q2_1 SUBSEP "\""idx"\"", "\"desc\"", jqu(desc))
        desc = ( desc ~ "^\"" ) ? juq(desc) : desc
        jdict_rm( obj, kp SUBSEP "\"args\"", "\"desc\"" )
    }
    name = chat_trim_str( name )
    desc = chat_trim_str( desc )
    args = chat_trim_str( jstr0( obj, kp SUBSEP "\"args\"", " " ) )
    jdict_put( o_tool, Q2_1 SUBSEP "\""idx"\"", "\"arguments\"", jqu(args))

    if ( GEMINI_CONTENT_DIR != "" ) {
        dir = (GEMINI_CONTENT_DIR "/function-call/" idx)
        mkdirp( dir )
        print name > (dir "/name")
        print args > (dir "/arg")
        print desc > (dir "/desc")
        if ( IS_ENACTNONE != true ) print "[FUNCTION-CALL] " idx >> XCMD_CHAT_ENACTALL_LOGFILE
    }

    fflush()
}

( IS_DEBUG ){ print $0 >> (GEMINI_CONTENT_DIR "/chat.running.yml"); }

($0 != ""){
    GEMINI_HAS_RESPONSE_CONTENT = 1
    gemini_parse_response_data( $0, obj )
}
