/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick;

import com.mentalfrostbyte.jello.util.system.network.ImageUtil;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.opengl.GLUtils;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.renderer.Renderer;
import org.newdawn.slick.opengl.renderer.SGL;
import org.newdawn.slick.util.BufferedImageUtil;

public class TrueTypeFont
implements Font {
    private static final SGL GL = Renderer.get();
    private final int size;
    public Texture fontTexture;
    private final IntObject[] charArray = new IntObject[256];
    private final Map customChars = new HashMap();
    private final boolean antiAlias;
    private int fontSize = 0;
    private int fontHeight = 0;
    private int textureWidth = 512;
    private int textureHeight = 512;
    private final java.awt.Font font;
    private FontMetrics fontMetrics;

    public TrueTypeFont(java.awt.Font font, boolean antiAlias, char[] additionalChars, int size) {
        GLUtils.checkGLContext();
        this.font = font;
        this.fontSize = font.getSize();
        this.antiAlias = antiAlias;
        this.size = size;
        if (size > 0) {
            this.textureWidth = 1024;
            this.textureHeight = 1024;
        }
        this.createSet(additionalChars);
    }

    public TrueTypeFont(java.awt.Font font, boolean antiAlias, char[] additionalChars) {
        this(font, antiAlias, additionalChars, 0);
    }

    public TrueTypeFont(java.awt.Font font, boolean antiAlias) {
        this(font, antiAlias, null);
    }

    public TrueTypeFont(java.awt.Font font, int size) {
        this(font, true, null, size);
    }

    private BufferedImage getFontImage(char of) {
        int charHeight;
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
        if (this.antiAlias) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2d.setFont(this.font);
        this.fontMetrics = g2d.getFontMetrics();
        int charWidth = this.fontMetrics.charWidth(of);
        if (charWidth <= 0) {
            charWidth = 1;
        }
        if ((charHeight = this.fontMetrics.getHeight()) <= 0) {
            charHeight = this.fontSize;
        }
        BufferedImage bufferedImage2 = new BufferedImage(charWidth + this.size * 2, charHeight + this.size * 2, 2);
        Graphics2D g2d2 = (Graphics2D)bufferedImage2.getGraphics();
        if (this.antiAlias) {
            g2d2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2d2.setFont(this.font);
        g2d2.setColor(java.awt.Color.WHITE);
        g2d2.drawString(String.valueOf(of), this.size, this.size + this.fontMetrics.getAscent());
        return this.size <= 0 ? bufferedImage2 : ImageUtil.applyGaussianBlur(bufferedImage2, this.size);
    }

    private int method23949(char var1) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
        if (this.antiAlias) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2d.setFont(this.font);
        this.fontMetrics = g2d.getFontMetrics();
        int charWidth = this.fontMetrics.charWidth(var1);
        if (charWidth <= 0) {
            charWidth = 1;
        }
        return charWidth;
    }

    private void createSet(char[] customCharsArray) {
        if (customCharsArray != null && customCharsArray.length > 0) {
            this.textureWidth *= 2;
        }
        try {
            BufferedImage bufferedImage = this.getFontImage('\u0000');
            if (bufferedImage.getHeight() > 60) {
                this.textureWidth *= 2;
                this.textureHeight *= 2;
            }
            BufferedImage imgTemp = new BufferedImage(this.textureWidth, this.textureHeight, 2);
            Graphics2D g2d = (Graphics2D)imgTemp.getGraphics();
            g2d.setColor(new java.awt.Color(255, 255, 255, 1));
            g2d.fillRect(0, 0, this.textureWidth, this.textureHeight);
            int rowHeight = 0;
            int positionX = 0;
            int positionY = 0;
            int customCharsLength = customCharsArray != null ? customCharsArray.length : 0;
            for (int i = 0; i < 256 + customCharsLength; ++i) {
                char ch = i < 256 ? (char)i : customCharsArray[i - 256];
                BufferedImage var13 = this.getFontImage(ch);
                IntObject newIntObject = new IntObject();
                newIntObject.width = var13.getWidth();
                newIntObject.height = var13.getHeight();
                newIntObject.actualWidth = this.size > 0 ? this.method23949(ch) : newIntObject.width;
                if (positionX + newIntObject.width >= this.textureWidth) {
                    positionX = 0;
                    positionY += rowHeight;
                    rowHeight = 0;
                }
                newIntObject.storedX = positionX;
                newIntObject.storedY = positionY;
                if (newIntObject.height > this.fontHeight) {
                    this.fontHeight = newIntObject.height;
                }
                if (newIntObject.height > rowHeight) {
                    rowHeight = newIntObject.height + 1;
                }
                g2d.drawImage((Image)var13, positionX, positionY, null);
                positionX += newIntObject.width + 1;
                if (i < 256) {
                    this.charArray[i] = newIntObject;
                    continue;
                }
                this.customChars.put(Character.valueOf(ch), newIntObject);
            }
            this.fontTexture = BufferedImageUtil.getTexture(this.font.toString(), imgTemp);
        }
        catch (IOException var15) {
            System.err.println("Failed to create font.");
            var15.printStackTrace();
        }
    }

    private void drawQuad(float drawX, float drawY, float drawX2, float drawY2, float srcX, float srcY, float srcX2, float srcY2) {
        float DrawWidth = drawX2 - drawX;
        float DrawHeight = drawY2 - drawY;
        float TextureSrcX = srcX / (float)this.textureWidth;
        float TextureSrcY = srcY / (float)this.textureHeight;
        float SrcWidth = srcX2 - srcX;
        float SrcHeight = srcY2 - srcY;
        float RenderWidth = SrcWidth / (float)this.textureWidth;
        float RenderHeight = SrcHeight / (float)this.textureHeight;
        GL.glTexCoord2f(TextureSrcX, TextureSrcY);
        GL.glVertex2f(drawX, drawY);
        GL.glTexCoord2f(TextureSrcX, TextureSrcY + RenderHeight);
        GL.glVertex2f(drawX, drawY + DrawHeight);
        GL.glTexCoord2f(TextureSrcX + RenderWidth, TextureSrcY + RenderHeight);
        GL.glVertex2f(drawX + DrawWidth, drawY + DrawHeight);
        GL.glTexCoord2f(TextureSrcX + RenderWidth, TextureSrcY);
        GL.glVertex2f(drawX + DrawWidth, drawY);
    }

    @Override
    public int getWidth(String whatchars) {
        int totalwidth = 0;
        for (int i = 0; i < whatchars.length(); ++i) {
            char currentChar = whatchars.charAt(i);
            IntObject intObject = currentChar < '\u0100' ? this.charArray[currentChar] : (IntObject)this.customChars.get(Character.valueOf(currentChar));
            if (intObject == null) continue;
            totalwidth += intObject.width;
        }
        return totalwidth;
    }

    public int getHeight() {
        return this.fontHeight;
    }

    @Override
    public int getHeight(String HeightString) {
        return this.fontHeight;
    }

    @Override
    public int getLineHeight() {
        return this.fontHeight;
    }

    @Override
    public void drawString(float x, float y, String whatchars, Color color) {
        this.drawString(x, y, whatchars, color, 0, whatchars.length() - 1);
    }

    @Override
    public void drawString(float x, float y, String string, Color color, int startIndex, int endIndex) {
        color.bind();
        this.fontTexture.bind();
        IntObject intObject = null;
        if (this.size > 0) {
            y -= (float)(this.size / 2 - 1);
            x -= (float)(this.size - 1);
        }
        GL.glBegin(7);
        int charIdx = 0;
        for (int var11 = 0; var11 < string.length(); ++var11) {
            char charCurrent = string.charAt(var11);
            intObject = charCurrent >= '\u0100' ? (IntObject)this.customChars.get(Character.valueOf(charCurrent)) : this.charArray[charCurrent];
            if (intObject == null) continue;
            if (var11 >= startIndex || var11 <= endIndex) {
                this.drawQuad(x + (float)charIdx, y, x + (float)charIdx + (float)intObject.width, y + (float)intObject.height, intObject.storedX, intObject.storedY, intObject.storedX + intObject.width, intObject.storedY + intObject.height);
            }
            charIdx += intObject.actualWidth;
        }
        GL.glEnd();
    }

    @Override
    public void drawString(float x, float y, String string) {
        this.drawString(x, y, string, Color.white);
    }

    public static class IntObject {
        public int width;
        public int actualWidth;
        public int height;
        public int storedX;
        public int storedY;
    }
}

