/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.lighting;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.LightDataMap;
import net.minecraft.world.lighting.SectionLightStorage;

public class BlockLightStorage
extends SectionLightStorage<StorageMap> {
    protected BlockLightStorage(IChunkLightProvider p_i51300_1_) {
        super(LightType.BLOCK, p_i51300_1_, new StorageMap((Long2ObjectOpenHashMap<NibbleArray>)new Long2ObjectOpenHashMap()));
    }

    @Override
    protected int getLightOrDefault(long worldPos) {
        long i = SectionPos.worldToSection(worldPos);
        NibbleArray nibblearray = this.getArray(i, false);
        return nibblearray == null ? 0 : nibblearray.get(SectionPos.mask(BlockPos.unpackX(worldPos)), SectionPos.mask(BlockPos.unpackY(worldPos)), SectionPos.mask(BlockPos.unpackZ(worldPos)));
    }

    public static final class StorageMap
    extends LightDataMap<StorageMap> {
        public StorageMap(Long2ObjectOpenHashMap<NibbleArray> arrayStorage) {
            super(arrayStorage);
        }

        @Override
        public StorageMap copy() {
            return new StorageMap((Long2ObjectOpenHashMap<NibbleArray>)this.arrays.clone());
        }
    }
}

