/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.trunkplacer;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;

public abstract class AbstractTrunkPlacer {
    public static final Codec<AbstractTrunkPlacer> field_236905_c_ = Registry.TRUNK_REPLACER.dispatch(AbstractTrunkPlacer::func_230381_a_, TrunkPlacerType::func_236927_a_);
    protected final int field_236906_d_;
    protected final int field_236907_e_;
    protected final int field_236908_f_;

    protected static <P extends AbstractTrunkPlacer> Products.P3<RecordCodecBuilder.Mu<P>, Integer, Integer, Integer> func_236915_a_(RecordCodecBuilder.Instance<P> p_236915_0_) {
        return p_236915_0_.group((App)Codec.intRange((int)0, (int)32).fieldOf("base_height").forGetter(p_236919_0_ -> p_236919_0_.field_236906_d_), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_a").forGetter(p_236918_0_ -> p_236918_0_.field_236907_e_), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_b").forGetter(p_236916_0_ -> p_236916_0_.field_236908_f_));
    }

    public AbstractTrunkPlacer(int p_i232060_1_, int p_i232060_2_, int p_i232060_3_) {
        this.field_236906_d_ = p_i232060_1_;
        this.field_236907_e_ = p_i232060_2_;
        this.field_236908_f_ = p_i232060_3_;
    }

    protected abstract TrunkPlacerType<?> func_230381_a_();

    public abstract List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader var1, Random var2, int var3, BlockPos var4, Set<BlockPos> var5, MutableBoundingBox var6, BaseTreeFeatureConfig var7);

    public int func_236917_a_(Random p_236917_1_) {
        return this.field_236906_d_ + p_236917_1_.nextInt(this.field_236907_e_ + 1) + p_236917_1_.nextInt(this.field_236908_f_ + 1);
    }

    protected static void func_236913_a_(IWorldWriter p_236913_0_, BlockPos p_236913_1_, BlockState p_236913_2_, MutableBoundingBox p_236913_3_) {
        TreeFeature.func_236408_b_(p_236913_0_, p_236913_1_, p_236913_2_);
        p_236913_3_.expandTo(new MutableBoundingBox(p_236913_1_, p_236913_1_));
    }

    private static boolean func_236912_a_(IWorldGenerationBaseReader p_236912_0_, BlockPos p_236912_1_) {
        return p_236912_0_.hasBlockState(p_236912_1_, p_236914_0_ -> {
            Block block = p_236914_0_.getBlock();
            return Feature.isDirt(block) && !p_236914_0_.isIn(Blocks.GRASS_BLOCK) && !p_236914_0_.isIn(Blocks.MYCELIUM);
        });
    }

    protected static void func_236909_a_(IWorldGenerationReader p_236909_0_, BlockPos p_236909_1_) {
        if (!AbstractTrunkPlacer.func_236912_a_(p_236909_0_, p_236909_1_)) {
            TreeFeature.func_236408_b_(p_236909_0_, p_236909_1_, Blocks.DIRT.getDefaultState());
        }
    }

    protected static boolean func_236911_a_(IWorldGenerationReader p_236911_0_, Random p_236911_1_, BlockPos p_236911_2_, Set<BlockPos> p_236911_3_, MutableBoundingBox p_236911_4_, BaseTreeFeatureConfig p_236911_5_) {
        if (TreeFeature.isReplaceableAt(p_236911_0_, p_236911_2_)) {
            AbstractTrunkPlacer.func_236913_a_(p_236911_0_, p_236911_2_, p_236911_5_.trunkProvider.getBlockState(p_236911_1_, p_236911_2_), p_236911_4_);
            p_236911_3_.add(p_236911_2_.toImmutable());
            return true;
        }
        return false;
    }

    protected static void func_236910_a_(IWorldGenerationReader p_236910_0_, Random p_236910_1_, BlockPos.Mutable p_236910_2_, Set<BlockPos> p_236910_3_, MutableBoundingBox p_236910_4_, BaseTreeFeatureConfig p_236910_5_) {
        if (TreeFeature.func_236410_c_(p_236910_0_, p_236910_2_)) {
            AbstractTrunkPlacer.func_236911_a_(p_236910_0_, p_236910_1_, p_236910_2_, p_236910_3_, p_236910_4_, p_236910_5_);
        }
    }
}

