/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.surfacebuilders;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class NetherForestsSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static final BlockState field_237178_b_ = Blocks.CAVE_AIR.getDefaultState();
    protected long field_237177_a_;
    private OctavesNoiseGenerator field_237179_c_;

    public NetherForestsSurfaceBuilder(Codec<SurfaceBuilderConfig> p_i232131_1_) {
        super(p_i232131_1_);
    }

    @Override
    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        int i = seaLevel;
        int j = x & 0xF;
        int k = z & 0xF;
        double d0 = this.field_237179_c_.func_205563_a((double)x * 0.1, seaLevel, (double)z * 0.1);
        boolean flag = d0 > 0.15 + random.nextDouble() * 0.35;
        double d1 = this.field_237179_c_.func_205563_a((double)x * 0.1, 109.0, (double)z * 0.1);
        boolean flag1 = d1 > 0.25 + random.nextDouble() * 0.9;
        int l = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        int i1 = -1;
        BlockState blockstate = config.getUnder();
        for (int j1 = 127; j1 >= 0; --j1) {
            blockpos$mutable.setPos(j, j1, k);
            BlockState blockstate1 = config.getTop();
            BlockState blockstate2 = chunkIn.getBlockState(blockpos$mutable);
            if (blockstate2.isAir()) {
                i1 = -1;
                continue;
            }
            if (!blockstate2.isIn(defaultBlock.getBlock())) continue;
            if (i1 == -1) {
                boolean flag2 = false;
                if (l <= 0) {
                    flag2 = true;
                    blockstate = config.getUnder();
                }
                if (flag) {
                    blockstate1 = config.getUnder();
                } else if (flag1) {
                    blockstate1 = config.getUnderWaterMaterial();
                }
                if (j1 < i && flag2) {
                    blockstate1 = defaultFluid;
                }
                i1 = l;
                if (j1 >= i - 1) {
                    chunkIn.setBlockState(blockpos$mutable, blockstate1, false);
                    continue;
                }
                chunkIn.setBlockState(blockpos$mutable, blockstate, false);
                continue;
            }
            if (i1 <= 0) continue;
            --i1;
            chunkIn.setBlockState(blockpos$mutable, blockstate, false);
        }
    }

    @Override
    public void setSeed(long seed) {
        if (this.field_237177_a_ != seed || this.field_237179_c_ == null) {
            this.field_237179_c_ = new OctavesNoiseGenerator(new SharedSeedRandom(seed), (List<Integer>)ImmutableList.of((Object)0));
        }
        this.field_237177_a_ = seed;
    }
}

