/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.template;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.IClearable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.EmptyBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;

public class Template {
    private final List<Palette> blocks = Lists.newArrayList();
    private final List<EntityInfo> entities = Lists.newArrayList();
    private BlockPos size = BlockPos.ZERO;
    private String author = "?";

    public BlockPos getSize() {
        return this.size;
    }

    public void setAuthor(String authorIn) {
        this.author = authorIn;
    }

    public String getAuthor() {
        return this.author;
    }

    public void takeBlocksFromWorld(World worldIn, BlockPos startPos, BlockPos size, boolean takeEntities, @Nullable Block toIgnore) {
        if (size.getX() >= 1 && size.getY() >= 1 && size.getZ() >= 1) {
            BlockPos blockpos = startPos.add(size).add(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPos blockpos1 = new BlockPos(Math.min(startPos.getX(), blockpos.getX()), Math.min(startPos.getY(), blockpos.getY()), Math.min(startPos.getZ(), blockpos.getZ()));
            BlockPos blockpos2 = new BlockPos(Math.max(startPos.getX(), blockpos.getX()), Math.max(startPos.getY(), blockpos.getY()), Math.max(startPos.getZ(), blockpos.getZ()));
            this.size = size;
            for (BlockPos blockpos3 : BlockPos.getAllInBoxMutable(blockpos1, blockpos2)) {
                BlockInfo template$blockinfo;
                BlockPos blockpos4 = blockpos3.subtract(blockpos1);
                BlockState blockstate = worldIn.getBlockState(blockpos3);
                if (toIgnore != null && toIgnore == blockstate.getBlock()) continue;
                TileEntity tileentity = worldIn.getTileEntity(blockpos3);
                if (tileentity != null) {
                    CompoundNBT compoundnbt = tileentity.write(new CompoundNBT());
                    compoundnbt.remove("x");
                    compoundnbt.remove("y");
                    compoundnbt.remove("z");
                    template$blockinfo = new BlockInfo(blockpos4, blockstate, compoundnbt.copy());
                } else {
                    template$blockinfo = new BlockInfo(blockpos4, blockstate, null);
                }
                Template.func_237149_a_(template$blockinfo, list, list1, list2);
            }
            List<BlockInfo> list3 = Template.func_237151_a_(list, list1, list2);
            this.blocks.clear();
            this.blocks.add(new Palette(list3));
            if (takeEntities) {
                this.takeEntitiesFromWorld(worldIn, blockpos1, blockpos2.add(1, 1, 1));
            } else {
                this.entities.clear();
            }
        }
    }

    private static void func_237149_a_(BlockInfo p_237149_0_, List<BlockInfo> p_237149_1_, List<BlockInfo> p_237149_2_, List<BlockInfo> p_237149_3_) {
        if (p_237149_0_.nbt != null) {
            p_237149_2_.add(p_237149_0_);
        } else if (!p_237149_0_.state.getBlock().isVariableOpacity() && p_237149_0_.state.hasOpaqueCollisionShape(EmptyBlockReader.INSTANCE, BlockPos.ZERO)) {
            p_237149_1_.add(p_237149_0_);
        } else {
            p_237149_3_.add(p_237149_0_);
        }
    }

    private static List<BlockInfo> func_237151_a_(List<BlockInfo> p_237151_0_, List<BlockInfo> p_237151_1_, List<BlockInfo> p_237151_2_) {
        Comparator<BlockInfo> comparator = Comparator.comparingInt(p_237154_0_ -> p_237154_0_.pos.getY()).thenComparingInt(p_237153_0_ -> p_237153_0_.pos.getX()).thenComparingInt(p_237148_0_ -> p_237148_0_.pos.getZ());
        p_237151_0_.sort(comparator);
        p_237151_2_.sort(comparator);
        p_237151_1_.sort(comparator);
        ArrayList list = Lists.newArrayList();
        list.addAll(p_237151_0_);
        list.addAll(p_237151_2_);
        list.addAll(p_237151_1_);
        return list;
    }

    private void takeEntitiesFromWorld(World worldIn, BlockPos startPos, BlockPos endPos) {
        List<Entity> list = worldIn.getEntitiesWithinAABB(Entity.class, new AxisAlignedBB(startPos, endPos), p_237142_0_ -> !(p_237142_0_ instanceof PlayerEntity));
        this.entities.clear();
        for (Entity entity : list) {
            Vector3d vector3d = new Vector3d(entity.getPosX() - (double)startPos.getX(), entity.getPosY() - (double)startPos.getY(), entity.getPosZ() - (double)startPos.getZ());
            CompoundNBT compoundnbt = new CompoundNBT();
            entity.writeUnlessPassenger(compoundnbt);
            BlockPos blockpos = entity instanceof PaintingEntity ? ((PaintingEntity)entity).getHangingPosition().subtract(startPos) : new BlockPos(vector3d);
            this.entities.add(new EntityInfo(vector3d, blockpos, compoundnbt.copy()));
        }
    }

    public List<BlockInfo> func_215381_a(BlockPos p_215381_1_, PlacementSettings p_215381_2_, Block p_215381_3_) {
        return this.func_215386_a(p_215381_1_, p_215381_2_, p_215381_3_, true);
    }

    public List<BlockInfo> func_215386_a(BlockPos p_215386_1_, PlacementSettings p_215386_2_, Block p_215386_3_, boolean p_215386_4_) {
        ArrayList list = Lists.newArrayList();
        MutableBoundingBox mutableboundingbox = p_215386_2_.getBoundingBox();
        if (this.blocks.isEmpty()) {
            return Collections.emptyList();
        }
        for (BlockInfo template$blockinfo : p_215386_2_.func_237132_a_(this.blocks, p_215386_1_).func_237158_a_(p_215386_3_)) {
            BlockPos blockpos;
            BlockPos blockPos = blockpos = p_215386_4_ ? Template.transformedBlockPos(p_215386_2_, template$blockinfo.pos).add(p_215386_1_) : template$blockinfo.pos;
            if (mutableboundingbox != null && !mutableboundingbox.isVecInside(blockpos)) continue;
            list.add(new BlockInfo(blockpos, template$blockinfo.state.rotate(p_215386_2_.getRotation()), template$blockinfo.nbt));
        }
        return list;
    }

    public BlockPos calculateConnectedPos(PlacementSettings placementIn, BlockPos p_186262_2_, PlacementSettings p_186262_3_, BlockPos p_186262_4_) {
        BlockPos blockpos = Template.transformedBlockPos(placementIn, p_186262_2_);
        BlockPos blockpos1 = Template.transformedBlockPos(p_186262_3_, p_186262_4_);
        return blockpos.subtract(blockpos1);
    }

    public static BlockPos transformedBlockPos(PlacementSettings placementIn, BlockPos pos) {
        return Template.getTransformedPos(pos, placementIn.getMirror(), placementIn.getRotation(), placementIn.getCenterOffset());
    }

    public void func_237144_a_(IServerWorld p_237144_1_, BlockPos p_237144_2_, PlacementSettings p_237144_3_, Random p_237144_4_) {
        p_237144_3_.setBoundingBoxFromChunk();
        this.func_237152_b_(p_237144_1_, p_237144_2_, p_237144_3_, p_237144_4_);
    }

    public void func_237152_b_(IServerWorld p_237152_1_, BlockPos p_237152_2_, PlacementSettings p_237152_3_, Random p_237152_4_) {
        this.func_237146_a_(p_237152_1_, p_237152_2_, p_237152_2_, p_237152_3_, p_237152_4_, 2);
    }

    public boolean func_237146_a_(IServerWorld p_237146_1_, BlockPos p_237146_2_, BlockPos p_237146_3_, PlacementSettings p_237146_4_, Random p_237146_5_, int p_237146_6_) {
        if (this.blocks.isEmpty()) {
            return false;
        }
        List<BlockInfo> list = p_237146_4_.func_237132_a_(this.blocks, p_237146_2_).func_237157_a_();
        if (!(list.isEmpty() && (p_237146_4_.getIgnoreEntities() || this.entities.isEmpty()) || this.size.getX() < 1 || this.size.getY() < 1 || this.size.getZ() < 1)) {
            MutableBoundingBox mutableboundingbox = p_237146_4_.getBoundingBox();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(p_237146_4_.func_204763_l() ? list.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)list.size());
            int i = Integer.MAX_VALUE;
            int j = Integer.MAX_VALUE;
            int k = Integer.MAX_VALUE;
            int l = Integer.MIN_VALUE;
            int i1 = Integer.MIN_VALUE;
            int j1 = Integer.MIN_VALUE;
            for (BlockInfo template$blockinfo : Template.func_237145_a_(p_237146_1_, p_237146_2_, p_237146_3_, p_237146_4_, list)) {
                TileEntity tileentity1;
                BlockPos blockpos = template$blockinfo.pos;
                if (mutableboundingbox != null && !mutableboundingbox.isVecInside(blockpos)) continue;
                FluidState fluidstate = p_237146_4_.func_204763_l() ? p_237146_1_.getFluidState(blockpos) : null;
                BlockState blockstate = template$blockinfo.state.mirror(p_237146_4_.getMirror()).rotate(p_237146_4_.getRotation());
                if (template$blockinfo.nbt != null) {
                    TileEntity tileentity = p_237146_1_.getTileEntity(blockpos);
                    IClearable.clearObj(tileentity);
                    p_237146_1_.setBlockState(blockpos, Blocks.BARRIER.getDefaultState(), 20);
                }
                if (!p_237146_1_.setBlockState(blockpos, blockstate, p_237146_6_)) continue;
                i = Math.min(i, blockpos.getX());
                j = Math.min(j, blockpos.getY());
                k = Math.min(k, blockpos.getZ());
                l = Math.max(l, blockpos.getX());
                i1 = Math.max(i1, blockpos.getY());
                j1 = Math.max(j1, blockpos.getZ());
                list2.add(Pair.of((Object)blockpos, (Object)template$blockinfo.nbt));
                if (template$blockinfo.nbt != null && (tileentity1 = p_237146_1_.getTileEntity(blockpos)) != null) {
                    template$blockinfo.nbt.putInt("x", blockpos.getX());
                    template$blockinfo.nbt.putInt("y", blockpos.getY());
                    template$blockinfo.nbt.putInt("z", blockpos.getZ());
                    if (tileentity1 instanceof LockableLootTileEntity) {
                        template$blockinfo.nbt.putLong("LootTableSeed", p_237146_5_.nextLong());
                    }
                    tileentity1.read(template$blockinfo.state, template$blockinfo.nbt);
                    tileentity1.mirror(p_237146_4_.getMirror());
                    tileentity1.rotate(p_237146_4_.getRotation());
                }
                if (fluidstate == null || !(blockstate.getBlock() instanceof ILiquidContainer)) continue;
                ((ILiquidContainer)((Object)blockstate.getBlock())).receiveFluid(p_237146_1_, blockpos, blockstate, fluidstate);
                if (fluidstate.isSource()) continue;
                list1.add(blockpos);
            }
            boolean flag = true;
            Direction[] adirection = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
            while (flag && !list1.isEmpty()) {
                flag = false;
                Iterator iterator = list1.iterator();
                while (iterator.hasNext()) {
                    BlockState blockstate2;
                    Block block;
                    BlockPos blockpos2;
                    BlockPos blockpos3 = blockpos2 = (BlockPos)iterator.next();
                    FluidState fluidstate2 = p_237146_1_.getFluidState(blockpos2);
                    for (int k1 = 0; k1 < adirection.length && !fluidstate2.isSource(); ++k1) {
                        BlockPos blockpos1 = blockpos3.offset(adirection[k1]);
                        FluidState fluidstate1 = p_237146_1_.getFluidState(blockpos1);
                        if (!(fluidstate1.getActualHeight(p_237146_1_, blockpos1) > fluidstate2.getActualHeight(p_237146_1_, blockpos3)) && (!fluidstate1.isSource() || fluidstate2.isSource())) continue;
                        fluidstate2 = fluidstate1;
                        blockpos3 = blockpos1;
                    }
                    if (!fluidstate2.isSource() || !((block = (blockstate2 = p_237146_1_.getBlockState(blockpos2)).getBlock()) instanceof ILiquidContainer)) continue;
                    ((ILiquidContainer)((Object)block)).receiveFluid(p_237146_1_, blockpos2, blockstate2, fluidstate2);
                    flag = true;
                    iterator.remove();
                }
            }
            if (i <= l) {
                if (!p_237146_4_.func_215218_i()) {
                    BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(l - i + 1, i1 - j + 1, j1 - k + 1);
                    int l1 = i;
                    int i2 = j;
                    int j2 = k;
                    for (Pair pair1 : list2) {
                        BlockPos blockpos5 = (BlockPos)pair1.getFirst();
                        ((VoxelShapePart)voxelshapepart).setFilled(blockpos5.getX() - l1, blockpos5.getY() - i2, blockpos5.getZ() - j2, true, true);
                    }
                    Template.func_222857_a(p_237146_1_, p_237146_6_, voxelshapepart, l1, i2, j2);
                }
                for (Pair pair : list2) {
                    TileEntity tileentity2;
                    BlockPos blockpos4 = (BlockPos)pair.getFirst();
                    if (!p_237146_4_.func_215218_i()) {
                        BlockState blockstate3;
                        BlockState blockstate1 = p_237146_1_.getBlockState(blockpos4);
                        if (blockstate1 != (blockstate3 = Block.getValidBlockForPosition(blockstate1, p_237146_1_, blockpos4))) {
                            p_237146_1_.setBlockState(blockpos4, blockstate3, p_237146_6_ & 0xFFFFFFFE | 0x10);
                        }
                        p_237146_1_.func_230547_a_(blockpos4, blockstate3.getBlock());
                    }
                    if (pair.getSecond() == null || (tileentity2 = p_237146_1_.getTileEntity(blockpos4)) == null) continue;
                    tileentity2.markDirty();
                }
            }
            if (!p_237146_4_.getIgnoreEntities()) {
                this.func_237143_a_(p_237146_1_, p_237146_2_, p_237146_4_.getMirror(), p_237146_4_.getRotation(), p_237146_4_.getCenterOffset(), mutableboundingbox, p_237146_4_.func_237134_m_());
            }
            return true;
        }
        return false;
    }

    public static void func_222857_a(IWorld worldIn, int p_222857_1_, VoxelShapePart voxelShapePartIn, int xIn, int yIn, int zIn) {
        voxelShapePartIn.forEachFace((p_237141_5_, p_237141_6_, p_237141_7_, p_237141_8_) -> {
            BlockState blockstate3;
            BlockState blockstate1;
            BlockState blockstate2;
            BlockPos blockpos = new BlockPos(xIn + p_237141_6_, yIn + p_237141_7_, zIn + p_237141_8_);
            BlockPos blockpos1 = blockpos.offset(p_237141_5_);
            BlockState blockstate = worldIn.getBlockState(blockpos);
            if (blockstate != (blockstate2 = blockstate.updatePostPlacement(p_237141_5_, blockstate1 = worldIn.getBlockState(blockpos1), worldIn, blockpos, blockpos1))) {
                worldIn.setBlockState(blockpos, blockstate2, p_222857_1_ & 0xFFFFFFFE);
            }
            if (blockstate1 != (blockstate3 = blockstate1.updatePostPlacement(p_237141_5_.getOpposite(), blockstate2, worldIn, blockpos1, blockpos))) {
                worldIn.setBlockState(blockpos1, blockstate3, p_222857_1_ & 0xFFFFFFFE);
            }
        });
    }

    public static List<BlockInfo> func_237145_a_(IWorld p_237145_0_, BlockPos p_237145_1_, BlockPos p_237145_2_, PlacementSettings p_237145_3_, List<BlockInfo> p_237145_4_) {
        ArrayList list = Lists.newArrayList();
        for (BlockInfo template$blockinfo : p_237145_4_) {
            BlockPos blockpos = Template.transformedBlockPos(p_237145_3_, template$blockinfo.pos).add(p_237145_1_);
            BlockInfo template$blockinfo1 = new BlockInfo(blockpos, template$blockinfo.state, template$blockinfo.nbt != null ? template$blockinfo.nbt.copy() : null);
            Iterator<StructureProcessor> iterator = p_237145_3_.getProcessors().iterator();
            while (template$blockinfo1 != null && iterator.hasNext()) {
                template$blockinfo1 = iterator.next().func_230386_a_(p_237145_0_, p_237145_1_, p_237145_2_, template$blockinfo, template$blockinfo1, p_237145_3_);
            }
            if (template$blockinfo1 == null) continue;
            list.add(template$blockinfo1);
        }
        return list;
    }

    private void func_237143_a_(IServerWorld p_237143_1_, BlockPos p_237143_2_, Mirror p_237143_3_, Rotation p_237143_4_, BlockPos p_237143_5_, @Nullable MutableBoundingBox p_237143_6_, boolean p_237143_7_) {
        for (EntityInfo template$entityinfo : this.entities) {
            BlockPos blockpos = Template.getTransformedPos(template$entityinfo.blockPos, p_237143_3_, p_237143_4_, p_237143_5_).add(p_237143_2_);
            if (p_237143_6_ != null && !p_237143_6_.isVecInside(blockpos)) continue;
            CompoundNBT compoundnbt = template$entityinfo.nbt.copy();
            Vector3d vector3d = Template.getTransformedPos(template$entityinfo.pos, p_237143_3_, p_237143_4_, p_237143_5_);
            Vector3d vector3d1 = vector3d.add(p_237143_2_.getX(), p_237143_2_.getY(), p_237143_2_.getZ());
            ListNBT listnbt = new ListNBT();
            listnbt.add(DoubleNBT.valueOf(vector3d1.x));
            listnbt.add(DoubleNBT.valueOf(vector3d1.y));
            listnbt.add(DoubleNBT.valueOf(vector3d1.z));
            compoundnbt.put("Pos", listnbt);
            compoundnbt.remove("UUID");
            Template.loadEntity(p_237143_1_, compoundnbt).ifPresent(p_242927_6_ -> {
                float f = p_242927_6_.getMirroredYaw(p_237143_3_);
                p_242927_6_.setLocationAndAngles(vector3d1.x, vector3d1.y, vector3d1.z, f += p_242927_6_.rotationYaw - p_242927_6_.getRotatedYaw(p_237143_4_), p_242927_6_.rotationPitch);
                if (p_237143_7_ && p_242927_6_ instanceof MobEntity) {
                    ((MobEntity)p_242927_6_).onInitialSpawn(p_237143_1_, p_237143_1_.getDifficultyForLocation(new BlockPos(vector3d1)), SpawnReason.STRUCTURE, null, compoundnbt);
                }
                p_237143_1_.func_242417_l((Entity)p_242927_6_);
            });
        }
    }

    private static Optional<Entity> loadEntity(IServerWorld worldIn, CompoundNBT nbt) {
        try {
            return EntityType.loadEntityUnchecked(nbt, worldIn.getWorld());
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public BlockPos transformedSize(Rotation rotationIn) {
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new BlockPos(this.size.getZ(), this.size.getY(), this.size.getX());
            }
        }
        return this.size;
    }

    public static BlockPos getTransformedPos(BlockPos targetPos, Mirror mirrorIn, Rotation rotationIn, BlockPos offset) {
        int i = targetPos.getX();
        int j = targetPos.getY();
        int k = targetPos.getZ();
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                k = -k;
                break;
            }
            case FRONT_BACK: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        int l = offset.getX();
        int i1 = offset.getZ();
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(l - i1 + k, j, l + i1 - i);
            }
            case CLOCKWISE_90: {
                return new BlockPos(l + i1 - k, j, i1 - l + i);
            }
            case CLOCKWISE_180: {
                return new BlockPos(l + l - i, j, i1 + i1 - k);
            }
        }
        return flag ? new BlockPos(i, j, k) : targetPos;
    }

    public static Vector3d getTransformedPos(Vector3d target, Mirror mirrorIn, Rotation rotationIn, BlockPos centerOffset) {
        double d0 = target.x;
        double d1 = target.y;
        double d2 = target.z;
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                d2 = 1.0 - d2;
                break;
            }
            case FRONT_BACK: {
                d0 = 1.0 - d0;
                break;
            }
            default: {
                flag = false;
            }
        }
        int i = centerOffset.getX();
        int j = centerOffset.getZ();
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new Vector3d((double)(i - j) + d2, d1, (double)(i + j + 1) - d0);
            }
            case CLOCKWISE_90: {
                return new Vector3d((double)(i + j + 1) - d2, d1, (double)(j - i) + d0);
            }
            case CLOCKWISE_180: {
                return new Vector3d((double)(i + i + 1) - d0, d1, (double)(j + j + 1) - d2);
            }
        }
        return flag ? new Vector3d(d0, d1, d2) : target;
    }

    public BlockPos getZeroPositionWithTransform(BlockPos p_189961_1_, Mirror p_189961_2_, Rotation p_189961_3_) {
        return Template.getZeroPositionWithTransform(p_189961_1_, p_189961_2_, p_189961_3_, this.getSize().getX(), this.getSize().getZ());
    }

    public static BlockPos getZeroPositionWithTransform(BlockPos p_191157_0_, Mirror p_191157_1_, Rotation p_191157_2_, int p_191157_3_, int p_191157_4_) {
        int i = p_191157_1_ == Mirror.FRONT_BACK ? --p_191157_3_ : 0;
        int j = p_191157_1_ == Mirror.LEFT_RIGHT ? --p_191157_4_ : 0;
        BlockPos blockpos = p_191157_0_;
        switch (p_191157_2_) {
            case COUNTERCLOCKWISE_90: {
                blockpos = p_191157_0_.add(j, 0, p_191157_3_ - i);
                break;
            }
            case CLOCKWISE_90: {
                blockpos = p_191157_0_.add(p_191157_4_ - j, 0, i);
                break;
            }
            case CLOCKWISE_180: {
                blockpos = p_191157_0_.add(p_191157_3_ - i, 0, p_191157_4_ - j);
                break;
            }
            case NONE: {
                blockpos = p_191157_0_.add(i, 0, j);
            }
        }
        return blockpos;
    }

    public MutableBoundingBox getMutableBoundingBox(PlacementSettings p_215388_1_, BlockPos p_215388_2_) {
        return this.func_237150_a_(p_215388_2_, p_215388_1_.getRotation(), p_215388_1_.getCenterOffset(), p_215388_1_.getMirror());
    }

    public MutableBoundingBox func_237150_a_(BlockPos p_237150_1_, Rotation p_237150_2_, BlockPos p_237150_3_, Mirror p_237150_4_) {
        BlockPos blockpos = this.transformedSize(p_237150_2_);
        int i = p_237150_3_.getX();
        int j = p_237150_3_.getZ();
        int k = blockpos.getX() - 1;
        int l = blockpos.getY() - 1;
        int i1 = blockpos.getZ() - 1;
        MutableBoundingBox mutableboundingbox = new MutableBoundingBox(0, 0, 0, 0, 0, 0);
        switch (p_237150_2_) {
            case COUNTERCLOCKWISE_90: {
                mutableboundingbox = new MutableBoundingBox(i - j, 0, i + j - i1, i - j + k, l, i + j);
                break;
            }
            case CLOCKWISE_90: {
                mutableboundingbox = new MutableBoundingBox(i + j - k, 0, j - i, i + j, l, j - i + i1);
                break;
            }
            case CLOCKWISE_180: {
                mutableboundingbox = new MutableBoundingBox(i + i - k, 0, j + j - i1, i + i, l, j + j);
                break;
            }
            case NONE: {
                mutableboundingbox = new MutableBoundingBox(0, 0, 0, k, l, i1);
            }
        }
        switch (p_237150_4_) {
            case LEFT_RIGHT: {
                this.func_215385_a(p_237150_2_, i1, k, mutableboundingbox, Direction.NORTH, Direction.SOUTH);
                break;
            }
            case FRONT_BACK: {
                this.func_215385_a(p_237150_2_, k, i1, mutableboundingbox, Direction.WEST, Direction.EAST);
            }
        }
        mutableboundingbox.offset(p_237150_1_.getX(), p_237150_1_.getY(), p_237150_1_.getZ());
        return mutableboundingbox;
    }

    private void func_215385_a(Rotation rotationIn, int offsetFront, int p_215385_3_, MutableBoundingBox p_215385_4_, Direction p_215385_5_, Direction p_215385_6_) {
        BlockPos blockpos = BlockPos.ZERO;
        blockpos = rotationIn != Rotation.CLOCKWISE_90 && rotationIn != Rotation.COUNTERCLOCKWISE_90 ? (rotationIn == Rotation.CLOCKWISE_180 ? blockpos.offset(p_215385_6_, offsetFront) : blockpos.offset(p_215385_5_, offsetFront)) : blockpos.offset(rotationIn.rotate(p_215385_5_), p_215385_3_);
        p_215385_4_.offset(blockpos.getX(), 0, blockpos.getZ());
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        if (this.blocks.isEmpty()) {
            nbt.put("blocks", new ListNBT());
            nbt.put("palette", new ListNBT());
        } else {
            ArrayList list = Lists.newArrayList();
            BasicPalette template$basicpalette = new BasicPalette();
            list.add(template$basicpalette);
            for (int i = 1; i < this.blocks.size(); ++i) {
                list.add(new BasicPalette());
            }
            ListNBT listnbt1 = new ListNBT();
            List<BlockInfo> list1 = this.blocks.get(0).func_237157_a_();
            for (int j = 0; j < list1.size(); ++j) {
                BlockInfo template$blockinfo = list1.get(j);
                CompoundNBT compoundnbt = new CompoundNBT();
                compoundnbt.put("pos", this.writeInts(template$blockinfo.pos.getX(), template$blockinfo.pos.getY(), template$blockinfo.pos.getZ()));
                int k = template$basicpalette.idFor(template$blockinfo.state);
                compoundnbt.putInt("state", k);
                if (template$blockinfo.nbt != null) {
                    compoundnbt.put("nbt", template$blockinfo.nbt);
                }
                listnbt1.add(compoundnbt);
                for (int l = 1; l < this.blocks.size(); ++l) {
                    BasicPalette template$basicpalette1 = (BasicPalette)list.get(l);
                    template$basicpalette1.addMapping(this.blocks.get((int)l).func_237157_a_().get((int)j).state, k);
                }
            }
            nbt.put("blocks", listnbt1);
            if (list.size() == 1) {
                ListNBT listnbt2 = new ListNBT();
                for (BlockState blockstate : template$basicpalette) {
                    listnbt2.add(NBTUtil.writeBlockState(blockstate));
                }
                nbt.put("palette", listnbt2);
            } else {
                ListNBT listnbt3 = new ListNBT();
                for (BasicPalette template$basicpalette2 : list) {
                    ListNBT listnbt4 = new ListNBT();
                    for (BlockState blockstate1 : template$basicpalette2) {
                        listnbt4.add(NBTUtil.writeBlockState(blockstate1));
                    }
                    listnbt3.add(listnbt4);
                }
                nbt.put("palettes", listnbt3);
            }
        }
        ListNBT listnbt = new ListNBT();
        for (EntityInfo template$entityinfo : this.entities) {
            CompoundNBT compoundnbt1 = new CompoundNBT();
            compoundnbt1.put("pos", this.writeDoubles(template$entityinfo.pos.x, template$entityinfo.pos.y, template$entityinfo.pos.z));
            compoundnbt1.put("blockPos", this.writeInts(template$entityinfo.blockPos.getX(), template$entityinfo.blockPos.getY(), template$entityinfo.blockPos.getZ()));
            if (template$entityinfo.nbt != null) {
                compoundnbt1.put("nbt", template$entityinfo.nbt);
            }
            listnbt.add(compoundnbt1);
        }
        nbt.put("entities", listnbt);
        nbt.put("size", this.writeInts(this.size.getX(), this.size.getY(), this.size.getZ()));
        nbt.putInt("DataVersion", SharedConstants.getVersion().getWorldVersion());
        return nbt;
    }

    public void read(CompoundNBT compound) {
        this.blocks.clear();
        this.entities.clear();
        ListNBT listnbt = compound.getList("size", 3);
        this.size = new BlockPos(listnbt.getInt(0), listnbt.getInt(1), listnbt.getInt(2));
        ListNBT listnbt1 = compound.getList("blocks", 10);
        if (compound.contains("palettes", 9)) {
            ListNBT listnbt2 = compound.getList("palettes", 9);
            for (int i = 0; i < listnbt2.size(); ++i) {
                this.readPalletesAndBlocks(listnbt2.getList(i), listnbt1);
            }
        } else {
            this.readPalletesAndBlocks(compound.getList("palette", 10), listnbt1);
        }
        ListNBT listnbt5 = compound.getList("entities", 10);
        for (int j = 0; j < listnbt5.size(); ++j) {
            CompoundNBT compoundnbt = listnbt5.getCompound(j);
            ListNBT listnbt3 = compoundnbt.getList("pos", 6);
            Vector3d vector3d = new Vector3d(listnbt3.getDouble(0), listnbt3.getDouble(1), listnbt3.getDouble(2));
            ListNBT listnbt4 = compoundnbt.getList("blockPos", 3);
            BlockPos blockpos = new BlockPos(listnbt4.getInt(0), listnbt4.getInt(1), listnbt4.getInt(2));
            if (!compoundnbt.contains("nbt")) continue;
            CompoundNBT compoundnbt1 = compoundnbt.getCompound("nbt");
            this.entities.add(new EntityInfo(vector3d, blockpos, compoundnbt1));
        }
    }

    private void readPalletesAndBlocks(ListNBT palletesNBT, ListNBT blocksNBT) {
        BasicPalette template$basicpalette = new BasicPalette();
        for (int i = 0; i < palletesNBT.size(); ++i) {
            template$basicpalette.addMapping(NBTUtil.readBlockState(palletesNBT.getCompound(i)), i);
        }
        ArrayList list2 = Lists.newArrayList();
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        for (int j = 0; j < blocksNBT.size(); ++j) {
            CompoundNBT compoundnbt = blocksNBT.getCompound(j);
            ListNBT listnbt = compoundnbt.getList("pos", 3);
            BlockPos blockpos = new BlockPos(listnbt.getInt(0), listnbt.getInt(1), listnbt.getInt(2));
            BlockState blockstate = template$basicpalette.stateFor(compoundnbt.getInt("state"));
            CompoundNBT compoundnbt1 = compoundnbt.contains("nbt") ? compoundnbt.getCompound("nbt") : null;
            BlockInfo template$blockinfo = new BlockInfo(blockpos, blockstate, compoundnbt1);
            Template.func_237149_a_(template$blockinfo, list2, list, list1);
        }
        List<BlockInfo> list3 = Template.func_237151_a_(list2, list, list1);
        this.blocks.add(new Palette(list3));
    }

    private ListNBT writeInts(int ... values) {
        ListNBT listnbt = new ListNBT();
        for (int i : values) {
            listnbt.add(IntNBT.valueOf(i));
        }
        return listnbt;
    }

    private ListNBT writeDoubles(double ... values) {
        ListNBT listnbt = new ListNBT();
        for (double d0 : values) {
            listnbt.add(DoubleNBT.valueOf(d0));
        }
        return listnbt;
    }

    public static class BlockInfo {
        public final BlockPos pos;
        public final BlockState state;
        public final CompoundNBT nbt;

        public BlockInfo(BlockPos pos, BlockState state, @Nullable CompoundNBT nbt) {
            this.pos = pos;
            this.state = state;
            this.nbt = nbt;
        }

        public String toString() {
            return String.format("<StructureBlockInfo | %s | %s | %s>", this.pos, this.state, this.nbt);
        }
    }

    public static final class Palette {
        private final List<BlockInfo> field_237155_a_;
        private final Map<Block, List<BlockInfo>> field_237156_b_ = Maps.newHashMap();

        private Palette(List<BlockInfo> p_i232120_1_) {
            this.field_237155_a_ = p_i232120_1_;
        }

        public List<BlockInfo> func_237157_a_() {
            return this.field_237155_a_;
        }

        public List<BlockInfo> func_237158_a_(Block p_237158_1_) {
            return this.field_237156_b_.computeIfAbsent(p_237158_1_, p_237160_1_ -> this.field_237155_a_.stream().filter(p_237159_1_ -> p_237159_1_.state.isIn((Block)p_237160_1_)).collect(Collectors.toList()));
        }
    }

    public static class EntityInfo {
        public final Vector3d pos;
        public final BlockPos blockPos;
        public final CompoundNBT nbt;

        public EntityInfo(Vector3d vecIn, BlockPos posIn, CompoundNBT nbt) {
            this.pos = vecIn;
            this.blockPos = posIn;
            this.nbt = nbt;
        }
    }

    static class BasicPalette
    implements Iterable<BlockState> {
        public static final BlockState DEFAULT_BLOCK_STATE = Blocks.AIR.getDefaultState();
        private final ObjectIntIdentityMap<BlockState> ids = new ObjectIntIdentityMap(16);
        private int lastId;

        private BasicPalette() {
        }

        public int idFor(BlockState state) {
            int i = this.ids.getId(state);
            if (i == -1) {
                i = this.lastId++;
                this.ids.put(state, i);
            }
            return i;
        }

        @Nullable
        public BlockState stateFor(int id) {
            BlockState blockstate = this.ids.getByValue(id);
            return blockstate == null ? DEFAULT_BLOCK_STATE : blockstate;
        }

        @Override
        public Iterator<BlockState> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(BlockState p_189956_1_, int p_189956_2_) {
            this.ids.put(p_189956_1_, p_189956_2_);
        }
    }
}

