/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.MineshaftStructure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MineshaftPieces {
    private static Piece createRandomShaftPiece(List<StructurePiece> p_189940_0_, Random p_189940_1_, int p_189940_2_, int p_189940_3_, int p_189940_4_, @Nullable Direction p_189940_5_, int p_189940_6_, MineshaftStructure.Type p_189940_7_) {
        int i = p_189940_1_.nextInt(100);
        if (i >= 80) {
            MutableBoundingBox mutableboundingbox = Cross.findCrossing(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (mutableboundingbox != null) {
                return new Cross(p_189940_6_, mutableboundingbox, p_189940_5_, p_189940_7_);
            }
        } else if (i >= 70) {
            MutableBoundingBox mutableboundingbox1 = Stairs.findStairs(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (mutableboundingbox1 != null) {
                return new Stairs(p_189940_6_, mutableboundingbox1, p_189940_5_, p_189940_7_);
            }
        } else {
            MutableBoundingBox mutableboundingbox2 = Corridor.findCorridorSize(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (mutableboundingbox2 != null) {
                return new Corridor(p_189940_6_, p_189940_1_, mutableboundingbox2, p_189940_5_, p_189940_7_);
            }
        }
        return null;
    }

    private static Piece generateAndAddPiece(StructurePiece p_189938_0_, List<StructurePiece> p_189938_1_, Random p_189938_2_, int p_189938_3_, int p_189938_4_, int p_189938_5_, Direction p_189938_6_, int p_189938_7_) {
        if (p_189938_7_ > 8) {
            return null;
        }
        if (Math.abs(p_189938_3_ - p_189938_0_.getBoundingBox().minX) <= 80 && Math.abs(p_189938_5_ - p_189938_0_.getBoundingBox().minZ) <= 80) {
            MineshaftStructure.Type mineshaftstructure$type = ((Piece)p_189938_0_).mineShaftType;
            Piece mineshaftpieces$piece = MineshaftPieces.createRandomShaftPiece(p_189938_1_, p_189938_2_, p_189938_3_, p_189938_4_, p_189938_5_, p_189938_6_, p_189938_7_ + 1, mineshaftstructure$type);
            if (mineshaftpieces$piece != null) {
                p_189938_1_.add(mineshaftpieces$piece);
                mineshaftpieces$piece.buildComponent(p_189938_0_, p_189938_1_, p_189938_2_);
            }
            return mineshaftpieces$piece;
        }
        return null;
    }

    public static class Cross
    extends Piece {
        private final Direction corridorDirection;
        private final boolean isMultipleFloors;

        public Cross(TemplateManager p_i50454_1_, CompoundNBT p_i50454_2_) {
            super(IStructurePieceType.MSCROSSING, p_i50454_2_);
            this.isMultipleFloors = p_i50454_2_.getBoolean("tf");
            this.corridorDirection = Direction.byHorizontalIndex(p_i50454_2_.getInt("D"));
        }

        @Override
        protected void readAdditional(CompoundNBT tagCompound) {
            super.readAdditional(tagCompound);
            tagCompound.putBoolean("tf", this.isMultipleFloors);
            tagCompound.putInt("D", this.corridorDirection.getHorizontalIndex());
        }

        public Cross(int p_i50455_1_, MutableBoundingBox p_i50455_2_, @Nullable Direction p_i50455_3_, MineshaftStructure.Type p_i50455_4_) {
            super(IStructurePieceType.MSCROSSING, p_i50455_1_, p_i50455_4_);
            this.corridorDirection = p_i50455_3_;
            this.boundingBox = p_i50455_2_;
            this.isMultipleFloors = p_i50455_2_.getYSize() > 3;
        }

        public static MutableBoundingBox findCrossing(List<StructurePiece> listIn, Random rand, int x, int y, int z, Direction facing) {
            MutableBoundingBox mutableboundingbox = new MutableBoundingBox(x, y, z, x, y + 3 - 1, z);
            if (rand.nextInt(4) == 0) {
                mutableboundingbox.maxY += 4;
            }
            switch (facing) {
                default: {
                    mutableboundingbox.minX = x - 1;
                    mutableboundingbox.maxX = x + 3;
                    mutableboundingbox.minZ = z - 4;
                    break;
                }
                case SOUTH: {
                    mutableboundingbox.minX = x - 1;
                    mutableboundingbox.maxX = x + 3;
                    mutableboundingbox.maxZ = z + 3 + 1;
                    break;
                }
                case WEST: {
                    mutableboundingbox.minX = x - 4;
                    mutableboundingbox.minZ = z - 1;
                    mutableboundingbox.maxZ = z + 3;
                    break;
                }
                case EAST: {
                    mutableboundingbox.maxX = x + 3 + 1;
                    mutableboundingbox.minZ = z - 1;
                    mutableboundingbox.maxZ = z + 3;
                }
            }
            return StructurePiece.findIntersecting(listIn, mutableboundingbox) != null ? null : mutableboundingbox;
        }

        @Override
        public void buildComponent(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            int i = this.getComponentType();
            switch (this.corridorDirection) {
                default: {
                    MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.minZ - 1, Direction.NORTH, i);
                    MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX - 1, this.boundingBox.minY, this.boundingBox.minZ + 1, Direction.WEST, i);
                    MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.maxX + 1, this.boundingBox.minY, this.boundingBox.minZ + 1, Direction.EAST, i);
                    break;
                }
                case SOUTH: {
                    MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.maxZ + 1, Direction.SOUTH, i);
                    MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX - 1, this.boundingBox.minY, this.boundingBox.minZ + 1, Direction.WEST, i);
                    MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.maxX + 1, this.boundingBox.minY, this.boundingBox.minZ + 1, Direction.EAST, i);
                    break;
                }
                case WEST: {
                    MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.minZ - 1, Direction.NORTH, i);
                    MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.maxZ + 1, Direction.SOUTH, i);
                    MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX - 1, this.boundingBox.minY, this.boundingBox.minZ + 1, Direction.WEST, i);
                    break;
                }
                case EAST: {
                    MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.minZ - 1, Direction.NORTH, i);
                    MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.maxZ + 1, Direction.SOUTH, i);
                    MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.maxX + 1, this.boundingBox.minY, this.boundingBox.minZ + 1, Direction.EAST, i);
                }
            }
            if (this.isMultipleFloors) {
                if (rand.nextBoolean()) {
                    MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX + 1, this.boundingBox.minY + 3 + 1, this.boundingBox.minZ - 1, Direction.NORTH, i);
                }
                if (rand.nextBoolean()) {
                    MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX - 1, this.boundingBox.minY + 3 + 1, this.boundingBox.minZ + 1, Direction.WEST, i);
                }
                if (rand.nextBoolean()) {
                    MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.maxX + 1, this.boundingBox.minY + 3 + 1, this.boundingBox.minZ + 1, Direction.EAST, i);
                }
                if (rand.nextBoolean()) {
                    MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX + 1, this.boundingBox.minY + 3 + 1, this.boundingBox.maxZ + 1, Direction.SOUTH, i);
                }
            }
        }

        @Override
        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            if (this.isLiquidInStructureBoundingBox(p_230383_1_, p_230383_5_)) {
                return false;
            }
            BlockState blockstate = this.getPlanksBlock();
            if (this.isMultipleFloors) {
                this.fillWithBlocks(p_230383_1_, p_230383_5_, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.minZ, this.boundingBox.maxX - 1, this.boundingBox.minY + 3 - 1, this.boundingBox.maxZ, CAVE_AIR, CAVE_AIR, false);
                this.fillWithBlocks(p_230383_1_, p_230383_5_, this.boundingBox.minX, this.boundingBox.minY, this.boundingBox.minZ + 1, this.boundingBox.maxX, this.boundingBox.minY + 3 - 1, this.boundingBox.maxZ - 1, CAVE_AIR, CAVE_AIR, false);
                this.fillWithBlocks(p_230383_1_, p_230383_5_, this.boundingBox.minX + 1, this.boundingBox.maxY - 2, this.boundingBox.minZ, this.boundingBox.maxX - 1, this.boundingBox.maxY, this.boundingBox.maxZ, CAVE_AIR, CAVE_AIR, false);
                this.fillWithBlocks(p_230383_1_, p_230383_5_, this.boundingBox.minX, this.boundingBox.maxY - 2, this.boundingBox.minZ + 1, this.boundingBox.maxX, this.boundingBox.maxY, this.boundingBox.maxZ - 1, CAVE_AIR, CAVE_AIR, false);
                this.fillWithBlocks(p_230383_1_, p_230383_5_, this.boundingBox.minX + 1, this.boundingBox.minY + 3, this.boundingBox.minZ + 1, this.boundingBox.maxX - 1, this.boundingBox.minY + 3, this.boundingBox.maxZ - 1, CAVE_AIR, CAVE_AIR, false);
            } else {
                this.fillWithBlocks(p_230383_1_, p_230383_5_, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.minZ, this.boundingBox.maxX - 1, this.boundingBox.maxY, this.boundingBox.maxZ, CAVE_AIR, CAVE_AIR, false);
                this.fillWithBlocks(p_230383_1_, p_230383_5_, this.boundingBox.minX, this.boundingBox.minY, this.boundingBox.minZ + 1, this.boundingBox.maxX, this.boundingBox.maxY, this.boundingBox.maxZ - 1, CAVE_AIR, CAVE_AIR, false);
            }
            this.placeSupportPillar(p_230383_1_, p_230383_5_, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.minZ + 1, this.boundingBox.maxY);
            this.placeSupportPillar(p_230383_1_, p_230383_5_, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.maxZ - 1, this.boundingBox.maxY);
            this.placeSupportPillar(p_230383_1_, p_230383_5_, this.boundingBox.maxX - 1, this.boundingBox.minY, this.boundingBox.minZ + 1, this.boundingBox.maxY);
            this.placeSupportPillar(p_230383_1_, p_230383_5_, this.boundingBox.maxX - 1, this.boundingBox.minY, this.boundingBox.maxZ - 1, this.boundingBox.maxY);
            for (int i = this.boundingBox.minX; i <= this.boundingBox.maxX; ++i) {
                for (int j = this.boundingBox.minZ; j <= this.boundingBox.maxZ; ++j) {
                    if (!this.getBlockStateFromPos(p_230383_1_, i, this.boundingBox.minY - 1, j, p_230383_5_).isAir() || !this.getSkyBrightness(p_230383_1_, i, this.boundingBox.minY - 1, j, p_230383_5_)) continue;
                    this.setBlockState(p_230383_1_, blockstate, i, this.boundingBox.minY - 1, j, p_230383_5_);
                }
            }
            return true;
        }

        private void placeSupportPillar(ISeedReader p_189923_1_, MutableBoundingBox p_189923_2_, int p_189923_3_, int p_189923_4_, int p_189923_5_, int p_189923_6_) {
            if (!this.getBlockStateFromPos(p_189923_1_, p_189923_3_, p_189923_6_ + 1, p_189923_5_, p_189923_2_).isAir()) {
                this.fillWithBlocks(p_189923_1_, p_189923_2_, p_189923_3_, p_189923_4_, p_189923_5_, p_189923_3_, p_189923_6_, p_189923_5_, this.getPlanksBlock(), CAVE_AIR, false);
            }
        }
    }

    public static class Stairs
    extends Piece {
        public Stairs(int p_i50449_1_, MutableBoundingBox p_i50449_2_, Direction p_i50449_3_, MineshaftStructure.Type p_i50449_4_) {
            super(IStructurePieceType.MSSTAIRS, p_i50449_1_, p_i50449_4_);
            this.setCoordBaseMode(p_i50449_3_);
            this.boundingBox = p_i50449_2_;
        }

        public Stairs(TemplateManager p_i50450_1_, CompoundNBT p_i50450_2_) {
            super(IStructurePieceType.MSSTAIRS, p_i50450_2_);
        }

        public static MutableBoundingBox findStairs(List<StructurePiece> listIn, Random rand, int x, int y, int z, Direction facing) {
            MutableBoundingBox mutableboundingbox = new MutableBoundingBox(x, y - 5, z, x, y + 3 - 1, z);
            switch (facing) {
                default: {
                    mutableboundingbox.maxX = x + 3 - 1;
                    mutableboundingbox.minZ = z - 8;
                    break;
                }
                case SOUTH: {
                    mutableboundingbox.maxX = x + 3 - 1;
                    mutableboundingbox.maxZ = z + 8;
                    break;
                }
                case WEST: {
                    mutableboundingbox.minX = x - 8;
                    mutableboundingbox.maxZ = z + 3 - 1;
                    break;
                }
                case EAST: {
                    mutableboundingbox.maxX = x + 8;
                    mutableboundingbox.maxZ = z + 3 - 1;
                }
            }
            return StructurePiece.findIntersecting(listIn, mutableboundingbox) != null ? null : mutableboundingbox;
        }

        @Override
        public void buildComponent(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            int i = this.getComponentType();
            Direction direction = this.getCoordBaseMode();
            if (direction != null) {
                switch (direction) {
                    default: {
                        MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX, this.boundingBox.minY, this.boundingBox.minZ - 1, Direction.NORTH, i);
                        break;
                    }
                    case SOUTH: {
                        MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX, this.boundingBox.minY, this.boundingBox.maxZ + 1, Direction.SOUTH, i);
                        break;
                    }
                    case WEST: {
                        MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX - 1, this.boundingBox.minY, this.boundingBox.minZ, Direction.WEST, i);
                        break;
                    }
                    case EAST: {
                        MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.maxX + 1, this.boundingBox.minY, this.boundingBox.minZ, Direction.EAST, i);
                    }
                }
            }
        }

        @Override
        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            if (this.isLiquidInStructureBoundingBox(p_230383_1_, p_230383_5_)) {
                return false;
            }
            this.fillWithBlocks(p_230383_1_, p_230383_5_, 0, 5, 0, 2, 7, 1, CAVE_AIR, CAVE_AIR, false);
            this.fillWithBlocks(p_230383_1_, p_230383_5_, 0, 0, 7, 2, 2, 8, CAVE_AIR, CAVE_AIR, false);
            for (int i = 0; i < 5; ++i) {
                this.fillWithBlocks(p_230383_1_, p_230383_5_, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, CAVE_AIR, CAVE_AIR, false);
            }
            return true;
        }
    }

    public static class Corridor
    extends Piece {
        private final boolean hasRails;
        private final boolean hasSpiders;
        private boolean spawnerPlaced;
        private final int sectionCount;

        public Corridor(TemplateManager p_i50456_1_, CompoundNBT p_i50456_2_) {
            super(IStructurePieceType.MSCORRIDOR, p_i50456_2_);
            this.hasRails = p_i50456_2_.getBoolean("hr");
            this.hasSpiders = p_i50456_2_.getBoolean("sc");
            this.spawnerPlaced = p_i50456_2_.getBoolean("hps");
            this.sectionCount = p_i50456_2_.getInt("Num");
        }

        @Override
        protected void readAdditional(CompoundNBT tagCompound) {
            super.readAdditional(tagCompound);
            tagCompound.putBoolean("hr", this.hasRails);
            tagCompound.putBoolean("sc", this.hasSpiders);
            tagCompound.putBoolean("hps", this.spawnerPlaced);
            tagCompound.putInt("Num", this.sectionCount);
        }

        public Corridor(int p_i47140_1_, Random p_i47140_2_, MutableBoundingBox p_i47140_3_, Direction p_i47140_4_, MineshaftStructure.Type p_i47140_5_) {
            super(IStructurePieceType.MSCORRIDOR, p_i47140_1_, p_i47140_5_);
            this.setCoordBaseMode(p_i47140_4_);
            this.boundingBox = p_i47140_3_;
            this.hasRails = p_i47140_2_.nextInt(3) == 0;
            this.hasSpiders = !this.hasRails && p_i47140_2_.nextInt(23) == 0;
            this.sectionCount = this.getCoordBaseMode().getAxis() == Direction.Axis.Z ? p_i47140_3_.getZSize() / 5 : p_i47140_3_.getXSize() / 5;
        }

        public static MutableBoundingBox findCorridorSize(List<StructurePiece> p_175814_0_, Random rand, int x, int y, int z, Direction facing) {
            int i;
            MutableBoundingBox mutableboundingbox = new MutableBoundingBox(x, y, z, x, y + 3 - 1, z);
            for (i = rand.nextInt(3) + 2; i > 0; --i) {
                int j = i * 5;
                switch (facing) {
                    default: {
                        mutableboundingbox.maxX = x + 3 - 1;
                        mutableboundingbox.minZ = z - (j - 1);
                        break;
                    }
                    case SOUTH: {
                        mutableboundingbox.maxX = x + 3 - 1;
                        mutableboundingbox.maxZ = z + j - 1;
                        break;
                    }
                    case WEST: {
                        mutableboundingbox.minX = x - (j - 1);
                        mutableboundingbox.maxZ = z + 3 - 1;
                        break;
                    }
                    case EAST: {
                        mutableboundingbox.maxX = x + j - 1;
                        mutableboundingbox.maxZ = z + 3 - 1;
                    }
                }
                if (StructurePiece.findIntersecting(p_175814_0_, mutableboundingbox) == null) break;
            }
            return i > 0 ? mutableboundingbox : null;
        }

        @Override
        public void buildComponent(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            block24: {
                int i = this.getComponentType();
                int j = rand.nextInt(4);
                Direction direction = this.getCoordBaseMode();
                if (direction != null) {
                    switch (direction) {
                        default: {
                            if (j <= 1) {
                                MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX, this.boundingBox.minY - 1 + rand.nextInt(3), this.boundingBox.minZ - 1, direction, i);
                                break;
                            }
                            if (j == 2) {
                                MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX - 1, this.boundingBox.minY - 1 + rand.nextInt(3), this.boundingBox.minZ, Direction.WEST, i);
                                break;
                            }
                            MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.maxX + 1, this.boundingBox.minY - 1 + rand.nextInt(3), this.boundingBox.minZ, Direction.EAST, i);
                            break;
                        }
                        case SOUTH: {
                            if (j <= 1) {
                                MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX, this.boundingBox.minY - 1 + rand.nextInt(3), this.boundingBox.maxZ + 1, direction, i);
                                break;
                            }
                            if (j == 2) {
                                MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX - 1, this.boundingBox.minY - 1 + rand.nextInt(3), this.boundingBox.maxZ - 3, Direction.WEST, i);
                                break;
                            }
                            MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.maxX + 1, this.boundingBox.minY - 1 + rand.nextInt(3), this.boundingBox.maxZ - 3, Direction.EAST, i);
                            break;
                        }
                        case WEST: {
                            if (j <= 1) {
                                MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX - 1, this.boundingBox.minY - 1 + rand.nextInt(3), this.boundingBox.minZ, direction, i);
                                break;
                            }
                            if (j == 2) {
                                MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX, this.boundingBox.minY - 1 + rand.nextInt(3), this.boundingBox.minZ - 1, Direction.NORTH, i);
                                break;
                            }
                            MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX, this.boundingBox.minY - 1 + rand.nextInt(3), this.boundingBox.maxZ + 1, Direction.SOUTH, i);
                            break;
                        }
                        case EAST: {
                            if (j <= 1) {
                                MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.maxX + 1, this.boundingBox.minY - 1 + rand.nextInt(3), this.boundingBox.minZ, direction, i);
                                break;
                            }
                            if (j == 2) {
                                MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.maxX - 3, this.boundingBox.minY - 1 + rand.nextInt(3), this.boundingBox.minZ - 1, Direction.NORTH, i);
                                break;
                            }
                            MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.maxX - 3, this.boundingBox.minY - 1 + rand.nextInt(3), this.boundingBox.maxZ + 1, Direction.SOUTH, i);
                        }
                    }
                }
                if (i >= 8) break block24;
                if (direction != Direction.NORTH && direction != Direction.SOUTH) {
                    int i1 = this.boundingBox.minX + 3;
                    while (i1 + 3 <= this.boundingBox.maxX) {
                        int j1 = rand.nextInt(5);
                        if (j1 == 0) {
                            MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, i1, this.boundingBox.minY, this.boundingBox.minZ - 1, Direction.NORTH, i + 1);
                        } else if (j1 == 1) {
                            MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, i1, this.boundingBox.minY, this.boundingBox.maxZ + 1, Direction.SOUTH, i + 1);
                        }
                        i1 += 5;
                    }
                } else {
                    int k = this.boundingBox.minZ + 3;
                    while (k + 3 <= this.boundingBox.maxZ) {
                        int l = rand.nextInt(5);
                        if (l == 0) {
                            MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX - 1, this.boundingBox.minY, k, Direction.WEST, i + 1);
                        } else if (l == 1) {
                            MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.maxX + 1, this.boundingBox.minY, k, Direction.EAST, i + 1);
                        }
                        k += 5;
                    }
                }
            }
        }

        @Override
        protected boolean generateChest(ISeedReader worldIn, MutableBoundingBox structurebb, Random randomIn, int x, int y, int z, ResourceLocation loot) {
            BlockPos blockpos = new BlockPos(this.getXWithOffset(x, z), this.getYWithOffset(y), this.getZWithOffset(x, z));
            if (structurebb.isVecInside(blockpos) && worldIn.getBlockState(blockpos).isAir() && !worldIn.getBlockState(blockpos.down()).isAir()) {
                BlockState blockstate = (BlockState)Blocks.RAIL.getDefaultState().with(RailBlock.SHAPE, randomIn.nextBoolean() ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST);
                this.setBlockState(worldIn, blockstate, x, y, z, structurebb);
                ChestMinecartEntity chestminecartentity = new ChestMinecartEntity(worldIn.getWorld(), (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5);
                chestminecartentity.setLootTable(loot, randomIn.nextLong());
                worldIn.addEntity(chestminecartentity);
                return true;
            }
            return false;
        }

        @Override
        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            if (this.isLiquidInStructureBoundingBox(p_230383_1_, p_230383_5_)) {
                return false;
            }
            boolean i = false;
            int j = 2;
            boolean k = false;
            int l = 2;
            int i1 = this.sectionCount * 5 - 1;
            BlockState blockstate = this.getPlanksBlock();
            this.fillWithBlocks(p_230383_1_, p_230383_5_, 0, 0, 0, 2, 1, i1, CAVE_AIR, CAVE_AIR, false);
            this.generateMaybeBox(p_230383_1_, p_230383_5_, p_230383_4_, 0.8f, 0, 2, 0, 2, 2, i1, CAVE_AIR, CAVE_AIR, false, false);
            if (this.hasSpiders) {
                this.generateMaybeBox(p_230383_1_, p_230383_5_, p_230383_4_, 0.6f, 0, 0, 0, 2, 1, i1, Blocks.COBWEB.getDefaultState(), CAVE_AIR, false, true);
            }
            for (int j1 = 0; j1 < this.sectionCount; ++j1) {
                int k2;
                int k1 = 2 + j1 * 5;
                this.placeSupport(p_230383_1_, p_230383_5_, 0, 0, k1, 2, 2, p_230383_4_);
                this.placeCobWeb(p_230383_1_, p_230383_5_, p_230383_4_, 0.1f, 0, 2, k1 - 1);
                this.placeCobWeb(p_230383_1_, p_230383_5_, p_230383_4_, 0.1f, 2, 2, k1 - 1);
                this.placeCobWeb(p_230383_1_, p_230383_5_, p_230383_4_, 0.1f, 0, 2, k1 + 1);
                this.placeCobWeb(p_230383_1_, p_230383_5_, p_230383_4_, 0.1f, 2, 2, k1 + 1);
                this.placeCobWeb(p_230383_1_, p_230383_5_, p_230383_4_, 0.05f, 0, 2, k1 - 2);
                this.placeCobWeb(p_230383_1_, p_230383_5_, p_230383_4_, 0.05f, 2, 2, k1 - 2);
                this.placeCobWeb(p_230383_1_, p_230383_5_, p_230383_4_, 0.05f, 0, 2, k1 + 2);
                this.placeCobWeb(p_230383_1_, p_230383_5_, p_230383_4_, 0.05f, 2, 2, k1 + 2);
                if (p_230383_4_.nextInt(100) == 0) {
                    this.generateChest(p_230383_1_, p_230383_5_, p_230383_4_, 2, 0, k1 - 1, LootTables.CHESTS_ABANDONED_MINESHAFT);
                }
                if (p_230383_4_.nextInt(100) == 0) {
                    this.generateChest(p_230383_1_, p_230383_5_, p_230383_4_, 0, 0, k1 + 1, LootTables.CHESTS_ABANDONED_MINESHAFT);
                }
                if (!this.hasSpiders || this.spawnerPlaced) continue;
                int l1 = this.getYWithOffset(0);
                int i2 = k1 - 1 + p_230383_4_.nextInt(3);
                int j2 = this.getXWithOffset(1, i2);
                BlockPos blockpos = new BlockPos(j2, l1, k2 = this.getZWithOffset(1, i2));
                if (!p_230383_5_.isVecInside(blockpos) || !this.getSkyBrightness(p_230383_1_, 1, 0, i2, p_230383_5_)) continue;
                this.spawnerPlaced = true;
                p_230383_1_.setBlockState(blockpos, Blocks.SPAWNER.getDefaultState(), 2);
                TileEntity tileentity = p_230383_1_.getTileEntity(blockpos);
                if (!(tileentity instanceof MobSpawnerTileEntity)) continue;
                ((MobSpawnerTileEntity)tileentity).getSpawnerBaseLogic().setEntityType(EntityType.CAVE_SPIDER);
            }
            for (int l2 = 0; l2 <= 2; ++l2) {
                for (int i3 = 0; i3 <= i1; ++i3) {
                    int k3 = -1;
                    BlockState blockstate3 = this.getBlockStateFromPos(p_230383_1_, l2, -1, i3, p_230383_5_);
                    if (!blockstate3.isAir() || !this.getSkyBrightness(p_230383_1_, l2, -1, i3, p_230383_5_)) continue;
                    int l3 = -1;
                    this.setBlockState(p_230383_1_, blockstate, l2, -1, i3, p_230383_5_);
                }
            }
            if (this.hasRails) {
                BlockState blockstate1 = (BlockState)Blocks.RAIL.getDefaultState().with(RailBlock.SHAPE, RailShape.NORTH_SOUTH);
                for (int j3 = 0; j3 <= i1; ++j3) {
                    BlockState blockstate2 = this.getBlockStateFromPos(p_230383_1_, 1, -1, j3, p_230383_5_);
                    if (blockstate2.isAir() || !blockstate2.isOpaqueCube(p_230383_1_, new BlockPos(this.getXWithOffset(1, j3), this.getYWithOffset(-1), this.getZWithOffset(1, j3)))) continue;
                    float f = this.getSkyBrightness(p_230383_1_, 1, 0, j3, p_230383_5_) ? 0.7f : 0.9f;
                    this.randomlyPlaceBlock(p_230383_1_, p_230383_5_, p_230383_4_, f, 1, 0, j3, blockstate1);
                }
            }
            return true;
        }

        private void placeSupport(ISeedReader p_189921_1_, MutableBoundingBox p_189921_2_, int p_189921_3_, int p_189921_4_, int p_189921_5_, int p_189921_6_, int p_189921_7_, Random p_189921_8_) {
            if (this.isSupportingBox(p_189921_1_, p_189921_2_, p_189921_3_, p_189921_7_, p_189921_6_, p_189921_5_)) {
                BlockState blockstate = this.getPlanksBlock();
                BlockState blockstate1 = this.getFenceBlock();
                this.fillWithBlocks(p_189921_1_, p_189921_2_, p_189921_3_, p_189921_4_, p_189921_5_, p_189921_3_, p_189921_6_ - 1, p_189921_5_, (BlockState)blockstate1.with(FenceBlock.WEST, true), CAVE_AIR, false);
                this.fillWithBlocks(p_189921_1_, p_189921_2_, p_189921_7_, p_189921_4_, p_189921_5_, p_189921_7_, p_189921_6_ - 1, p_189921_5_, (BlockState)blockstate1.with(FenceBlock.EAST, true), CAVE_AIR, false);
                if (p_189921_8_.nextInt(4) == 0) {
                    this.fillWithBlocks(p_189921_1_, p_189921_2_, p_189921_3_, p_189921_6_, p_189921_5_, p_189921_3_, p_189921_6_, p_189921_5_, blockstate, CAVE_AIR, false);
                    this.fillWithBlocks(p_189921_1_, p_189921_2_, p_189921_7_, p_189921_6_, p_189921_5_, p_189921_7_, p_189921_6_, p_189921_5_, blockstate, CAVE_AIR, false);
                } else {
                    this.fillWithBlocks(p_189921_1_, p_189921_2_, p_189921_3_, p_189921_6_, p_189921_5_, p_189921_7_, p_189921_6_, p_189921_5_, blockstate, CAVE_AIR, false);
                    this.randomlyPlaceBlock(p_189921_1_, p_189921_2_, p_189921_8_, 0.05f, p_189921_3_ + 1, p_189921_6_, p_189921_5_ - 1, (BlockState)Blocks.WALL_TORCH.getDefaultState().with(WallTorchBlock.HORIZONTAL_FACING, Direction.NORTH));
                    this.randomlyPlaceBlock(p_189921_1_, p_189921_2_, p_189921_8_, 0.05f, p_189921_3_ + 1, p_189921_6_, p_189921_5_ + 1, (BlockState)Blocks.WALL_TORCH.getDefaultState().with(WallTorchBlock.HORIZONTAL_FACING, Direction.SOUTH));
                }
            }
        }

        private void placeCobWeb(ISeedReader p_189922_1_, MutableBoundingBox p_189922_2_, Random p_189922_3_, float p_189922_4_, int p_189922_5_, int p_189922_6_, int p_189922_7_) {
            if (this.getSkyBrightness(p_189922_1_, p_189922_5_, p_189922_6_, p_189922_7_, p_189922_2_)) {
                this.randomlyPlaceBlock(p_189922_1_, p_189922_2_, p_189922_3_, p_189922_4_, p_189922_5_, p_189922_6_, p_189922_7_, Blocks.COBWEB.getDefaultState());
            }
        }
    }

    static abstract class Piece
    extends StructurePiece {
        protected MineshaftStructure.Type mineShaftType;

        public Piece(IStructurePieceType structurePieceTypeIn, int componentTypeIn, MineshaftStructure.Type typeIn) {
            super(structurePieceTypeIn, componentTypeIn);
            this.mineShaftType = typeIn;
        }

        public Piece(IStructurePieceType structurePieceTypeIn, CompoundNBT nbt) {
            super(structurePieceTypeIn, nbt);
            this.mineShaftType = MineshaftStructure.Type.byId(nbt.getInt("MST"));
        }

        @Override
        protected void readAdditional(CompoundNBT tagCompound) {
            tagCompound.putInt("MST", this.mineShaftType.ordinal());
        }

        protected BlockState getPlanksBlock() {
            switch (this.mineShaftType) {
                default: {
                    return Blocks.OAK_PLANKS.getDefaultState();
                }
                case MESA: 
            }
            return Blocks.DARK_OAK_PLANKS.getDefaultState();
        }

        protected BlockState getFenceBlock() {
            switch (this.mineShaftType) {
                default: {
                    return Blocks.OAK_FENCE.getDefaultState();
                }
                case MESA: 
            }
            return Blocks.DARK_OAK_FENCE.getDefaultState();
        }

        protected boolean isSupportingBox(IBlockReader blockReaderIn, MutableBoundingBox boundsIn, int xStartIn, int xEndIn, int p_189918_5_, int zIn) {
            for (int i = xStartIn; i <= xEndIn; ++i) {
                if (!this.getBlockStateFromPos(blockReaderIn, i, p_189918_5_ + 1, zIn, boundsIn).isAir()) continue;
                return false;
            }
            return true;
        }
    }

    public static class Room
    extends Piece {
        private final List<MutableBoundingBox> connectedRooms = Lists.newLinkedList();

        public Room(int p_i47137_1_, Random p_i47137_2_, int p_i47137_3_, int p_i47137_4_, MineshaftStructure.Type typeIn) {
            super(IStructurePieceType.MSROOM, p_i47137_1_, typeIn);
            this.mineShaftType = typeIn;
            this.boundingBox = new MutableBoundingBox(p_i47137_3_, 50, p_i47137_4_, p_i47137_3_ + 7 + p_i47137_2_.nextInt(6), 54 + p_i47137_2_.nextInt(6), p_i47137_4_ + 7 + p_i47137_2_.nextInt(6));
        }

        public Room(TemplateManager templateManagerIn, CompoundNBT nbt) {
            super(IStructurePieceType.MSROOM, nbt);
            ListNBT listnbt = nbt.getList("Entrances", 11);
            for (int i = 0; i < listnbt.size(); ++i) {
                this.connectedRooms.add(new MutableBoundingBox(listnbt.getIntArray(i)));
            }
        }

        @Override
        public void buildComponent(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            int k;
            int i = this.getComponentType();
            int j = this.boundingBox.getYSize() - 3 - 1;
            if (j <= 0) {
                j = 1;
            }
            for (k = 0; k < this.boundingBox.getXSize() && (k += rand.nextInt(this.boundingBox.getXSize())) + 3 <= this.boundingBox.getXSize(); k += 4) {
                Piece mineshaftpieces$piece = MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX + k, this.boundingBox.minY + rand.nextInt(j) + 1, this.boundingBox.minZ - 1, Direction.NORTH, i);
                if (mineshaftpieces$piece == null) continue;
                MutableBoundingBox mutableboundingbox = mineshaftpieces$piece.getBoundingBox();
                this.connectedRooms.add(new MutableBoundingBox(mutableboundingbox.minX, mutableboundingbox.minY, this.boundingBox.minZ, mutableboundingbox.maxX, mutableboundingbox.maxY, this.boundingBox.minZ + 1));
            }
            for (k = 0; k < this.boundingBox.getXSize() && (k += rand.nextInt(this.boundingBox.getXSize())) + 3 <= this.boundingBox.getXSize(); k += 4) {
                Piece mineshaftpieces$piece1 = MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX + k, this.boundingBox.minY + rand.nextInt(j) + 1, this.boundingBox.maxZ + 1, Direction.SOUTH, i);
                if (mineshaftpieces$piece1 == null) continue;
                MutableBoundingBox mutableboundingbox1 = mineshaftpieces$piece1.getBoundingBox();
                this.connectedRooms.add(new MutableBoundingBox(mutableboundingbox1.minX, mutableboundingbox1.minY, this.boundingBox.maxZ - 1, mutableboundingbox1.maxX, mutableboundingbox1.maxY, this.boundingBox.maxZ));
            }
            for (k = 0; k < this.boundingBox.getZSize() && (k += rand.nextInt(this.boundingBox.getZSize())) + 3 <= this.boundingBox.getZSize(); k += 4) {
                Piece mineshaftpieces$piece2 = MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.minX - 1, this.boundingBox.minY + rand.nextInt(j) + 1, this.boundingBox.minZ + k, Direction.WEST, i);
                if (mineshaftpieces$piece2 == null) continue;
                MutableBoundingBox mutableboundingbox2 = mineshaftpieces$piece2.getBoundingBox();
                this.connectedRooms.add(new MutableBoundingBox(this.boundingBox.minX, mutableboundingbox2.minY, mutableboundingbox2.minZ, this.boundingBox.minX + 1, mutableboundingbox2.maxY, mutableboundingbox2.maxZ));
            }
            for (k = 0; k < this.boundingBox.getZSize() && (k += rand.nextInt(this.boundingBox.getZSize())) + 3 <= this.boundingBox.getZSize(); k += 4) {
                Piece structurepiece = MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.boundingBox.maxX + 1, this.boundingBox.minY + rand.nextInt(j) + 1, this.boundingBox.minZ + k, Direction.EAST, i);
                if (structurepiece == null) continue;
                MutableBoundingBox mutableboundingbox3 = structurepiece.getBoundingBox();
                this.connectedRooms.add(new MutableBoundingBox(this.boundingBox.maxX - 1, mutableboundingbox3.minY, mutableboundingbox3.minZ, this.boundingBox.maxX, mutableboundingbox3.maxY, mutableboundingbox3.maxZ));
            }
        }

        @Override
        public boolean func_230383_a_(ISeedReader p_230383_1_, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, MutableBoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            if (this.isLiquidInStructureBoundingBox(p_230383_1_, p_230383_5_)) {
                return false;
            }
            this.fillWithBlocks(p_230383_1_, p_230383_5_, this.boundingBox.minX, this.boundingBox.minY, this.boundingBox.minZ, this.boundingBox.maxX, this.boundingBox.minY, this.boundingBox.maxZ, Blocks.DIRT.getDefaultState(), CAVE_AIR, true);
            this.fillWithBlocks(p_230383_1_, p_230383_5_, this.boundingBox.minX, this.boundingBox.minY + 1, this.boundingBox.minZ, this.boundingBox.maxX, Math.min(this.boundingBox.minY + 3, this.boundingBox.maxY), this.boundingBox.maxZ, CAVE_AIR, CAVE_AIR, false);
            for (MutableBoundingBox mutableboundingbox : this.connectedRooms) {
                this.fillWithBlocks(p_230383_1_, p_230383_5_, mutableboundingbox.minX, mutableboundingbox.maxY - 2, mutableboundingbox.minZ, mutableboundingbox.maxX, mutableboundingbox.maxY, mutableboundingbox.maxZ, CAVE_AIR, CAVE_AIR, false);
            }
            this.randomlyRareFillWithBlocks(p_230383_1_, p_230383_5_, this.boundingBox.minX, this.boundingBox.minY + 4, this.boundingBox.minZ, this.boundingBox.maxX, this.boundingBox.maxY, this.boundingBox.maxZ, CAVE_AIR, false);
            return true;
        }

        @Override
        public void offset(int x, int y, int z) {
            super.offset(x, y, z);
            for (MutableBoundingBox mutableboundingbox : this.connectedRooms) {
                mutableboundingbox.offset(x, y, z);
            }
        }

        @Override
        protected void readAdditional(CompoundNBT tagCompound) {
            super.readAdditional(tagCompound);
            ListNBT listnbt = new ListNBT();
            for (MutableBoundingBox mutableboundingbox : this.connectedRooms) {
                listnbt.add(mutableboundingbox.toNBTTagIntArray());
            }
            tagCompound.put("Entrances", listnbt);
        }
    }
}

