/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.SimplexNoiseGenerator;

public class PerlinNoiseGenerator
implements INoiseGenerator {
    private final SimplexNoiseGenerator[] noiseLevels;
    private final double field_227462_b_;
    private final double field_227463_c_;

    public PerlinNoiseGenerator(SharedSeedRandom p_i232144_1_, IntStream p_i232144_2_) {
        this(p_i232144_1_, (List)p_i232144_2_.boxed().collect(ImmutableList.toImmutableList()));
    }

    public PerlinNoiseGenerator(SharedSeedRandom p_i232143_1_, List<Integer> p_i232143_2_) {
        this(p_i232143_1_, (IntSortedSet)new IntRBTreeSet(p_i232143_2_));
    }

    private PerlinNoiseGenerator(SharedSeedRandom p_i225881_1_, IntSortedSet p_i225881_2_) {
        int j;
        if (p_i225881_2_.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int i = -p_i225881_2_.firstInt();
        int k = i + (j = p_i225881_2_.lastInt()) + 1;
        if (k < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        SimplexNoiseGenerator simplexnoisegenerator = new SimplexNoiseGenerator(p_i225881_1_);
        int l = j;
        this.noiseLevels = new SimplexNoiseGenerator[k];
        if (j >= 0 && j < k && p_i225881_2_.contains(0)) {
            this.noiseLevels[j] = simplexnoisegenerator;
        }
        for (int i1 = j + 1; i1 < k; ++i1) {
            if (i1 >= 0 && p_i225881_2_.contains(l - i1)) {
                this.noiseLevels[i1] = new SimplexNoiseGenerator(p_i225881_1_);
                continue;
            }
            p_i225881_1_.skip(262);
        }
        if (j > 0) {
            long k1 = (long)(simplexnoisegenerator.func_227464_a_(simplexnoisegenerator.xo, simplexnoisegenerator.yo, simplexnoisegenerator.zo) * 9.223372036854776E18);
            SharedSeedRandom sharedseedrandom = new SharedSeedRandom(k1);
            for (int j1 = l - 1; j1 >= 0; --j1) {
                if (j1 < k && p_i225881_2_.contains(l - j1)) {
                    this.noiseLevels[j1] = new SimplexNoiseGenerator(sharedseedrandom);
                    continue;
                }
                sharedseedrandom.skip(262);
            }
        }
        this.field_227463_c_ = Math.pow(2.0, j);
        this.field_227462_b_ = 1.0 / (Math.pow(2.0, k) - 1.0);
    }

    public double noiseAt(double x, double y, boolean useNoiseOffsets) {
        double d0 = 0.0;
        double d1 = this.field_227463_c_;
        double d2 = this.field_227462_b_;
        for (SimplexNoiseGenerator simplexnoisegenerator : this.noiseLevels) {
            if (simplexnoisegenerator != null) {
                d0 += simplexnoisegenerator.getValue(x * d1 + (useNoiseOffsets ? simplexnoisegenerator.xo : 0.0), y * d1 + (useNoiseOffsets ? simplexnoisegenerator.yo : 0.0)) * d2;
            }
            d1 /= 2.0;
            d2 *= 2.0;
        }
        return d0;
    }

    @Override
    public double noiseAt(double x, double y, double z, double p_215460_7_) {
        return this.noiseAt(x, y, true) * 0.55;
    }
}

