/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.client.audio.BackgroundMusicSelector;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.biome.SoundAdditionsAmbience;

public class BiomeAmbience {
    public static final Codec<BiomeAmbience> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("fog_color").forGetter(ambience -> ambience.fogColor), (App)Codec.INT.fieldOf("water_color").forGetter(ambience -> ambience.waterColor), (App)Codec.INT.fieldOf("water_fog_color").forGetter(ambience -> ambience.waterFogColor), (App)Codec.INT.fieldOf("sky_color").forGetter(ambience -> ambience.skyColor), (App)Codec.INT.optionalFieldOf("foliage_color").forGetter(ambience -> ambience.foliageColor), (App)Codec.INT.optionalFieldOf("grass_color").forGetter(p_244426_0_ -> p_244426_0_.grassColor), (App)GrassColorModifier.CODEC.optionalFieldOf("grass_color_modifier", (Object)GrassColorModifier.NONE).forGetter(ambience -> ambience.grassColorModifier), (App)ParticleEffectAmbience.CODEC.optionalFieldOf("particle").forGetter(ambience -> ambience.particle), (App)SoundEvent.CODEC.optionalFieldOf("ambient_sound").forGetter(ambience -> ambience.ambientSound), (App)MoodSoundAmbience.CODEC.optionalFieldOf("mood_sound").forGetter(ambience -> ambience.moodSound), (App)SoundAdditionsAmbience.CODEC.optionalFieldOf("additions_sound").forGetter(ambience -> ambience.additionsSound), (App)BackgroundMusicSelector.CODEC.optionalFieldOf("music").forGetter(ambience -> ambience.music)).apply((Applicative)builder, BiomeAmbience::new));
    private final int fogColor;
    private final int waterColor;
    private final int waterFogColor;
    private final int skyColor;
    private final Optional<Integer> foliageColor;
    private final Optional<Integer> grassColor;
    private final GrassColorModifier grassColorModifier;
    private final Optional<ParticleEffectAmbience> particle;
    private final Optional<SoundEvent> ambientSound;
    private final Optional<MoodSoundAmbience> moodSound;
    private final Optional<SoundAdditionsAmbience> additionsSound;
    private final Optional<BackgroundMusicSelector> music;

    private BiomeAmbience(int fogColor, int waterColor, int waterFogColor, int skyColor, Optional<Integer> foliageColor, Optional<Integer> grassColor, GrassColorModifier grassColorModifier, Optional<ParticleEffectAmbience> particle, Optional<SoundEvent> ambientSound, Optional<MoodSoundAmbience> moodSound, Optional<SoundAdditionsAmbience> additionsSound, Optional<BackgroundMusicSelector> music) {
        this.fogColor = fogColor;
        this.waterColor = waterColor;
        this.waterFogColor = waterFogColor;
        this.skyColor = skyColor;
        this.foliageColor = foliageColor;
        this.grassColor = grassColor;
        this.grassColorModifier = grassColorModifier;
        this.particle = particle;
        this.ambientSound = ambientSound;
        this.moodSound = moodSound;
        this.additionsSound = additionsSound;
        this.music = music;
    }

    public int getFogColor() {
        return this.fogColor;
    }

    public int getWaterColor() {
        return this.waterColor;
    }

    public int getWaterFogColor() {
        return this.waterFogColor;
    }

    public int getSkyColor() {
        return this.skyColor;
    }

    public Optional<Integer> getFoliageColor() {
        return this.foliageColor;
    }

    public Optional<Integer> getGrassColor() {
        return this.grassColor;
    }

    public GrassColorModifier getGrassColorModifier() {
        return this.grassColorModifier;
    }

    public Optional<ParticleEffectAmbience> getParticle() {
        return this.particle;
    }

    public Optional<SoundEvent> getAmbientSound() {
        return this.ambientSound;
    }

    public Optional<MoodSoundAmbience> getMoodSound() {
        return this.moodSound;
    }

    public Optional<SoundAdditionsAmbience> getAdditionsSound() {
        return this.additionsSound;
    }

    public Optional<BackgroundMusicSelector> getMusic() {
        return this.music;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum GrassColorModifier implements IStringSerializable
    {
        NONE("none"){

            @Override
            public int getModifiedGrassColor(double x, double z, int grassColor) {
                return grassColor;
            }
        }
        ,
        DARK_FOREST("dark_forest"){

            @Override
            public int getModifiedGrassColor(double x, double z, int grassColor) {
                return (grassColor & 0xFEFEFE) + 2634762 >> 1;
            }
        }
        ,
        SWAMP("swamp"){

            @Override
            public int getModifiedGrassColor(double x, double z, int grassColor) {
                double d0 = Biome.INFO_NOISE.noiseAt(x * 0.0225, z * 0.0225, false);
                return d0 < -0.1 ? 5011004 : 6975545;
            }
        };

        private final String name;
        public static final Codec<GrassColorModifier> CODEC;
        private static final Map<String, GrassColorModifier> NAME_TO_MODIFIER_MAP;

        public abstract int getModifiedGrassColor(double var1, double var3, int var5);

        private GrassColorModifier(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getString() {
            return this.name;
        }

        public static GrassColorModifier byName(String name) {
            return NAME_TO_MODIFIER_MAP.get(name);
        }

        static {
            CODEC = IStringSerializable.createEnumCodec(GrassColorModifier::values, GrassColorModifier::byName);
            NAME_TO_MODIFIER_MAP = Arrays.stream(GrassColorModifier.values()).collect(Collectors.toMap(GrassColorModifier::getName, modifier -> modifier));
        }
    }

    public static class Builder {
        private OptionalInt fogColor = OptionalInt.empty();
        private OptionalInt waterColor = OptionalInt.empty();
        private OptionalInt waterFogColor = OptionalInt.empty();
        private OptionalInt skyColor = OptionalInt.empty();
        private Optional<Integer> foliageColor = Optional.empty();
        private Optional<Integer> grassColor = Optional.empty();
        private GrassColorModifier grassColorModifier = GrassColorModifier.NONE;
        private Optional<ParticleEffectAmbience> particle = Optional.empty();
        private Optional<SoundEvent> ambientSound = Optional.empty();
        private Optional<MoodSoundAmbience> moodSound = Optional.empty();
        private Optional<SoundAdditionsAmbience> additionsSound = Optional.empty();
        private Optional<BackgroundMusicSelector> music = Optional.empty();

        public Builder setFogColor(int fogColor) {
            this.fogColor = OptionalInt.of(fogColor);
            return this;
        }

        public Builder setWaterColor(int waterColor) {
            this.waterColor = OptionalInt.of(waterColor);
            return this;
        }

        public Builder setWaterFogColor(int waterFogColor) {
            this.waterFogColor = OptionalInt.of(waterFogColor);
            return this;
        }

        public Builder withSkyColor(int skyColor) {
            this.skyColor = OptionalInt.of(skyColor);
            return this;
        }

        public Builder withFoliageColor(int foliageColor) {
            this.foliageColor = Optional.of(foliageColor);
            return this;
        }

        public Builder withGrassColor(int grassColor) {
            this.grassColor = Optional.of(grassColor);
            return this;
        }

        public Builder withGrassColorModifier(GrassColorModifier grassColorModifier) {
            this.grassColorModifier = grassColorModifier;
            return this;
        }

        public Builder setParticle(ParticleEffectAmbience particle) {
            this.particle = Optional.of(particle);
            return this;
        }

        public Builder setAmbientSound(SoundEvent ambientSound) {
            this.ambientSound = Optional.of(ambientSound);
            return this;
        }

        public Builder setMoodSound(MoodSoundAmbience moodSound) {
            this.moodSound = Optional.of(moodSound);
            return this;
        }

        public Builder setAdditionsSound(SoundAdditionsAmbience additionsSound) {
            this.additionsSound = Optional.of(additionsSound);
            return this;
        }

        public Builder setMusic(BackgroundMusicSelector music) {
            this.music = Optional.of(music);
            return this;
        }

        public BiomeAmbience build() {
            return new BiomeAmbience(this.fogColor.orElseThrow(() -> new IllegalStateException("Missing 'fog' color.")), this.waterColor.orElseThrow(() -> new IllegalStateException("Missing 'water' color.")), this.waterFogColor.orElseThrow(() -> new IllegalStateException("Missing 'water fog' color.")), this.skyColor.orElseThrow(() -> new IllegalStateException("Missing 'sky' color.")), this.foliageColor, this.grassColor, this.grassColorModifier, this.particle, this.ambientSound, this.moodSound, this.additionsSound, this.music);
        }
    }
}

