/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public enum Difficulty {
    PEACEFUL(0, "peaceful"),
    EASY(1, "easy"),
    NORMAL(2, "normal"),
    HARD(3, "hard");

    private static final Difficulty[] ID_MAPPING;
    private final int id;
    private final String translationKey;

    private Difficulty(int difficultyIdIn, String difficultyResourceKeyIn) {
        this.id = difficultyIdIn;
        this.translationKey = difficultyResourceKeyIn;
    }

    public int getId() {
        return this.id;
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent("options.difficulty." + this.translationKey);
    }

    public static Difficulty byId(int id) {
        return ID_MAPPING[id % ID_MAPPING.length];
    }

    @Nullable
    public static Difficulty byName(String nameIn) {
        for (Difficulty difficulty : Difficulty.values()) {
            if (!difficulty.translationKey.equals(nameIn)) continue;
            return difficulty;
        }
        return null;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public Difficulty getNextDifficulty() {
        return ID_MAPPING[(this.id + 1) % ID_MAPPING.length];
    }

    static {
        ID_MAPPING = (Difficulty[])Arrays.stream(Difficulty.values()).sorted(Comparator.comparingInt(Difficulty::getId)).toArray(Difficulty[]::new);
    }
}

