/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.UUIDCodec;
import net.minecraft.util.Util;
import net.minecraft.village.GossipType;

public class GossipManager {
    private final Map<UUID, Gossips> uuid_gossips_mapping = Maps.newHashMap();

    public void tick() {
        Iterator<Gossips> iterator = this.uuid_gossips_mapping.values().iterator();
        while (iterator.hasNext()) {
            Gossips gossipmanager$gossips = iterator.next();
            gossipmanager$gossips.decay();
            if (!gossipmanager$gossips.isGossipTypeMapEmpty()) continue;
            iterator.remove();
        }
    }

    private Stream<GossipEntry> getGossipEntries() {
        return this.uuid_gossips_mapping.entrySet().stream().flatMap(uniqueGossipEntry -> ((Gossips)uniqueGossipEntry.getValue()).unpack((UUID)uniqueGossipEntry.getKey()));
    }

    private Collection<GossipEntry> selectGossipsForTransfer(Random rand, int gossipAmount) {
        List list = this.getGossipEntries().collect(Collectors.toList());
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        int[] aint = new int[list.size()];
        int i = 0;
        for (int j = 0; j < list.size(); ++j) {
            GossipEntry gossipmanager$gossipentry = (GossipEntry)list.get(j);
            aint[j] = (i += Math.abs(gossipmanager$gossipentry.weightedValue())) - 1;
        }
        Set set = Sets.newIdentityHashSet();
        for (int i1 = 0; i1 < gossipAmount; ++i1) {
            int k = rand.nextInt(i);
            int l = Arrays.binarySearch(aint, k);
            set.add((GossipEntry)list.get(l < 0 ? -l - 1 : l));
        }
        return set;
    }

    private Gossips getOrCreate(UUID identifier) {
        return this.uuid_gossips_mapping.computeIfAbsent(identifier, id -> new Gossips());
    }

    public void transferFrom(GossipManager gossip, Random rand, int gossipAmount) {
        Collection<GossipEntry> collection = gossip.selectGossipsForTransfer(rand, gossipAmount);
        collection.forEach(gossipEntry -> {
            int i = gossipEntry.value - gossipEntry.type.decayPerTransfer;
            if (i >= 2) {
                this.getOrCreate((UUID)gossipEntry.target).gossipTypeMap.mergeInt((Object)gossipEntry.type, i, GossipManager::getMax);
            }
        });
    }

    public int getReputation(UUID identifier, Predicate<GossipType> gossip) {
        Gossips gossipmanager$gossips = this.uuid_gossips_mapping.get(identifier);
        return gossipmanager$gossips != null ? gossipmanager$gossips.weightedValue(gossip) : 0;
    }

    public void add(UUID identifier, GossipType gossipType, int gossipValue) {
        Gossips gossipmanager$gossips = this.getOrCreate(identifier);
        gossipmanager$gossips.gossipTypeMap.mergeInt((Object)gossipType, gossipValue, (p_220915_2_, p_220915_3_) -> this.mergeValuesForAddition(gossipType, (int)p_220915_2_, (int)p_220915_3_));
        gossipmanager$gossips.putGossipType(gossipType);
        if (gossipmanager$gossips.isGossipTypeMapEmpty()) {
            this.uuid_gossips_mapping.remove(identifier);
        }
    }

    public <T> Dynamic<T> write(DynamicOps<T> dynamic) {
        return new Dynamic(dynamic, dynamic.createList(this.getGossipEntries().map(gossipEntry -> gossipEntry.write(dynamic)).map(Dynamic::getValue)));
    }

    public void read(Dynamic<?> dynamic) {
        dynamic.asStream().map(GossipEntry::read).flatMap(p_234056_0_ -> Util.streamOptional(p_234056_0_.result())).forEach(gossipEntry -> this.getOrCreate((UUID)gossipEntry.target).gossipTypeMap.put((Object)gossipEntry.type, gossipEntry.value));
    }

    private static int getMax(int value1, int value2) {
        return Math.max(value1, value2);
    }

    private int mergeValuesForAddition(GossipType gossipTypeIn, int existing, int additive) {
        int i = existing + additive;
        return i > gossipTypeIn.max ? Math.max(gossipTypeIn.max, existing) : i;
    }

    static class Gossips {
        private final Object2IntMap<GossipType> gossipTypeMap = new Object2IntOpenHashMap();

        private Gossips() {
        }

        public int weightedValue(Predicate<GossipType> gossipType) {
            return this.gossipTypeMap.object2IntEntrySet().stream().filter(p_220898_1_ -> gossipType.test((GossipType)((Object)((Object)p_220898_1_.getKey())))).mapToInt(p_220894_0_ -> p_220894_0_.getIntValue() * ((GossipType)((Object)((Object)p_220894_0_.getKey()))).weight).sum();
        }

        public Stream<GossipEntry> unpack(UUID identifier) {
            return this.gossipTypeMap.object2IntEntrySet().stream().map(p_220897_1_ -> new GossipEntry(identifier, (GossipType)((Object)((Object)p_220897_1_.getKey())), p_220897_1_.getIntValue()));
        }

        public void decay() {
            ObjectIterator objectiterator = this.gossipTypeMap.object2IntEntrySet().iterator();
            while (objectiterator.hasNext()) {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)objectiterator.next();
                int i = entry.getIntValue() - ((GossipType)((Object)entry.getKey())).decayPerDay;
                if (i < 2) {
                    objectiterator.remove();
                    continue;
                }
                entry.setValue(i);
            }
        }

        public boolean isGossipTypeMapEmpty() {
            return this.gossipTypeMap.isEmpty();
        }

        public void putGossipType(GossipType gossipType) {
            int i = this.gossipTypeMap.getInt((Object)gossipType);
            if (i > gossipType.max) {
                this.gossipTypeMap.put((Object)gossipType, gossipType.max);
            }
            if (i < 2) {
                this.removeGossipType(gossipType);
            }
        }

        public void removeGossipType(GossipType gossipType) {
            this.gossipTypeMap.removeInt((Object)gossipType);
        }
    }

    static class GossipEntry {
        public final UUID target;
        public final GossipType type;
        public final int value;

        public GossipEntry(UUID target, GossipType type, int value) {
            this.target = target;
            this.type = type;
            this.value = value;
        }

        public int weightedValue() {
            return this.value * this.type.weight;
        }

        public String toString() {
            return "GossipEntry{target=" + String.valueOf(this.target) + ", type=" + String.valueOf((Object)this.type) + ", value=" + this.value + "}";
        }

        public <T> Dynamic<T> write(DynamicOps<T> dynamic) {
            return new Dynamic(dynamic, dynamic.createMap((Map)ImmutableMap.of((Object)dynamic.createString("Target"), UUIDCodec.CODEC.encodeStart(dynamic, (Object)this.target).result().orElseThrow(RuntimeException::new), (Object)dynamic.createString("Type"), (Object)dynamic.createString(this.type.id), (Object)dynamic.createString("Value"), (Object)dynamic.createInt(this.value))));
        }

        public static DataResult<GossipEntry> read(Dynamic<?> dynamic) {
            return DataResult.unbox((App)DataResult.instance().group((App)dynamic.get("Target").read(UUIDCodec.CODEC), (App)dynamic.get("Type").asString().map(GossipType::byId), (App)dynamic.get("Value").asNumber().map(Number::intValue)).apply((Applicative)DataResult.instance(), GossipEntry::new));
        }
    }
}

