/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Objects;
import net.minecraft.util.datafix.fixes.EntityRenameHelper;

public class ZombieSplit
extends EntityRenameHelper {
    public ZombieSplit(Schema outputSchema, boolean changesType) {
        super("EntityZombieSplitFix", outputSchema, changesType);
    }

    @Override
    protected Pair<String, Dynamic<?>> getNewNameAndTag(String name, Dynamic<?> tag) {
        if (Objects.equals("Zombie", name)) {
            String s = "Zombie";
            int i = tag.get("ZombieType").asInt(0);
            switch (i) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    s = "ZombieVillager";
                    tag = tag.set("Profession", tag.createInt(i - 1));
                    break;
                }
                case 6: {
                    s = "Husk";
                }
            }
            tag = tag.remove("ZombieType");
            return Pair.of((Object)s, (Object)tag);
        }
        return Pair.of((Object)name, tag);
    }
}

