/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.datafix.fixes.NamedEntityFix;

public class PaintingMotive
extends NamedEntityFix {
    private static final Map<String, String> MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_201153_0_ -> {
        p_201153_0_.put("donkeykong", "donkey_kong");
        p_201153_0_.put("burningskull", "burning_skull");
        p_201153_0_.put("skullandroses", "skull_and_roses");
    });

    public PaintingMotive(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType, "EntityPaintingMotiveFix", TypeReferences.ENTITY, "minecraft:painting");
    }

    public Dynamic<?> fixTag(Dynamic<?> p_209652_1_) {
        Optional optional = p_209652_1_.get("Motive").asString().result();
        if (optional.isPresent()) {
            String s = ((String)optional.get()).toLowerCase(Locale.ROOT);
            return p_209652_1_.set("Motive", p_209652_1_.createString(new ResourceLocation(MAP.getOrDefault(s, s)).toString()));
        }
        return p_209652_1_;
    }

    @Override
    protected Typed<?> fix(Typed<?> p_207419_1_) {
        return p_207419_1_.update(DSL.remainderFinder(), this::fixTag);
    }
}

