/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ObjectiveDisplayName
extends DataFix {
    public ObjectiveDisplayName(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected TypeRewriteRule makeRule() {
        Type type = DSL.named((String)TypeReferences.OBJECTIVE.typeName(), (Type)DSL.remainderType());
        if (!Objects.equals(type, this.getInputSchema().getType(TypeReferences.OBJECTIVE))) {
            throw new IllegalStateException("Objective type is not what was expected.");
        }
        return this.fixTypeEverywhere("ObjectiveDisplayNameFix", type, p_211862_0_ -> p_211863_0_ -> p_211863_0_.mapSecond(p_211861_0_ -> p_211861_0_.update("DisplayName", p_211864_1_ -> (Dynamic)DataFixUtils.orElse((Optional)p_211864_1_.asString().map(p_211865_0_ -> ITextComponent.Serializer.toJson(new StringTextComponent((String)p_211865_0_))).map(arg_0 -> ((Dynamic)p_211861_0_).createString(arg_0)).result(), (Object)p_211864_1_))));
    }
}

