/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.ServerProperties;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.storage.PlayerData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DedicatedPlayerList
extends PlayerList {
    private static final Logger LOGGER = LogManager.getLogger();

    public DedicatedPlayerList(DedicatedServer p_i232600_1_, DynamicRegistries.Impl p_i232600_2_, PlayerData p_i232600_3_) {
        super(p_i232600_1_, p_i232600_2_, p_i232600_3_, p_i232600_1_.getServerProperties().maxPlayers);
        ServerProperties serverproperties = p_i232600_1_.getServerProperties();
        this.setViewDistance(serverproperties.viewDistance);
        super.setWhiteListEnabled(serverproperties.whitelistEnabled.get());
        this.loadPlayerBanList();
        this.savePlayerBanList();
        this.loadIPBanList();
        this.saveIPBanList();
        this.loadOpsList();
        this.readWhiteList();
        this.saveOpsList();
        if (!this.getWhitelistedPlayers().getSaveFile().exists()) {
            this.saveWhiteList();
        }
    }

    @Override
    public void setWhiteListEnabled(boolean whitelistEnabled) {
        super.setWhiteListEnabled(whitelistEnabled);
        this.getServer().func_213223_o(whitelistEnabled);
    }

    @Override
    public void addOp(GameProfile profile) {
        super.addOp(profile);
        this.saveOpsList();
    }

    @Override
    public void removeOp(GameProfile profile) {
        super.removeOp(profile);
        this.saveOpsList();
    }

    @Override
    public void reloadWhitelist() {
        this.readWhiteList();
    }

    private void saveIPBanList() {
        try {
            this.getBannedIPs().writeChanges();
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to save ip banlist: ", (Throwable)ioexception);
        }
    }

    private void savePlayerBanList() {
        try {
            this.getBannedPlayers().writeChanges();
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to save user banlist: ", (Throwable)ioexception);
        }
    }

    private void loadIPBanList() {
        try {
            this.getBannedIPs().readSavedFile();
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to load ip banlist: ", (Throwable)ioexception);
        }
    }

    private void loadPlayerBanList() {
        try {
            this.getBannedPlayers().readSavedFile();
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to load user banlist: ", (Throwable)ioexception);
        }
    }

    private void loadOpsList() {
        try {
            this.getOppedPlayers().readSavedFile();
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to load operators list: ", (Throwable)exception);
        }
    }

    private void saveOpsList() {
        try {
            this.getOppedPlayers().writeChanges();
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to save operators list: ", (Throwable)exception);
        }
    }

    private void readWhiteList() {
        try {
            this.getWhitelistedPlayers().readSavedFile();
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to load white-list: ", (Throwable)exception);
        }
    }

    private void saveWhiteList() {
        try {
            this.getWhitelistedPlayers().writeChanges();
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to save white-list: ", (Throwable)exception);
        }
    }

    @Override
    public boolean canJoin(GameProfile profile) {
        return !this.isWhiteListEnabled() || this.canSendCommands(profile) || this.getWhitelistedPlayers().isWhitelisted(profile);
    }

    @Override
    public DedicatedServer getServer() {
        return (DedicatedServer)super.getServer();
    }

    @Override
    public boolean bypassesPlayerLimit(GameProfile profile) {
        return this.getOppedPlayers().bypassesPlayerLimit(profile);
    }
}

