/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.login;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.login.IServerLoginNetHandler;
import net.minecraft.network.login.client.CCustomPayloadLoginPacket;
import net.minecraft.network.login.client.CEncryptionResponsePacket;
import net.minecraft.network.login.client.CLoginStartPacket;
import net.minecraft.network.login.server.SDisconnectLoginPacket;
import net.minecraft.network.login.server.SEnableCompressionPacket;
import net.minecraft.network.login.server.SEncryptionRequestPacket;
import net.minecraft.network.login.server.SLoginSuccessPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.CryptException;
import net.minecraft.util.CryptManager;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerLoginNetHandler
implements IServerLoginNetHandler {
    private static final AtomicInteger AUTHENTICATOR_THREAD_ID = new AtomicInteger(0);
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RANDOM = new Random();
    private final byte[] verifyToken = new byte[4];
    private final MinecraftServer server;
    public final NetworkManager networkManager;
    private State currentLoginState = State.HELLO;
    private int connectionTimer;
    private GameProfile loginGameProfile;
    private final String serverId = "";
    private SecretKey secretKey;
    private ServerPlayerEntity player;

    public ServerLoginNetHandler(MinecraftServer serverIn, NetworkManager networkManagerIn) {
        this.server = serverIn;
        this.networkManager = networkManagerIn;
        RANDOM.nextBytes(this.verifyToken);
    }

    public void tick() {
        ServerPlayerEntity serverplayerentity;
        if (this.currentLoginState == State.READY_TO_ACCEPT) {
            this.tryAcceptPlayer();
        } else if (this.currentLoginState == State.DELAY_ACCEPT && (serverplayerentity = this.server.getPlayerList().getPlayerByUUID(this.loginGameProfile.getId())) == null) {
            this.currentLoginState = State.READY_TO_ACCEPT;
            this.server.getPlayerList().initializeConnectionToPlayer(this.networkManager, this.player);
            this.player = null;
        }
        if (this.connectionTimer++ == 600) {
            this.disconnect(new TranslationTextComponent("multiplayer.disconnect.slow_login"));
        }
    }

    @Override
    public NetworkManager getNetworkManager() {
        return this.networkManager;
    }

    public void disconnect(ITextComponent reason) {
        try {
            LOGGER.info("Disconnecting {}: {}", (Object)this.getConnectionInfo(), (Object)reason.getString());
            this.networkManager.sendPacket(new SDisconnectLoginPacket(reason));
            this.networkManager.closeChannel(reason);
        }
        catch (Exception exception) {
            LOGGER.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    public void tryAcceptPlayer() {
        ITextComponent itextcomponent;
        if (!this.loginGameProfile.isComplete()) {
            this.loginGameProfile = this.getOfflineProfile(this.loginGameProfile);
        }
        if ((itextcomponent = this.server.getPlayerList().canPlayerLogin(this.networkManager.getRemoteAddress(), this.loginGameProfile)) != null) {
            this.disconnect(itextcomponent);
        } else {
            this.currentLoginState = State.ACCEPTED;
            if (this.server.getNetworkCompressionThreshold() >= 0 && !this.networkManager.isLocalChannel()) {
                this.networkManager.sendPacket(new SEnableCompressionPacket(this.server.getNetworkCompressionThreshold()), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)p_210149_1_ -> this.networkManager.setCompressionThreshold(this.server.getNetworkCompressionThreshold())));
            }
            this.networkManager.sendPacket(new SLoginSuccessPacket(this.loginGameProfile));
            ServerPlayerEntity serverplayerentity = this.server.getPlayerList().getPlayerByUUID(this.loginGameProfile.getId());
            if (serverplayerentity != null) {
                this.currentLoginState = State.DELAY_ACCEPT;
                this.player = this.server.getPlayerList().createPlayerForUser(this.loginGameProfile);
            } else {
                this.server.getPlayerList().initializeConnectionToPlayer(this.networkManager, this.server.getPlayerList().createPlayerForUser(this.loginGameProfile));
            }
        }
    }

    @Override
    public void onDisconnect(ITextComponent reason) {
        LOGGER.info("{} lost connection: {}", (Object)this.getConnectionInfo(), (Object)reason.getString());
    }

    public String getConnectionInfo() {
        return this.loginGameProfile != null ? String.valueOf(this.loginGameProfile) + " (" + String.valueOf(this.networkManager.getRemoteAddress()) + ")" : String.valueOf(this.networkManager.getRemoteAddress());
    }

    @Override
    public void processLoginStart(CLoginStartPacket packetIn) {
        Validate.validState((this.currentLoginState == State.HELLO ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        this.loginGameProfile = packetIn.getProfile();
        if (this.server.isServerInOnlineMode() && !this.networkManager.isLocalChannel()) {
            this.currentLoginState = State.KEY;
            this.networkManager.sendPacket(new SEncryptionRequestPacket("", this.server.getKeyPair().getPublic().getEncoded(), this.verifyToken));
        } else {
            this.currentLoginState = State.READY_TO_ACCEPT;
        }
    }

    @Override
    public void processEncryptionResponse(CEncryptionResponsePacket packetIn) {
        String s;
        Validate.validState((this.currentLoginState == State.KEY ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        PrivateKey privatekey = this.server.getKeyPair().getPrivate();
        try {
            if (!Arrays.equals(this.verifyToken, packetIn.getVerifyToken(privatekey))) {
                throw new IllegalStateException("Protocol error");
            }
            this.secretKey = packetIn.getSecretKey(privatekey);
            Cipher cipher = CryptManager.createNetCipherInstance(2, this.secretKey);
            Cipher cipher1 = CryptManager.createNetCipherInstance(1, this.secretKey);
            s = new BigInteger(CryptManager.getServerIdHash("", this.server.getKeyPair().getPublic(), this.secretKey)).toString(16);
            this.currentLoginState = State.AUTHENTICATING;
            this.networkManager.func_244777_a(cipher, cipher1);
        }
        catch (CryptException cryptexception) {
            throw new IllegalStateException("Protocol error", cryptexception);
        }
        Thread thread = new Thread("User Authenticator #" + AUTHENTICATOR_THREAD_ID.incrementAndGet()){

            @Override
            public void run() {
                GameProfile gameprofile = ServerLoginNetHandler.this.loginGameProfile;
                try {
                    ServerLoginNetHandler.this.loginGameProfile = ServerLoginNetHandler.this.server.getMinecraftSessionService().hasJoinedServer(new GameProfile((UUID)null, gameprofile.getName()), s, this.getAddress());
                    if (ServerLoginNetHandler.this.loginGameProfile != null) {
                        LOGGER.info("UUID of player {} is {}", (Object)ServerLoginNetHandler.this.loginGameProfile.getName(), (Object)ServerLoginNetHandler.this.loginGameProfile.getId());
                        ServerLoginNetHandler.this.currentLoginState = State.READY_TO_ACCEPT;
                    } else if (ServerLoginNetHandler.this.server.isSinglePlayer()) {
                        LOGGER.warn("Failed to verify username but will let them in anyway!");
                        ServerLoginNetHandler.this.loginGameProfile = ServerLoginNetHandler.this.getOfflineProfile(gameprofile);
                        ServerLoginNetHandler.this.currentLoginState = State.READY_TO_ACCEPT;
                    } else {
                        ServerLoginNetHandler.this.disconnect(new TranslationTextComponent("multiplayer.disconnect.unverified_username"));
                        LOGGER.error("Username '{}' tried to join with an invalid session", (Object)gameprofile.getName());
                    }
                }
                catch (AuthenticationUnavailableException authenticationunavailableexception) {
                    if (ServerLoginNetHandler.this.server.isSinglePlayer()) {
                        LOGGER.warn("Authentication servers are down but will let them in anyway!");
                        ServerLoginNetHandler.this.loginGameProfile = ServerLoginNetHandler.this.getOfflineProfile(gameprofile);
                        ServerLoginNetHandler.this.currentLoginState = State.READY_TO_ACCEPT;
                    }
                    ServerLoginNetHandler.this.disconnect(new TranslationTextComponent("multiplayer.disconnect.authservers_down"));
                    LOGGER.error("Couldn't verify username because servers are unavailable");
                }
            }

            @Nullable
            private InetAddress getAddress() {
                SocketAddress socketaddress = ServerLoginNetHandler.this.networkManager.getRemoteAddress();
                return ServerLoginNetHandler.this.server.getPreventProxyConnections() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
            }
        };
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        thread.start();
    }

    @Override
    public void processCustomPayloadLogin(CCustomPayloadLoginPacket p_209526_1_) {
        this.disconnect(new TranslationTextComponent("multiplayer.disconnect.unexpected_query_response"));
    }

    protected GameProfile getOfflineProfile(GameProfile original) {
        UUID uuid = PlayerEntity.getOfflineUUID(original.getName());
        return new GameProfile(uuid, original.getName());
    }

    static enum State {
        HELLO,
        KEY,
        AUTHENTICATING,
        NEGOTIATING,
        READY_TO_ACCEPT,
        DELAY_ACCEPT,
        ACCEPTED;

    }
}

