/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.util.INameable;
import net.minecraft.util.JSONUtils;

public class CopyName
extends LootFunction {
    private final Source source;

    private CopyName(ILootCondition[] conditionsIn, Source sourceIn) {
        super(conditionsIn);
        this.source = sourceIn;
    }

    @Override
    public LootFunctionType getFunctionType() {
        return LootFunctionManager.COPY_NAME;
    }

    @Override
    public Set<LootParameter<?>> getRequiredParameters() {
        return ImmutableSet.of(this.source.parameter);
    }

    @Override
    public ItemStack doApply(ItemStack stack, LootContext context) {
        INameable inameable;
        Object object = context.get(this.source.parameter);
        if (object instanceof INameable && (inameable = (INameable)object).hasCustomName()) {
            stack.setDisplayName(inameable.getDisplayName());
        }
        return stack;
    }

    public static LootFunction.Builder<?> builder(Source sourceIn) {
        return CopyName.builder((ILootCondition[] p_215891_1_) -> new CopyName((ILootCondition[])p_215891_1_, sourceIn));
    }

    public static enum Source {
        THIS("this", LootParameters.THIS_ENTITY),
        KILLER("killer", LootParameters.KILLER_ENTITY),
        KILLER_PLAYER("killer_player", LootParameters.LAST_DAMAGE_PLAYER),
        BLOCK_ENTITY("block_entity", LootParameters.BLOCK_ENTITY);

        public final String name;
        public final LootParameter<?> parameter;

        private Source(String nameIn, LootParameter<?> parameterIn) {
            this.name = nameIn;
            this.parameter = parameterIn;
        }

        public static Source byName(String nameIn) {
            for (Source copyname$source : Source.values()) {
                if (!copyname$source.name.equals(nameIn)) continue;
                return copyname$source;
            }
            throw new IllegalArgumentException("Invalid name source " + nameIn);
        }
    }

    public static class Serializer
    extends LootFunction.Serializer<CopyName> {
        @Override
        public void serialize(JsonObject p_230424_1_, CopyName p_230424_2_, JsonSerializationContext p_230424_3_) {
            super.serialize(p_230424_1_, p_230424_2_, p_230424_3_);
            p_230424_1_.addProperty("source", p_230424_2_.source.name);
        }

        @Override
        public CopyName deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            Source copyname$source = Source.byName(JSONUtils.getString(object, "source"));
            return new CopyName(conditionsIn, copyname$source);
        }
    }
}

