/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LecternBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.WritableBookItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class WrittenBookItem
extends Item {
    public WrittenBookItem(Item.Properties builder) {
        super(builder);
    }

    public static boolean validBookTagContents(@Nullable CompoundNBT nbt) {
        if (!WritableBookItem.isNBTValid(nbt)) {
            return false;
        }
        if (!nbt.contains("title", 8)) {
            return false;
        }
        String s = nbt.getString("title");
        return s.length() > 32 ? false : nbt.contains("author", 8);
    }

    public static int getGeneration(ItemStack book) {
        return book.getTag().getInt("generation");
    }

    public static int getPageCount(ItemStack stack) {
        CompoundNBT compoundnbt = stack.getTag();
        return compoundnbt != null ? compoundnbt.getList("pages", 8).size() : 0;
    }

    @Override
    public ITextComponent getDisplayName(ItemStack stack) {
        CompoundNBT compoundnbt;
        String s;
        if (stack.hasTag() && !StringUtils.isNullOrEmpty(s = (compoundnbt = stack.getTag()).getString("title"))) {
            return new StringTextComponent(s);
        }
        return super.getDisplayName(stack);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.hasTag()) {
            CompoundNBT compoundnbt = stack.getTag();
            String s = compoundnbt.getString("author");
            if (!StringUtils.isNullOrEmpty(s)) {
                tooltip.add(new TranslationTextComponent("book.byAuthor", s).mergeStyle(TextFormatting.GRAY));
            }
            tooltip.add(new TranslationTextComponent("book.generation." + compoundnbt.getInt("generation")).mergeStyle(TextFormatting.GRAY));
        }
    }

    @Override
    public ActionResultType onItemUse(ItemUseContext context) {
        BlockPos blockpos;
        World world = context.getWorld();
        BlockState blockstate = world.getBlockState(blockpos = context.getPos());
        if (blockstate.isIn(Blocks.LECTERN)) {
            return LecternBlock.tryPlaceBook(world, blockpos, blockstate, context.getItem()) ? ActionResultType.func_233537_a_(world.isRemote) : ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.getHeldItem(handIn);
        playerIn.openBook(itemstack, handIn);
        playerIn.addStat(Stats.ITEM_USED.get(this));
        return ActionResult.func_233538_a_(itemstack, worldIn.isRemote());
    }

    public static boolean resolveContents(ItemStack stack, @Nullable CommandSource resolvingSource, @Nullable PlayerEntity resolvingPlayer) {
        CompoundNBT compoundnbt = stack.getTag();
        if (compoundnbt != null && !compoundnbt.getBoolean("resolved")) {
            compoundnbt.putBoolean("resolved", true);
            if (!WrittenBookItem.validBookTagContents(compoundnbt)) {
                return false;
            }
            ListNBT listnbt = compoundnbt.getList("pages", 8);
            for (int i = 0; i < listnbt.size(); ++i) {
                IFormattableTextComponent itextcomponent;
                String s = listnbt.getString(i);
                try {
                    itextcomponent = ITextComponent.Serializer.getComponentFromJsonLenient(s);
                    itextcomponent = TextComponentUtils.func_240645_a_(resolvingSource, itextcomponent, resolvingPlayer, 0);
                }
                catch (Exception exception) {
                    itextcomponent = new StringTextComponent(s);
                }
                listnbt.set(i, StringNBT.valueOf(ITextComponent.Serializer.toJson(itextcomponent)));
            }
            compoundnbt.put("pages", listnbt);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasEffect(ItemStack stack) {
        return true;
    }
}

