/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.merchant.villager;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;

public class VillagerTrades {
    public static final Map<VillagerProfession, Int2ObjectMap<ITrade[]>> VILLAGER_DEFAULT_TRADES = Util.make(Maps.newHashMap(), p_221237_0_ -> {
        p_221237_0_.put(VillagerProfession.FARMER, VillagerTrades.gatAsIntMap((ImmutableMap<Integer, ITrade[]>)ImmutableMap.of((Object)1, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.WHEAT, 20, 16, 2), new EmeraldForItemsTrade(Items.POTATO, 26, 16, 2), new EmeraldForItemsTrade(Items.CARROT, 22, 16, 2), new EmeraldForItemsTrade(Items.BEETROOT, 15, 16, 2), new ItemsForEmeraldsTrade(Items.BREAD, 1, 6, 16, 1)}, (Object)2, (Object)new ITrade[]{new EmeraldForItemsTrade(Blocks.PUMPKIN, 6, 12, 10), new ItemsForEmeraldsTrade(Items.PUMPKIN_PIE, 1, 4, 5), new ItemsForEmeraldsTrade(Items.APPLE, 1, 4, 16, 5)}, (Object)3, (Object)new ITrade[]{new ItemsForEmeraldsTrade(Items.COOKIE, 3, 18, 10), new EmeraldForItemsTrade(Blocks.MELON, 4, 12, 20)}, (Object)4, (Object)new ITrade[]{new ItemsForEmeraldsTrade(Blocks.CAKE, 1, 1, 12, 15), new SuspiciousStewForEmeraldTrade(Effects.NIGHT_VISION, 100, 15), new SuspiciousStewForEmeraldTrade(Effects.JUMP_BOOST, 160, 15), new SuspiciousStewForEmeraldTrade(Effects.WEAKNESS, 140, 15), new SuspiciousStewForEmeraldTrade(Effects.BLINDNESS, 120, 15), new SuspiciousStewForEmeraldTrade(Effects.POISON, 280, 15), new SuspiciousStewForEmeraldTrade(Effects.SATURATION, 7, 15)}, (Object)5, (Object)new ITrade[]{new ItemsForEmeraldsTrade(Items.GOLDEN_CARROT, 3, 3, 30), new ItemsForEmeraldsTrade(Items.GLISTERING_MELON_SLICE, 4, 3, 30)})));
        p_221237_0_.put(VillagerProfession.FISHERMAN, VillagerTrades.gatAsIntMap((ImmutableMap<Integer, ITrade[]>)ImmutableMap.of((Object)1, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.STRING, 20, 16, 2), new EmeraldForItemsTrade(Items.COAL, 10, 16, 2), new ItemsForEmeraldsAndItemsTrade(Items.COD, 6, Items.COOKED_COD, 6, 16, 1), new ItemsForEmeraldsTrade(Items.COD_BUCKET, 3, 1, 16, 1)}, (Object)2, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.COD, 15, 16, 10), new ItemsForEmeraldsAndItemsTrade(Items.SALMON, 6, Items.COOKED_SALMON, 6, 16, 5), new ItemsForEmeraldsTrade(Items.CAMPFIRE, 2, 1, 5)}, (Object)3, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.SALMON, 13, 16, 20), new EnchantedItemForEmeraldsTrade(Items.FISHING_ROD, 3, 3, 10, 0.2f)}, (Object)4, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.TROPICAL_FISH, 6, 12, 30)}, (Object)5, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.PUFFERFISH, 4, 12, 30), new EmeraldForVillageTypeItemTrade(1, 12, 30, (Map<VillagerType, Item>)ImmutableMap.builder().put((Object)VillagerType.PLAINS, (Object)Items.OAK_BOAT).put((Object)VillagerType.TAIGA, (Object)Items.SPRUCE_BOAT).put((Object)VillagerType.SNOW, (Object)Items.SPRUCE_BOAT).put((Object)VillagerType.DESERT, (Object)Items.JUNGLE_BOAT).put((Object)VillagerType.JUNGLE, (Object)Items.JUNGLE_BOAT).put((Object)VillagerType.SAVANNA, (Object)Items.ACACIA_BOAT).put((Object)VillagerType.SWAMP, (Object)Items.DARK_OAK_BOAT).build())})));
        p_221237_0_.put(VillagerProfession.SHEPHERD, VillagerTrades.gatAsIntMap((ImmutableMap<Integer, ITrade[]>)ImmutableMap.of((Object)1, (Object)new ITrade[]{new EmeraldForItemsTrade(Blocks.WHITE_WOOL, 18, 16, 2), new EmeraldForItemsTrade(Blocks.BROWN_WOOL, 18, 16, 2), new EmeraldForItemsTrade(Blocks.BLACK_WOOL, 18, 16, 2), new EmeraldForItemsTrade(Blocks.GRAY_WOOL, 18, 16, 2), new ItemsForEmeraldsTrade(Items.SHEARS, 2, 1, 1)}, (Object)2, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.WHITE_DYE, 12, 16, 10), new EmeraldForItemsTrade(Items.GRAY_DYE, 12, 16, 10), new EmeraldForItemsTrade(Items.BLACK_DYE, 12, 16, 10), new EmeraldForItemsTrade(Items.LIGHT_BLUE_DYE, 12, 16, 10), new EmeraldForItemsTrade(Items.LIME_DYE, 12, 16, 10), new ItemsForEmeraldsTrade(Blocks.WHITE_WOOL, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.ORANGE_WOOL, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.MAGENTA_WOOL, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.LIGHT_BLUE_WOOL, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.YELLOW_WOOL, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.LIME_WOOL, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.PINK_WOOL, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.GRAY_WOOL, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.LIGHT_GRAY_WOOL, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.CYAN_WOOL, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.PURPLE_WOOL, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.BLUE_WOOL, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.BROWN_WOOL, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.GREEN_WOOL, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.RED_WOOL, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.BLACK_WOOL, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.WHITE_CARPET, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.ORANGE_CARPET, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.MAGENTA_CARPET, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.LIGHT_BLUE_CARPET, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.YELLOW_CARPET, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.LIME_CARPET, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.PINK_CARPET, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.GRAY_CARPET, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.LIGHT_GRAY_CARPET, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.CYAN_CARPET, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.PURPLE_CARPET, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.BLUE_CARPET, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.BROWN_CARPET, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.GREEN_CARPET, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.RED_CARPET, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.BLACK_CARPET, 1, 4, 16, 5)}, (Object)3, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.YELLOW_DYE, 12, 16, 20), new EmeraldForItemsTrade(Items.LIGHT_GRAY_DYE, 12, 16, 20), new EmeraldForItemsTrade(Items.ORANGE_DYE, 12, 16, 20), new EmeraldForItemsTrade(Items.RED_DYE, 12, 16, 20), new EmeraldForItemsTrade(Items.PINK_DYE, 12, 16, 20), new ItemsForEmeraldsTrade(Blocks.WHITE_BED, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.YELLOW_BED, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.RED_BED, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.BLACK_BED, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.BLUE_BED, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.BROWN_BED, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.CYAN_BED, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.GRAY_BED, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.GREEN_BED, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.LIGHT_BLUE_BED, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.LIGHT_GRAY_BED, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.LIME_BED, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.MAGENTA_BED, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.ORANGE_BED, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.PINK_BED, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.PURPLE_BED, 3, 1, 12, 10)}, (Object)4, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.BROWN_DYE, 12, 16, 30), new EmeraldForItemsTrade(Items.PURPLE_DYE, 12, 16, 30), new EmeraldForItemsTrade(Items.BLUE_DYE, 12, 16, 30), new EmeraldForItemsTrade(Items.GREEN_DYE, 12, 16, 30), new EmeraldForItemsTrade(Items.MAGENTA_DYE, 12, 16, 30), new EmeraldForItemsTrade(Items.CYAN_DYE, 12, 16, 30), new ItemsForEmeraldsTrade(Items.WHITE_BANNER, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.BLUE_BANNER, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.LIGHT_BLUE_BANNER, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.RED_BANNER, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.PINK_BANNER, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.GREEN_BANNER, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.LIME_BANNER, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.GRAY_BANNER, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.BLACK_BANNER, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.PURPLE_BANNER, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.MAGENTA_BANNER, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.CYAN_BANNER, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.BROWN_BANNER, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.YELLOW_BANNER, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.ORANGE_BANNER, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.LIGHT_GRAY_BANNER, 3, 1, 12, 15)}, (Object)5, (Object)new ITrade[]{new ItemsForEmeraldsTrade(Items.PAINTING, 2, 3, 30)})));
        p_221237_0_.put(VillagerProfession.FLETCHER, VillagerTrades.gatAsIntMap((ImmutableMap<Integer, ITrade[]>)ImmutableMap.of((Object)1, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.STICK, 32, 16, 2), new ItemsForEmeraldsTrade(Items.ARROW, 1, 16, 1), new ItemsForEmeraldsAndItemsTrade(Blocks.GRAVEL, 10, Items.FLINT, 10, 12, 1)}, (Object)2, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.FLINT, 26, 12, 10), new ItemsForEmeraldsTrade(Items.BOW, 2, 1, 5)}, (Object)3, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.STRING, 14, 16, 20), new ItemsForEmeraldsTrade(Items.CROSSBOW, 3, 1, 10)}, (Object)4, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.FEATHER, 24, 16, 30), new EnchantedItemForEmeraldsTrade(Items.BOW, 2, 3, 15)}, (Object)5, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.TRIPWIRE_HOOK, 8, 12, 30), new EnchantedItemForEmeraldsTrade(Items.CROSSBOW, 3, 3, 15), new ItemWithPotionForEmeraldsAndItemsTrade(Items.ARROW, 5, Items.TIPPED_ARROW, 5, 2, 12, 30)})));
        p_221237_0_.put(VillagerProfession.LIBRARIAN, VillagerTrades.gatAsIntMap((ImmutableMap<Integer, ITrade[]>)ImmutableMap.builder().put((Object)1, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.PAPER, 24, 16, 2), new EnchantedBookForEmeraldsTrade(1), new ItemsForEmeraldsTrade(Blocks.BOOKSHELF, 9, 1, 12, 1)}).put((Object)2, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.BOOK, 4, 12, 10), new EnchantedBookForEmeraldsTrade(5), new ItemsForEmeraldsTrade(Items.LANTERN, 1, 1, 5)}).put((Object)3, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.INK_SAC, 5, 12, 20), new EnchantedBookForEmeraldsTrade(10), new ItemsForEmeraldsTrade(Items.GLASS, 1, 4, 10)}).put((Object)4, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.WRITABLE_BOOK, 2, 12, 30), new EnchantedBookForEmeraldsTrade(15), new ItemsForEmeraldsTrade(Items.CLOCK, 5, 1, 15), new ItemsForEmeraldsTrade(Items.COMPASS, 4, 1, 15)}).put((Object)5, (Object)new ITrade[]{new ItemsForEmeraldsTrade(Items.NAME_TAG, 20, 1, 30)}).build()));
        p_221237_0_.put(VillagerProfession.CARTOGRAPHER, VillagerTrades.gatAsIntMap((ImmutableMap<Integer, ITrade[]>)ImmutableMap.of((Object)1, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.PAPER, 24, 16, 2), new ItemsForEmeraldsTrade(Items.MAP, 7, 1, 1)}, (Object)2, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.GLASS_PANE, 11, 16, 10), new EmeraldForMapTrade(13, Structure.field_236376_l_, MapDecoration.Type.MONUMENT, 12, 5)}, (Object)3, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.COMPASS, 1, 12, 20), new EmeraldForMapTrade(14, Structure.field_236368_d_, MapDecoration.Type.MANSION, 12, 10)}, (Object)4, (Object)new ITrade[]{new ItemsForEmeraldsTrade(Items.ITEM_FRAME, 7, 1, 15), new ItemsForEmeraldsTrade(Items.WHITE_BANNER, 3, 1, 15), new ItemsForEmeraldsTrade(Items.BLUE_BANNER, 3, 1, 15), new ItemsForEmeraldsTrade(Items.LIGHT_BLUE_BANNER, 3, 1, 15), new ItemsForEmeraldsTrade(Items.RED_BANNER, 3, 1, 15), new ItemsForEmeraldsTrade(Items.PINK_BANNER, 3, 1, 15), new ItemsForEmeraldsTrade(Items.GREEN_BANNER, 3, 1, 15), new ItemsForEmeraldsTrade(Items.LIME_BANNER, 3, 1, 15), new ItemsForEmeraldsTrade(Items.GRAY_BANNER, 3, 1, 15), new ItemsForEmeraldsTrade(Items.BLACK_BANNER, 3, 1, 15), new ItemsForEmeraldsTrade(Items.PURPLE_BANNER, 3, 1, 15), new ItemsForEmeraldsTrade(Items.MAGENTA_BANNER, 3, 1, 15), new ItemsForEmeraldsTrade(Items.CYAN_BANNER, 3, 1, 15), new ItemsForEmeraldsTrade(Items.BROWN_BANNER, 3, 1, 15), new ItemsForEmeraldsTrade(Items.YELLOW_BANNER, 3, 1, 15), new ItemsForEmeraldsTrade(Items.ORANGE_BANNER, 3, 1, 15), new ItemsForEmeraldsTrade(Items.LIGHT_GRAY_BANNER, 3, 1, 15)}, (Object)5, (Object)new ITrade[]{new ItemsForEmeraldsTrade(Items.GLOBE_BANNER_PATTERN, 8, 1, 30)})));
        p_221237_0_.put(VillagerProfession.CLERIC, VillagerTrades.gatAsIntMap((ImmutableMap<Integer, ITrade[]>)ImmutableMap.of((Object)1, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.ROTTEN_FLESH, 32, 16, 2), new ItemsForEmeraldsTrade(Items.REDSTONE, 1, 2, 1)}, (Object)2, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.GOLD_INGOT, 3, 12, 10), new ItemsForEmeraldsTrade(Items.LAPIS_LAZULI, 1, 1, 5)}, (Object)3, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.RABBIT_FOOT, 2, 12, 20), new ItemsForEmeraldsTrade(Blocks.GLOWSTONE, 4, 1, 12, 10)}, (Object)4, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.SCUTE, 4, 12, 30), new EmeraldForItemsTrade(Items.GLASS_BOTTLE, 9, 12, 30), new ItemsForEmeraldsTrade(Items.ENDER_PEARL, 5, 1, 15)}, (Object)5, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.NETHER_WART, 22, 12, 30), new ItemsForEmeraldsTrade(Items.EXPERIENCE_BOTTLE, 3, 1, 30)})));
        p_221237_0_.put(VillagerProfession.ARMORER, VillagerTrades.gatAsIntMap((ImmutableMap<Integer, ITrade[]>)ImmutableMap.of((Object)1, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.COAL, 15, 16, 2), new ItemsForEmeraldsTrade(new ItemStack(Items.IRON_LEGGINGS), 7, 1, 12, 1, 0.2f), new ItemsForEmeraldsTrade(new ItemStack(Items.IRON_BOOTS), 4, 1, 12, 1, 0.2f), new ItemsForEmeraldsTrade(new ItemStack(Items.IRON_HELMET), 5, 1, 12, 1, 0.2f), new ItemsForEmeraldsTrade(new ItemStack(Items.IRON_CHESTPLATE), 9, 1, 12, 1, 0.2f)}, (Object)2, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.IRON_INGOT, 4, 12, 10), new ItemsForEmeraldsTrade(new ItemStack(Items.BELL), 36, 1, 12, 5, 0.2f), new ItemsForEmeraldsTrade(new ItemStack(Items.CHAINMAIL_BOOTS), 1, 1, 12, 5, 0.2f), new ItemsForEmeraldsTrade(new ItemStack(Items.CHAINMAIL_LEGGINGS), 3, 1, 12, 5, 0.2f)}, (Object)3, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.LAVA_BUCKET, 1, 12, 20), new EmeraldForItemsTrade(Items.DIAMOND, 1, 12, 20), new ItemsForEmeraldsTrade(new ItemStack(Items.CHAINMAIL_HELMET), 1, 1, 12, 10, 0.2f), new ItemsForEmeraldsTrade(new ItemStack(Items.CHAINMAIL_CHESTPLATE), 4, 1, 12, 10, 0.2f), new ItemsForEmeraldsTrade(new ItemStack(Items.SHIELD), 5, 1, 12, 10, 0.2f)}, (Object)4, (Object)new ITrade[]{new EnchantedItemForEmeraldsTrade(Items.DIAMOND_LEGGINGS, 14, 3, 15, 0.2f), new EnchantedItemForEmeraldsTrade(Items.DIAMOND_BOOTS, 8, 3, 15, 0.2f)}, (Object)5, (Object)new ITrade[]{new EnchantedItemForEmeraldsTrade(Items.DIAMOND_HELMET, 8, 3, 30, 0.2f), new EnchantedItemForEmeraldsTrade(Items.DIAMOND_CHESTPLATE, 16, 3, 30, 0.2f)})));
        p_221237_0_.put(VillagerProfession.WEAPONSMITH, VillagerTrades.gatAsIntMap((ImmutableMap<Integer, ITrade[]>)ImmutableMap.of((Object)1, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.COAL, 15, 16, 2), new ItemsForEmeraldsTrade(new ItemStack(Items.IRON_AXE), 3, 1, 12, 1, 0.2f), new EnchantedItemForEmeraldsTrade(Items.IRON_SWORD, 2, 3, 1)}, (Object)2, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.IRON_INGOT, 4, 12, 10), new ItemsForEmeraldsTrade(new ItemStack(Items.BELL), 36, 1, 12, 5, 0.2f)}, (Object)3, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.FLINT, 24, 12, 20)}, (Object)4, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.DIAMOND, 1, 12, 30), new EnchantedItemForEmeraldsTrade(Items.DIAMOND_AXE, 12, 3, 15, 0.2f)}, (Object)5, (Object)new ITrade[]{new EnchantedItemForEmeraldsTrade(Items.DIAMOND_SWORD, 8, 3, 30, 0.2f)})));
        p_221237_0_.put(VillagerProfession.TOOLSMITH, VillagerTrades.gatAsIntMap((ImmutableMap<Integer, ITrade[]>)ImmutableMap.of((Object)1, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.COAL, 15, 16, 2), new ItemsForEmeraldsTrade(new ItemStack(Items.STONE_AXE), 1, 1, 12, 1, 0.2f), new ItemsForEmeraldsTrade(new ItemStack(Items.STONE_SHOVEL), 1, 1, 12, 1, 0.2f), new ItemsForEmeraldsTrade(new ItemStack(Items.STONE_PICKAXE), 1, 1, 12, 1, 0.2f), new ItemsForEmeraldsTrade(new ItemStack(Items.STONE_HOE), 1, 1, 12, 1, 0.2f)}, (Object)2, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.IRON_INGOT, 4, 12, 10), new ItemsForEmeraldsTrade(new ItemStack(Items.BELL), 36, 1, 12, 5, 0.2f)}, (Object)3, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.FLINT, 30, 12, 20), new EnchantedItemForEmeraldsTrade(Items.IRON_AXE, 1, 3, 10, 0.2f), new EnchantedItemForEmeraldsTrade(Items.IRON_SHOVEL, 2, 3, 10, 0.2f), new EnchantedItemForEmeraldsTrade(Items.IRON_PICKAXE, 3, 3, 10, 0.2f), new ItemsForEmeraldsTrade(new ItemStack(Items.DIAMOND_HOE), 4, 1, 3, 10, 0.2f)}, (Object)4, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.DIAMOND, 1, 12, 30), new EnchantedItemForEmeraldsTrade(Items.DIAMOND_AXE, 12, 3, 15, 0.2f), new EnchantedItemForEmeraldsTrade(Items.DIAMOND_SHOVEL, 5, 3, 15, 0.2f)}, (Object)5, (Object)new ITrade[]{new EnchantedItemForEmeraldsTrade(Items.DIAMOND_PICKAXE, 13, 3, 30, 0.2f)})));
        p_221237_0_.put(VillagerProfession.BUTCHER, VillagerTrades.gatAsIntMap((ImmutableMap<Integer, ITrade[]>)ImmutableMap.of((Object)1, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.CHICKEN, 14, 16, 2), new EmeraldForItemsTrade(Items.PORKCHOP, 7, 16, 2), new EmeraldForItemsTrade(Items.RABBIT, 4, 16, 2), new ItemsForEmeraldsTrade(Items.RABBIT_STEW, 1, 1, 1)}, (Object)2, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.COAL, 15, 16, 2), new ItemsForEmeraldsTrade(Items.COOKED_PORKCHOP, 1, 5, 16, 5), new ItemsForEmeraldsTrade(Items.COOKED_CHICKEN, 1, 8, 16, 5)}, (Object)3, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.MUTTON, 7, 16, 20), new EmeraldForItemsTrade(Items.BEEF, 10, 16, 20)}, (Object)4, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.DRIED_KELP_BLOCK, 10, 12, 30)}, (Object)5, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.SWEET_BERRIES, 10, 12, 30)})));
        p_221237_0_.put(VillagerProfession.LEATHERWORKER, VillagerTrades.gatAsIntMap((ImmutableMap<Integer, ITrade[]>)ImmutableMap.of((Object)1, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.LEATHER, 6, 16, 2), new DyedArmorForEmeraldsTrade(Items.LEATHER_LEGGINGS, 3), new DyedArmorForEmeraldsTrade(Items.LEATHER_CHESTPLATE, 7)}, (Object)2, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.FLINT, 26, 12, 10), new DyedArmorForEmeraldsTrade(Items.LEATHER_HELMET, 5, 12, 5), new DyedArmorForEmeraldsTrade(Items.LEATHER_BOOTS, 4, 12, 5)}, (Object)3, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.RABBIT_HIDE, 9, 12, 20), new DyedArmorForEmeraldsTrade(Items.LEATHER_CHESTPLATE, 7)}, (Object)4, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.SCUTE, 4, 12, 30), new DyedArmorForEmeraldsTrade(Items.LEATHER_HORSE_ARMOR, 6, 12, 15)}, (Object)5, (Object)new ITrade[]{new ItemsForEmeraldsTrade(new ItemStack(Items.SADDLE), 6, 1, 12, 30, 0.2f), new DyedArmorForEmeraldsTrade(Items.LEATHER_HELMET, 5, 12, 30)})));
        p_221237_0_.put(VillagerProfession.MASON, VillagerTrades.gatAsIntMap((ImmutableMap<Integer, ITrade[]>)ImmutableMap.of((Object)1, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.CLAY_BALL, 10, 16, 2), new ItemsForEmeraldsTrade(Items.BRICK, 1, 10, 16, 1)}, (Object)2, (Object)new ITrade[]{new EmeraldForItemsTrade(Blocks.STONE, 20, 16, 10), new ItemsForEmeraldsTrade(Blocks.CHISELED_STONE_BRICKS, 1, 4, 16, 5)}, (Object)3, (Object)new ITrade[]{new EmeraldForItemsTrade(Blocks.GRANITE, 16, 16, 20), new EmeraldForItemsTrade(Blocks.ANDESITE, 16, 16, 20), new EmeraldForItemsTrade(Blocks.DIORITE, 16, 16, 20), new ItemsForEmeraldsTrade(Blocks.POLISHED_ANDESITE, 1, 4, 16, 10), new ItemsForEmeraldsTrade(Blocks.POLISHED_DIORITE, 1, 4, 16, 10), new ItemsForEmeraldsTrade(Blocks.POLISHED_GRANITE, 1, 4, 16, 10)}, (Object)4, (Object)new ITrade[]{new EmeraldForItemsTrade(Items.QUARTZ, 12, 12, 30), new ItemsForEmeraldsTrade(Blocks.ORANGE_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.WHITE_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.BLUE_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.LIGHT_BLUE_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.GRAY_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.LIGHT_GRAY_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.BLACK_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.RED_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.PINK_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.MAGENTA_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.LIME_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.GREEN_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.CYAN_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.PURPLE_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.YELLOW_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.BROWN_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.ORANGE_GLAZED_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.WHITE_GLAZED_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.BLUE_GLAZED_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.LIGHT_BLUE_GLAZED_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.GRAY_GLAZED_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.LIGHT_GRAY_GLAZED_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.BLACK_GLAZED_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.RED_GLAZED_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.PINK_GLAZED_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.MAGENTA_GLAZED_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.LIME_GLAZED_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.GREEN_GLAZED_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.CYAN_GLAZED_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.PURPLE_GLAZED_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.YELLOW_GLAZED_TERRACOTTA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.BROWN_GLAZED_TERRACOTTA, 1, 1, 12, 15)}, (Object)5, (Object)new ITrade[]{new ItemsForEmeraldsTrade(Blocks.QUARTZ_PILLAR, 1, 1, 12, 30), new ItemsForEmeraldsTrade(Blocks.QUARTZ_BLOCK, 1, 1, 12, 30)})));
    });
    public static final Int2ObjectMap<ITrade[]> field_221240_b = VillagerTrades.gatAsIntMap((ImmutableMap<Integer, ITrade[]>)ImmutableMap.of((Object)1, (Object)new ITrade[]{new ItemsForEmeraldsTrade(Items.SEA_PICKLE, 2, 1, 5, 1), new ItemsForEmeraldsTrade(Items.SLIME_BALL, 4, 1, 5, 1), new ItemsForEmeraldsTrade(Items.GLOWSTONE, 2, 1, 5, 1), new ItemsForEmeraldsTrade(Items.NAUTILUS_SHELL, 5, 1, 5, 1), new ItemsForEmeraldsTrade(Items.FERN, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.SUGAR_CANE, 1, 1, 8, 1), new ItemsForEmeraldsTrade(Items.PUMPKIN, 1, 1, 4, 1), new ItemsForEmeraldsTrade(Items.KELP, 3, 1, 12, 1), new ItemsForEmeraldsTrade(Items.CACTUS, 3, 1, 8, 1), new ItemsForEmeraldsTrade(Items.DANDELION, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.POPPY, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.BLUE_ORCHID, 1, 1, 8, 1), new ItemsForEmeraldsTrade(Items.ALLIUM, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.AZURE_BLUET, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.RED_TULIP, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.ORANGE_TULIP, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.WHITE_TULIP, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.PINK_TULIP, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.OXEYE_DAISY, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.CORNFLOWER, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.LILY_OF_THE_VALLEY, 1, 1, 7, 1), new ItemsForEmeraldsTrade(Items.WHEAT_SEEDS, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.BEETROOT_SEEDS, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.PUMPKIN_SEEDS, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.MELON_SEEDS, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.ACACIA_SAPLING, 5, 1, 8, 1), new ItemsForEmeraldsTrade(Items.BIRCH_SAPLING, 5, 1, 8, 1), new ItemsForEmeraldsTrade(Items.DARK_OAK_SAPLING, 5, 1, 8, 1), new ItemsForEmeraldsTrade(Items.JUNGLE_SAPLING, 5, 1, 8, 1), new ItemsForEmeraldsTrade(Items.OAK_SAPLING, 5, 1, 8, 1), new ItemsForEmeraldsTrade(Items.SPRUCE_SAPLING, 5, 1, 8, 1), new ItemsForEmeraldsTrade(Items.RED_DYE, 1, 3, 12, 1), new ItemsForEmeraldsTrade(Items.WHITE_DYE, 1, 3, 12, 1), new ItemsForEmeraldsTrade(Items.BLUE_DYE, 1, 3, 12, 1), new ItemsForEmeraldsTrade(Items.PINK_DYE, 1, 3, 12, 1), new ItemsForEmeraldsTrade(Items.BLACK_DYE, 1, 3, 12, 1), new ItemsForEmeraldsTrade(Items.GREEN_DYE, 1, 3, 12, 1), new ItemsForEmeraldsTrade(Items.LIGHT_GRAY_DYE, 1, 3, 12, 1), new ItemsForEmeraldsTrade(Items.MAGENTA_DYE, 1, 3, 12, 1), new ItemsForEmeraldsTrade(Items.YELLOW_DYE, 1, 3, 12, 1), new ItemsForEmeraldsTrade(Items.GRAY_DYE, 1, 3, 12, 1), new ItemsForEmeraldsTrade(Items.PURPLE_DYE, 1, 3, 12, 1), new ItemsForEmeraldsTrade(Items.LIGHT_BLUE_DYE, 1, 3, 12, 1), new ItemsForEmeraldsTrade(Items.LIME_DYE, 1, 3, 12, 1), new ItemsForEmeraldsTrade(Items.ORANGE_DYE, 1, 3, 12, 1), new ItemsForEmeraldsTrade(Items.BROWN_DYE, 1, 3, 12, 1), new ItemsForEmeraldsTrade(Items.CYAN_DYE, 1, 3, 12, 1), new ItemsForEmeraldsTrade(Items.BRAIN_CORAL_BLOCK, 3, 1, 8, 1), new ItemsForEmeraldsTrade(Items.BUBBLE_CORAL_BLOCK, 3, 1, 8, 1), new ItemsForEmeraldsTrade(Items.FIRE_CORAL_BLOCK, 3, 1, 8, 1), new ItemsForEmeraldsTrade(Items.HORN_CORAL_BLOCK, 3, 1, 8, 1), new ItemsForEmeraldsTrade(Items.TUBE_CORAL_BLOCK, 3, 1, 8, 1), new ItemsForEmeraldsTrade(Items.VINE, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.BROWN_MUSHROOM, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.RED_MUSHROOM, 1, 1, 12, 1), new ItemsForEmeraldsTrade(Items.LILY_PAD, 1, 2, 5, 1), new ItemsForEmeraldsTrade(Items.SAND, 1, 8, 8, 1), new ItemsForEmeraldsTrade(Items.RED_SAND, 1, 4, 6, 1)}, (Object)2, (Object)new ITrade[]{new ItemsForEmeraldsTrade(Items.TROPICAL_FISH_BUCKET, 5, 1, 4, 1), new ItemsForEmeraldsTrade(Items.PUFFERFISH_BUCKET, 5, 1, 4, 1), new ItemsForEmeraldsTrade(Items.PACKED_ICE, 3, 1, 6, 1), new ItemsForEmeraldsTrade(Items.BLUE_ICE, 6, 1, 6, 1), new ItemsForEmeraldsTrade(Items.GUNPOWDER, 1, 1, 8, 1), new ItemsForEmeraldsTrade(Items.PODZOL, 3, 3, 6, 1)}));

    private static Int2ObjectMap<ITrade[]> gatAsIntMap(ImmutableMap<Integer, ITrade[]> p_221238_0_) {
        return new Int2ObjectOpenHashMap(p_221238_0_);
    }

    public static interface ITrade {
        @Nullable
        public MerchantOffer getOffer(Entity var1, Random var2);
    }

    static class EmeraldForItemsTrade
    implements ITrade {
        private final Item tradeItem;
        private final int count;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public EmeraldForItemsTrade(IItemProvider tradeItemIn, int countIn, int maxUsesIn, int xpValueIn) {
            this.tradeItem = tradeItemIn.asItem();
            this.count = countIn;
            this.maxUses = maxUsesIn;
            this.xpValue = xpValueIn;
            this.priceMultiplier = 0.05f;
        }

        @Override
        public MerchantOffer getOffer(Entity trader, Random rand) {
            ItemStack itemstack = new ItemStack(this.tradeItem, this.count);
            return new MerchantOffer(itemstack, new ItemStack(Items.EMERALD), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class ItemsForEmeraldsTrade
    implements ITrade {
        private final ItemStack sellingItem;
        private final int emeraldCount;
        private final int sellingItemCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public ItemsForEmeraldsTrade(Block sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack(sellingItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForEmeraldsTrade(Item sellingItem, int emeraldCount, int sellingItemCount, int xpValue) {
            this(new ItemStack(sellingItem), emeraldCount, sellingItemCount, 12, xpValue);
        }

        public ItemsForEmeraldsTrade(Item sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack(sellingItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForEmeraldsTrade(ItemStack sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(sellingItem, emeraldCount, sellingItemCount, maxUses, xpValue, 0.05f);
        }

        public ItemsForEmeraldsTrade(ItemStack sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue, float priceMultiplier) {
            this.sellingItem = sellingItem;
            this.emeraldCount = emeraldCount;
            this.sellingItemCount = sellingItemCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
        }

        @Override
        public MerchantOffer getOffer(Entity trader, Random rand) {
            return new MerchantOffer(new ItemStack(Items.EMERALD, this.emeraldCount), new ItemStack(this.sellingItem.getItem(), this.sellingItemCount), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class SuspiciousStewForEmeraldTrade
    implements ITrade {
        final Effect effect;
        final int duration;
        final int xpValue;
        private final float priceMultiplier;

        public SuspiciousStewForEmeraldTrade(Effect effectIn, int durationIn, int xpValue) {
            this.effect = effectIn;
            this.duration = durationIn;
            this.xpValue = xpValue;
            this.priceMultiplier = 0.05f;
        }

        @Override
        @Nullable
        public MerchantOffer getOffer(Entity trader, Random rand) {
            ItemStack itemstack = new ItemStack(Items.SUSPICIOUS_STEW, 1);
            SuspiciousStewItem.addEffect(itemstack, this.effect, this.duration);
            return new MerchantOffer(new ItemStack(Items.EMERALD, 1), itemstack, 12, this.xpValue, this.priceMultiplier);
        }
    }

    static class ItemsForEmeraldsAndItemsTrade
    implements ITrade {
        private final ItemStack buyingItem;
        private final int buyingItemCount;
        private final int emeraldCount;
        private final ItemStack sellingItem;
        private final int sellingItemCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public ItemsForEmeraldsAndItemsTrade(IItemProvider buyingItem, int buyingItemCount, Item sellingItem, int sellingItemCount, int maxUses, int xpValue) {
            this(buyingItem, buyingItemCount, 1, sellingItem, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForEmeraldsAndItemsTrade(IItemProvider buyingItem, int buyingItemCount, int emeraldCount, Item sellingItem, int sellingItemCount, int maxUses, int xpValue) {
            this.buyingItem = new ItemStack(buyingItem);
            this.buyingItemCount = buyingItemCount;
            this.emeraldCount = emeraldCount;
            this.sellingItem = new ItemStack(sellingItem);
            this.sellingItemCount = sellingItemCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = 0.05f;
        }

        @Override
        @Nullable
        public MerchantOffer getOffer(Entity trader, Random rand) {
            return new MerchantOffer(new ItemStack(Items.EMERALD, this.emeraldCount), new ItemStack(this.buyingItem.getItem(), this.buyingItemCount), new ItemStack(this.sellingItem.getItem(), this.sellingItemCount), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class EnchantedItemForEmeraldsTrade
    implements ITrade {
        private final ItemStack sellingStack;
        private final int emeraldCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public EnchantedItemForEmeraldsTrade(Item p_i50535_1_, int emeraldCount, int maxUses, int xpValue) {
            this(p_i50535_1_, emeraldCount, maxUses, xpValue, 0.05f);
        }

        public EnchantedItemForEmeraldsTrade(Item sellItem, int emeraldCount, int maxUses, int xpValue, float priceMultiplier) {
            this.sellingStack = new ItemStack(sellItem);
            this.emeraldCount = emeraldCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
        }

        @Override
        public MerchantOffer getOffer(Entity trader, Random rand) {
            int i = 5 + rand.nextInt(15);
            ItemStack itemstack = EnchantmentHelper.addRandomEnchantment(rand, new ItemStack(this.sellingStack.getItem()), i, false);
            int j = Math.min(this.emeraldCount + i, 64);
            ItemStack itemstack1 = new ItemStack(Items.EMERALD, j);
            return new MerchantOffer(itemstack1, itemstack, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class EmeraldForVillageTypeItemTrade
    implements ITrade {
        private final Map<VillagerType, Item> villagerTypeItems;
        private final int count;
        private final int maxUses;
        private final int xpValue;

        public EmeraldForVillageTypeItemTrade(int count, int maxUsesIn, int xpValueIn, Map<VillagerType, Item> villagerTypeItemsIn) {
            Registry.VILLAGER_TYPE.stream().filter(villagerType -> !villagerTypeItemsIn.containsKey(villagerType)).findAny().ifPresent(villagerType -> {
                throw new IllegalStateException("Missing trade for villager type: " + String.valueOf(Registry.VILLAGER_TYPE.getKey((VillagerType)villagerType)));
            });
            this.villagerTypeItems = villagerTypeItemsIn;
            this.count = count;
            this.maxUses = maxUsesIn;
            this.xpValue = xpValueIn;
        }

        @Override
        @Nullable
        public MerchantOffer getOffer(Entity trader, Random rand) {
            if (trader instanceof IVillagerDataHolder) {
                ItemStack itemstack = new ItemStack(this.villagerTypeItems.get(((IVillagerDataHolder)((Object)trader)).getVillagerData().getType()), this.count);
                return new MerchantOffer(itemstack, new ItemStack(Items.EMERALD), this.maxUses, this.xpValue, 0.05f);
            }
            return null;
        }
    }

    static class ItemWithPotionForEmeraldsAndItemsTrade
    implements ITrade {
        private final ItemStack potionStack;
        private final int potionCount;
        private final int emeraldCount;
        private final int maxUses;
        private final int xpValue;
        private final Item buyingItem;
        private final int buyingItemCount;
        private final float priceMultiplier;

        public ItemWithPotionForEmeraldsAndItemsTrade(Item buyingItem, int buyingItemCount, Item p_i50526_3_, int p_i50526_4_, int emeralds, int maxUses, int xpValue) {
            this.potionStack = new ItemStack(p_i50526_3_);
            this.emeraldCount = emeralds;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.buyingItem = buyingItem;
            this.buyingItemCount = buyingItemCount;
            this.potionCount = p_i50526_4_;
            this.priceMultiplier = 0.05f;
        }

        @Override
        public MerchantOffer getOffer(Entity trader, Random rand) {
            ItemStack itemstack = new ItemStack(Items.EMERALD, this.emeraldCount);
            List list = Registry.POTION.stream().filter(potion -> !potion.getEffects().isEmpty() && PotionBrewing.isBrewablePotion(potion)).collect(Collectors.toList());
            Potion potion2 = (Potion)list.get(rand.nextInt(list.size()));
            ItemStack itemstack1 = PotionUtils.addPotionToItemStack(new ItemStack(this.potionStack.getItem(), this.potionCount), potion2);
            return new MerchantOffer(itemstack, new ItemStack(this.buyingItem, this.buyingItemCount), itemstack1, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class EnchantedBookForEmeraldsTrade
    implements ITrade {
        private final int xpValue;

        public EnchantedBookForEmeraldsTrade(int xpValueIn) {
            this.xpValue = xpValueIn;
        }

        @Override
        public MerchantOffer getOffer(Entity trader, Random rand) {
            List list = Registry.ENCHANTMENT.stream().filter(Enchantment::canVillagerTrade).collect(Collectors.toList());
            Enchantment enchantment = (Enchantment)list.get(rand.nextInt(list.size()));
            int i = MathHelper.nextInt(rand, enchantment.getMinLevel(), enchantment.getMaxLevel());
            ItemStack itemstack = EnchantedBookItem.getEnchantedItemStack(new EnchantmentData(enchantment, i));
            int j = 2 + rand.nextInt(5 + i * 10) + 3 * i;
            if (enchantment.isTreasureEnchantment()) {
                j *= 2;
            }
            if (j > 64) {
                j = 64;
            }
            return new MerchantOffer(new ItemStack(Items.EMERALD, j), new ItemStack(Items.BOOK), itemstack, 12, this.xpValue, 0.2f);
        }
    }

    static class EmeraldForMapTrade
    implements ITrade {
        private final int count;
        private final Structure<?> structureName;
        private final MapDecoration.Type mapDecorationType;
        private final int maxUses;
        private final int xpValue;

        public EmeraldForMapTrade(int count, Structure<?> structureName, MapDecoration.Type mapDecorationType, int maxUses, int xpValue) {
            this.count = count;
            this.structureName = structureName;
            this.mapDecorationType = mapDecorationType;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
        }

        @Override
        @Nullable
        public MerchantOffer getOffer(Entity trader, Random rand) {
            if (!(trader.world instanceof ServerWorld)) {
                return null;
            }
            ServerWorld serverworld = (ServerWorld)trader.world;
            BlockPos blockpos = serverworld.func_241117_a_(this.structureName, trader.getPosition(), 100, true);
            if (blockpos != null) {
                ItemStack itemstack = FilledMapItem.setupNewMap(serverworld, blockpos.getX(), blockpos.getZ(), (byte)2, true, true);
                FilledMapItem.func_226642_a_(serverworld, itemstack);
                MapData.addTargetDecoration(itemstack, blockpos, "+", this.mapDecorationType);
                itemstack.setDisplayName(new TranslationTextComponent("filled_map." + this.structureName.getStructureName().toLowerCase(Locale.ROOT)));
                return new MerchantOffer(new ItemStack(Items.EMERALD, this.count), new ItemStack(Items.COMPASS), itemstack, this.maxUses, this.xpValue, 0.2f);
            }
            return null;
        }
    }

    static class DyedArmorForEmeraldsTrade
    implements ITrade {
        private final Item tradeItem;
        private final int price;
        private final int maxUses;
        private final int xpValue;

        public DyedArmorForEmeraldsTrade(Item itemIn, int priceIn) {
            this(itemIn, priceIn, 12, 1);
        }

        public DyedArmorForEmeraldsTrade(Item tradeItemIn, int priceIn, int maxUsesIn, int xpValueIn) {
            this.tradeItem = tradeItemIn;
            this.price = priceIn;
            this.maxUses = maxUsesIn;
            this.xpValue = xpValueIn;
        }

        @Override
        public MerchantOffer getOffer(Entity trader, Random rand) {
            ItemStack itemstack = new ItemStack(Items.EMERALD, this.price);
            ItemStack itemstack1 = new ItemStack(this.tradeItem);
            if (this.tradeItem instanceof DyeableArmorItem) {
                ArrayList list = Lists.newArrayList();
                list.add(DyedArmorForEmeraldsTrade.getRandomDyeItem(rand));
                if (rand.nextFloat() > 0.7f) {
                    list.add(DyedArmorForEmeraldsTrade.getRandomDyeItem(rand));
                }
                if (rand.nextFloat() > 0.8f) {
                    list.add(DyedArmorForEmeraldsTrade.getRandomDyeItem(rand));
                }
                itemstack1 = IDyeableArmorItem.dyeItem(itemstack1, list);
            }
            return new MerchantOffer(itemstack, itemstack1, this.maxUses, this.xpValue, 0.2f);
        }

        private static DyeItem getRandomDyeItem(Random p_221232_0_) {
            return DyeItem.getItem(DyeColor.byId(p_221232_0_.nextInt(16)));
        }
    }
}

