/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.world.server.ServerWorld;

public class LookTask
extends Task<MobEntity> {
    public LookTask(int durationMin, int durationMax) {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryModuleStatus.VALUE_PRESENT)), durationMin, durationMax);
    }

    @Override
    protected boolean shouldContinueExecuting(ServerWorld worldIn, MobEntity entityIn, long gameTimeIn) {
        return entityIn.getBrain().getMemory(MemoryModuleType.LOOK_TARGET).filter(posWrapper -> posWrapper.isVisibleTo(entityIn)).isPresent();
    }

    @Override
    protected void resetTask(ServerWorld worldIn, MobEntity entityIn, long gameTimeIn) {
        entityIn.getBrain().removeMemory(MemoryModuleType.LOOK_TARGET);
    }

    @Override
    protected void updateTask(ServerWorld worldIn, MobEntity owner, long gameTime) {
        owner.getBrain().getMemory(MemoryModuleType.LOOK_TARGET).ifPresent(posWrapper -> owner.getLookController().setLookPosition(posWrapper.getPos()));
    }
}

