/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.advancements.criterion.DamageSourcePredicate;
import net.minecraft.advancements.criterion.EntityFlagsPredicate;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.loot.TagLootEntry;
import net.minecraft.loot.conditions.DamageSourceProperties;
import net.minecraft.loot.conditions.EntityHasProperty;
import net.minecraft.loot.conditions.KilledByPlayer;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.loot.conditions.RandomChanceWithLooting;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootingEnchantBonus;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.SetNBT;
import net.minecraft.loot.functions.Smelt;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;

public class EntityLootTables
implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
    private static final EntityPredicate.Builder ON_FIRE = EntityPredicate.Builder.create().flags(EntityFlagsPredicate.Builder.create().onFire(true).build());
    private static final Set<EntityType<?>> NO_DROPS = ImmutableSet.of(EntityType.PLAYER, EntityType.ARMOR_STAND, EntityType.IRON_GOLEM, EntityType.SNOW_GOLEM, EntityType.VILLAGER);
    private final Map<ResourceLocation, LootTable.Builder> lootTables = Maps.newHashMap();

    private static LootTable.Builder sheepLootTableBuilderWithDrop(IItemProvider wool) {
        return LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(ItemLootEntry.builder(wool))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(TableLootEntry.builder(EntityType.SHEEP.getLootTable())));
    }

    @Override
    public void accept(BiConsumer<ResourceLocation, LootTable.Builder> p_accept_1_) {
        this.registerLootTable(EntityType.ARMOR_STAND, LootTable.builder());
        this.registerLootTable(EntityType.BAT, LootTable.builder());
        this.registerLootTable(EntityType.BEE, LootTable.builder());
        this.registerLootTable(EntityType.BLAZE, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.BLAZE_ROD).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptCondition(KilledByPlayer.builder())));
        this.registerLootTable(EntityType.CAT, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)ItemLootEntry.builder(Items.STRING).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f))))));
        this.registerLootTable(EntityType.CAVE_SPIDER, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.STRING).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.SPIDER_EYE).acceptFunction(SetCount.builder(RandomValueRange.of(-1.0f, 1.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptCondition(KilledByPlayer.builder())));
        this.registerLootTable(EntityType.CHICKEN, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.FEATHER).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.CHICKEN).acceptFunction((ILootFunction.IBuilder)Smelt.func_215953_b().acceptCondition(EntityHasProperty.builder(LootContext.EntityTarget.THIS, ON_FIRE)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.COD, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)ItemLootEntry.builder(Items.COD).acceptFunction((ILootFunction.IBuilder)Smelt.func_215953_b().acceptCondition(EntityHasProperty.builder(LootContext.EntityTarget.THIS, ON_FIRE))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(ItemLootEntry.builder(Items.BONE_MEAL)).acceptCondition(RandomChance.builder(0.05f))));
        this.registerLootTable(EntityType.COW, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.LEATHER).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.BEEF).acceptFunction(SetCount.builder(RandomValueRange.of(1.0f, 3.0f)))).acceptFunction((ILootFunction.IBuilder)Smelt.func_215953_b().acceptCondition(EntityHasProperty.builder(LootContext.EntityTarget.THIS, ON_FIRE)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.CREEPER, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.GUNPOWDER).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().addEntry(TagLootEntry.getBuilder(ItemTags.CREEPER_DROP_MUSIC_DISCS)).acceptCondition(EntityHasProperty.builder(LootContext.EntityTarget.KILLER, EntityPredicate.Builder.create().type(EntityTypeTags.SKELETONS)))));
        this.registerLootTable(EntityType.DOLPHIN, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.COD).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptFunction((ILootFunction.IBuilder)Smelt.func_215953_b().acceptCondition(EntityHasProperty.builder(LootContext.EntityTarget.THIS, ON_FIRE))))));
        this.registerLootTable(EntityType.DONKEY, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.LEATHER).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.DROWNED, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.ROTTEN_FLESH).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(ItemLootEntry.builder(Items.GOLD_INGOT)).acceptCondition(KilledByPlayer.builder()).acceptCondition(RandomChanceWithLooting.builder(0.05f, 0.01f))));
        this.registerLootTable(EntityType.ELDER_GUARDIAN, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.PRISMARINE_SHARD).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.COD).weight(3)).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptFunction((ILootFunction.IBuilder)Smelt.func_215953_b().acceptCondition(EntityHasProperty.builder(LootContext.EntityTarget.THIS, ON_FIRE)))).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.PRISMARINE_CRYSTALS).weight(2)).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).addEntry(EmptyLootEntry.func_216167_a())).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(ItemLootEntry.builder(Blocks.WET_SPONGE)).acceptCondition(KilledByPlayer.builder())).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(TableLootEntry.builder(LootTables.GAMEPLAY_FISHING_FISH)).acceptCondition(KilledByPlayer.builder()).acceptCondition(RandomChanceWithLooting.builder(0.025f, 0.01f))));
        this.registerLootTable(EntityType.ENDER_DRAGON, LootTable.builder());
        this.registerLootTable(EntityType.ENDERMAN, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.ENDER_PEARL).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.ENDERMITE, LootTable.builder());
        this.registerLootTable(EntityType.EVOKER, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(ItemLootEntry.builder(Items.TOTEM_OF_UNDYING))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.EMERALD).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptCondition(KilledByPlayer.builder())));
        this.registerLootTable(EntityType.FOX, LootTable.builder());
        this.registerLootTable(EntityType.GHAST, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.GHAST_TEAR).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.GUNPOWDER).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.GIANT, LootTable.builder());
        this.registerLootTable(EntityType.GUARDIAN, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.PRISMARINE_SHARD).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.COD).weight(2)).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptFunction((ILootFunction.IBuilder)Smelt.func_215953_b().acceptCondition(EntityHasProperty.builder(LootContext.EntityTarget.THIS, ON_FIRE)))).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.PRISMARINE_CRYSTALS).weight(2)).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).addEntry(EmptyLootEntry.func_216167_a())).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(TableLootEntry.builder(LootTables.GAMEPLAY_FISHING_FISH)).acceptCondition(KilledByPlayer.builder()).acceptCondition(RandomChanceWithLooting.builder(0.025f, 0.01f))));
        this.registerLootTable(EntityType.HORSE, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.LEATHER).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.HUSK, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.ROTTEN_FLESH).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(ItemLootEntry.builder(Items.IRON_INGOT)).addEntry(ItemLootEntry.builder(Items.CARROT)).addEntry(ItemLootEntry.builder(Items.POTATO)).acceptCondition(KilledByPlayer.builder()).acceptCondition(RandomChanceWithLooting.builder(0.025f, 0.01f))));
        this.registerLootTable(EntityType.RAVAGER, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)ItemLootEntry.builder(Items.SADDLE).acceptFunction(SetCount.builder(ConstantRange.of(1))))));
        this.registerLootTable(EntityType.ILLUSIONER, LootTable.builder());
        this.registerLootTable(EntityType.IRON_GOLEM, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)ItemLootEntry.builder(Blocks.POPPY).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)ItemLootEntry.builder(Items.IRON_INGOT).acceptFunction(SetCount.builder(RandomValueRange.of(3.0f, 5.0f))))));
        this.registerLootTable(EntityType.LLAMA, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.LEATHER).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.MAGMA_CUBE, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.MAGMA_CREAM).acceptFunction(SetCount.builder(RandomValueRange.of(-2.0f, 1.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.MULE, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.LEATHER).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.MOOSHROOM, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.LEATHER).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.BEEF).acceptFunction(SetCount.builder(RandomValueRange.of(1.0f, 3.0f)))).acceptFunction((ILootFunction.IBuilder)Smelt.func_215953_b().acceptCondition(EntityHasProperty.builder(LootContext.EntityTarget.THIS, ON_FIRE)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.OCELOT, LootTable.builder());
        this.registerLootTable(EntityType.PANDA, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)ItemLootEntry.builder(Blocks.BAMBOO).acceptFunction(SetCount.builder(ConstantRange.of(1))))));
        this.registerLootTable(EntityType.PARROT, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.FEATHER).acceptFunction(SetCount.builder(RandomValueRange.of(1.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.PHANTOM, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.PHANTOM_MEMBRANE).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptCondition(KilledByPlayer.builder())));
        this.registerLootTable(EntityType.PIG, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.PORKCHOP).acceptFunction(SetCount.builder(RandomValueRange.of(1.0f, 3.0f)))).acceptFunction((ILootFunction.IBuilder)Smelt.func_215953_b().acceptCondition(EntityHasProperty.builder(LootContext.EntityTarget.THIS, ON_FIRE)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.PILLAGER, LootTable.builder());
        this.registerLootTable(EntityType.PLAYER, LootTable.builder());
        this.registerLootTable(EntityType.POLAR_BEAR, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.COD).weight(3)).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.SALMON).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.PUFFERFISH, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)ItemLootEntry.builder(Items.PUFFERFISH).acceptFunction(SetCount.builder(ConstantRange.of(1))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(ItemLootEntry.builder(Items.BONE_MEAL)).acceptCondition(RandomChance.builder(0.05f))));
        this.registerLootTable(EntityType.RABBIT, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.RABBIT_HIDE).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.RABBIT).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptFunction((ILootFunction.IBuilder)Smelt.func_215953_b().acceptCondition(EntityHasProperty.builder(LootContext.EntityTarget.THIS, ON_FIRE)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(ItemLootEntry.builder(Items.RABBIT_FOOT)).acceptCondition(KilledByPlayer.builder()).acceptCondition(RandomChanceWithLooting.builder(0.1f, 0.03f))));
        this.registerLootTable(EntityType.SALMON, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)ItemLootEntry.builder(Items.SALMON).acceptFunction((ILootFunction.IBuilder)Smelt.func_215953_b().acceptCondition(EntityHasProperty.builder(LootContext.EntityTarget.THIS, ON_FIRE))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(ItemLootEntry.builder(Items.BONE_MEAL)).acceptCondition(RandomChance.builder(0.05f))));
        this.registerLootTable(EntityType.SHEEP, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.MUTTON).acceptFunction(SetCount.builder(RandomValueRange.of(1.0f, 2.0f)))).acceptFunction((ILootFunction.IBuilder)Smelt.func_215953_b().acceptCondition(EntityHasProperty.builder(LootContext.EntityTarget.THIS, ON_FIRE)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(LootTables.ENTITIES_SHEEP_BLACK, EntityLootTables.sheepLootTableBuilderWithDrop(Blocks.BLACK_WOOL));
        this.registerLootTable(LootTables.ENTITIES_SHEEP_BLUE, EntityLootTables.sheepLootTableBuilderWithDrop(Blocks.BLUE_WOOL));
        this.registerLootTable(LootTables.ENTITIES_SHEEP_BROWN, EntityLootTables.sheepLootTableBuilderWithDrop(Blocks.BROWN_WOOL));
        this.registerLootTable(LootTables.ENTITIES_SHEEP_CYAN, EntityLootTables.sheepLootTableBuilderWithDrop(Blocks.CYAN_WOOL));
        this.registerLootTable(LootTables.ENTITIES_SHEEP_GRAY, EntityLootTables.sheepLootTableBuilderWithDrop(Blocks.GRAY_WOOL));
        this.registerLootTable(LootTables.ENTITIES_SHEEP_GREEN, EntityLootTables.sheepLootTableBuilderWithDrop(Blocks.GREEN_WOOL));
        this.registerLootTable(LootTables.ENTITIES_SHEEP_LIGHT_BLUE, EntityLootTables.sheepLootTableBuilderWithDrop(Blocks.LIGHT_BLUE_WOOL));
        this.registerLootTable(LootTables.ENTITIES_SHEEP_LIGHT_GRAY, EntityLootTables.sheepLootTableBuilderWithDrop(Blocks.LIGHT_GRAY_WOOL));
        this.registerLootTable(LootTables.ENTITIES_SHEEP_LIME, EntityLootTables.sheepLootTableBuilderWithDrop(Blocks.LIME_WOOL));
        this.registerLootTable(LootTables.ENTITIES_SHEEP_MAGENTA, EntityLootTables.sheepLootTableBuilderWithDrop(Blocks.MAGENTA_WOOL));
        this.registerLootTable(LootTables.ENTITIES_SHEEP_ORANGE, EntityLootTables.sheepLootTableBuilderWithDrop(Blocks.ORANGE_WOOL));
        this.registerLootTable(LootTables.ENTITIES_SHEEP_PINK, EntityLootTables.sheepLootTableBuilderWithDrop(Blocks.PINK_WOOL));
        this.registerLootTable(LootTables.ENTITIES_SHEEP_PURPLE, EntityLootTables.sheepLootTableBuilderWithDrop(Blocks.PURPLE_WOOL));
        this.registerLootTable(LootTables.ENTITIES_SHEEP_RED, EntityLootTables.sheepLootTableBuilderWithDrop(Blocks.RED_WOOL));
        this.registerLootTable(LootTables.ENTITIES_SHEEP_WHITE, EntityLootTables.sheepLootTableBuilderWithDrop(Blocks.WHITE_WOOL));
        this.registerLootTable(LootTables.ENTITIES_SHEEP_YELLOW, EntityLootTables.sheepLootTableBuilderWithDrop(Blocks.YELLOW_WOOL));
        this.registerLootTable(EntityType.SHULKER, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(ItemLootEntry.builder(Items.SHULKER_SHELL)).acceptCondition(RandomChanceWithLooting.builder(0.5f, 0.0625f))));
        this.registerLootTable(EntityType.SILVERFISH, LootTable.builder());
        this.registerLootTable(EntityType.SKELETON, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.ARROW).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.BONE).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.SKELETON_HORSE, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.BONE).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.SLIME, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.SLIME_BALL).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.SNOW_GOLEM, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)ItemLootEntry.builder(Items.SNOWBALL).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 15.0f))))));
        this.registerLootTable(EntityType.SPIDER, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.STRING).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.SPIDER_EYE).acceptFunction(SetCount.builder(RandomValueRange.of(-1.0f, 1.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptCondition(KilledByPlayer.builder())));
        this.registerLootTable(EntityType.SQUID, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.INK_SAC).acceptFunction(SetCount.builder(RandomValueRange.of(1.0f, 3.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.STRAY, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.ARROW).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.BONE).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.TIPPED_ARROW).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)).func_216072_a(1))).acceptFunction(SetNBT.builder(Util.make(new CompoundNBT(), nbt -> nbt.putString("Potion", "minecraft:slowness"))))).acceptCondition(KilledByPlayer.builder())));
        this.registerLootTable(EntityType.STRIDER, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.STRING).acceptFunction(SetCount.builder(RandomValueRange.of(2.0f, 5.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.TRADER_LLAMA, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.LEATHER).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.TROPICAL_FISH, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)ItemLootEntry.builder(Items.TROPICAL_FISH).acceptFunction(SetCount.builder(ConstantRange.of(1))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(ItemLootEntry.builder(Items.BONE_MEAL)).acceptCondition(RandomChance.builder(0.05f))));
        this.registerLootTable(EntityType.TURTLE, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Blocks.SEAGRASS).weight(3)).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(ItemLootEntry.builder(Items.BOWL)).acceptCondition(DamageSourceProperties.builder(DamageSourcePredicate.Builder.damageType().isLightning(true)))));
        this.registerLootTable(EntityType.VEX, LootTable.builder());
        this.registerLootTable(EntityType.VILLAGER, LootTable.builder());
        this.registerLootTable(EntityType.WANDERING_TRADER, LootTable.builder());
        this.registerLootTable(EntityType.VINDICATOR, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.EMERALD).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptCondition(KilledByPlayer.builder())));
        this.registerLootTable(EntityType.WITCH, LootTable.builder().addLootPool(LootPool.builder().rolls(RandomValueRange.of(1.0f, 3.0f)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.GLOWSTONE_DUST).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.SUGAR).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.REDSTONE).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.SPIDER_EYE).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.GLASS_BOTTLE).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.GUNPOWDER).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f)))).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.STICK).weight(2)).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.WITHER, LootTable.builder());
        this.registerLootTable(EntityType.WITHER_SKELETON, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.COAL).acceptFunction(SetCount.builder(RandomValueRange.of(-1.0f, 1.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.BONE).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(ItemLootEntry.builder(Blocks.WITHER_SKELETON_SKULL)).acceptCondition(KilledByPlayer.builder()).acceptCondition(RandomChanceWithLooting.builder(0.025f, 0.01f))));
        this.registerLootTable(EntityType.WOLF, LootTable.builder());
        this.registerLootTable(EntityType.ZOGLIN, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.ROTTEN_FLESH).acceptFunction(SetCount.builder(RandomValueRange.of(1.0f, 3.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.ZOMBIE, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.ROTTEN_FLESH).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(ItemLootEntry.builder(Items.IRON_INGOT)).addEntry(ItemLootEntry.builder(Items.CARROT)).addEntry(ItemLootEntry.builder(Items.POTATO)).acceptCondition(KilledByPlayer.builder()).acceptCondition(RandomChanceWithLooting.builder(0.025f, 0.01f))));
        this.registerLootTable(EntityType.ZOMBIE_HORSE, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.ROTTEN_FLESH).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.ZOMBIFIED_PIGLIN, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.ROTTEN_FLESH).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.GOLD_NUGGET).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(ItemLootEntry.builder(Items.GOLD_INGOT)).acceptCondition(KilledByPlayer.builder()).acceptCondition(RandomChanceWithLooting.builder(0.025f, 0.01f))));
        this.registerLootTable(EntityType.HOGLIN, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.PORKCHOP).acceptFunction(SetCount.builder(RandomValueRange.of(2.0f, 4.0f)))).acceptFunction((ILootFunction.IBuilder)Smelt.func_215953_b().acceptCondition(EntityHasProperty.builder(LootContext.EntityTarget.THIS, ON_FIRE)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.LEATHER).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 1.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))));
        this.registerLootTable(EntityType.PIGLIN, LootTable.builder());
        this.registerLootTable(EntityType.field_242287_aj, LootTable.builder());
        this.registerLootTable(EntityType.ZOMBIE_VILLAGER, LootTable.builder().addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry((LootEntry.Builder<?>)((StandaloneLootEntry.Builder)ItemLootEntry.builder(Items.ROTTEN_FLESH).acceptFunction(SetCount.builder(RandomValueRange.of(0.0f, 2.0f)))).acceptFunction(LootingEnchantBonus.builder(RandomValueRange.of(0.0f, 1.0f))))).addLootPool(LootPool.builder().rolls(ConstantRange.of(1)).addEntry(ItemLootEntry.builder(Items.IRON_INGOT)).addEntry(ItemLootEntry.builder(Items.CARROT)).addEntry(ItemLootEntry.builder(Items.POTATO)).acceptCondition(KilledByPlayer.builder()).acceptCondition(RandomChanceWithLooting.builder(0.025f, 0.01f))));
        HashSet set = Sets.newHashSet();
        for (EntityType entityType : Registry.ENTITY_TYPE) {
            ResourceLocation resourcelocation = entityType.getLootTable();
            if (!NO_DROPS.contains(entityType) && entityType.getClassification() == EntityClassification.MISC) {
                if (resourcelocation == LootTables.EMPTY || this.lootTables.remove(resourcelocation) == null) continue;
                throw new IllegalStateException(String.format("Weird loottable '%s' for '%s', not a LivingEntity so should not have loot", resourcelocation, Registry.ENTITY_TYPE.getKey(entityType)));
            }
            if (resourcelocation == LootTables.EMPTY || !set.add(resourcelocation)) continue;
            LootTable.Builder loottable$builder = this.lootTables.remove(resourcelocation);
            if (loottable$builder == null) {
                throw new IllegalStateException(String.format("Missing loottable '%s' for '%s'", resourcelocation, Registry.ENTITY_TYPE.getKey(entityType)));
            }
            p_accept_1_.accept(resourcelocation, loottable$builder);
        }
        this.lootTables.forEach(p_accept_1_::accept);
    }

    private void registerLootTable(EntityType<?> type, LootTable.Builder table) {
        this.registerLootTable(type.getLootTable(), table);
    }

    private void registerLootTable(ResourceLocation id, LootTable.Builder table) {
        this.lootTables.put(id, table);
    }
}

