/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DirectoryCache {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Path outputFolder;
    private final Path cacheFile;
    private int hits;
    private final Map<Path, String> staleFiles = Maps.newHashMap();
    private final Map<Path, String> createdFiles = Maps.newHashMap();
    private final Set<Path> protectedPaths = Sets.newHashSet();

    public DirectoryCache(Path folder, String fileName) throws IOException {
        this.outputFolder = folder;
        Path path = folder.resolve(".cache");
        Files.createDirectories(path, new FileAttribute[0]);
        this.cacheFile = path.resolve(fileName);
        this.getFiles().forEach(p_209395_1_ -> {
            String s = this.staleFiles.put((Path)p_209395_1_, "");
        });
        if (Files.isReadable(this.cacheFile)) {
            IOUtils.readLines((InputStream)Files.newInputStream(this.cacheFile, new OpenOption[0]), (Charset)Charsets.UTF_8).forEach(p_208315_2_ -> {
                int i = p_208315_2_.indexOf(32);
                this.staleFiles.put(folder.resolve(p_208315_2_.substring(i + 1)), p_208315_2_.substring(0, i));
            });
        }
    }

    public void writeCache() throws IOException {
        BufferedWriter writer;
        this.deleteStale();
        try {
            writer = Files.newBufferedWriter(this.cacheFile, new OpenOption[0]);
        }
        catch (IOException ioexception) {
            LOGGER.warn("Unable write cachefile {}: {}", (Object)this.cacheFile, (Object)ioexception.toString());
            return;
        }
        IOUtils.writeLines((Collection)this.createdFiles.entrySet().stream().map(p_208319_1_ -> (String)p_208319_1_.getValue() + " " + String.valueOf(this.outputFolder.relativize((Path)p_208319_1_.getKey()))).collect(Collectors.toList()), (String)System.lineSeparator(), (Writer)writer);
        ((Writer)writer).close();
        LOGGER.debug("Caching: cache hits: {}, created: {} removed: {}", (Object)this.hits, (Object)(this.createdFiles.size() - this.hits), (Object)this.staleFiles.size());
    }

    @Nullable
    public String getPreviousHash(Path fileIn) {
        return this.staleFiles.get(fileIn);
    }

    public void recordHash(Path fileIn, String hash) {
        this.createdFiles.put(fileIn, hash);
        if (Objects.equals(this.staleFiles.remove(fileIn), hash)) {
            ++this.hits;
        }
    }

    public boolean isStale(Path fileIn) {
        return this.staleFiles.containsKey(fileIn);
    }

    public void addProtectedPath(Path p_218456_1_) {
        this.protectedPaths.add(p_218456_1_);
    }

    private void deleteStale() throws IOException {
        this.getFiles().forEach(p_208322_1_ -> {
            if (this.isStale((Path)p_208322_1_) && !this.protectedPaths.contains(p_208322_1_)) {
                try {
                    Files.delete(p_208322_1_);
                }
                catch (IOException ioexception) {
                    LOGGER.debug("Unable to delete: {} ({})", p_208322_1_, (Object)ioexception.toString());
                }
            }
        });
    }

    private Stream<Path> getFiles() throws IOException {
        return Files.walk(this.outputFolder, new FileVisitOption[0]).filter(p_209397_1_ -> !Objects.equals(this.cacheFile, p_209397_1_) && !Files.isDirectory(p_209397_1_, new LinkOption[0]));
    }
}

