/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.crash;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.optifine.CrashReporter;
import net.optifine.reflect.Reflector;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CrashReport {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String description;
    private final Throwable cause;
    private final CrashReportCategory systemDetailsCategory = new CrashReportCategory(this, "System Details");
    private final List<CrashReportCategory> crashReportSections = Lists.newArrayList();
    private File crashReportFile;
    private boolean firstCategoryInCrashReport = true;
    private StackTraceElement[] stacktrace = new StackTraceElement[0];
    private boolean reported = false;

    public CrashReport(String descriptionIn, Throwable causeThrowable) {
        this.description = descriptionIn;
        this.cause = causeThrowable;
        this.populateEnvironment();
    }

    private void populateEnvironment() {
        this.systemDetailsCategory.addDetail("Minecraft Version", () -> SharedConstants.getVersion().getName());
        this.systemDetailsCategory.addDetail("Minecraft Version ID", () -> SharedConstants.getVersion().getId());
        this.systemDetailsCategory.addDetail("Operating System", () -> System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version"));
        this.systemDetailsCategory.addDetail("Java Version", () -> System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
        this.systemDetailsCategory.addDetail("Java VM Version", () -> System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor"));
        this.systemDetailsCategory.addDetail("Memory", () -> {
            Runtime runtime = Runtime.getRuntime();
            long i = runtime.maxMemory();
            long j = runtime.totalMemory();
            long k = runtime.freeMemory();
            long l = i / 1024L / 1024L;
            long i1 = j / 1024L / 1024L;
            long j1 = k / 1024L / 1024L;
            return k + " bytes (" + j1 + " MB) / " + j + " bytes (" + i1 + " MB) up to " + i + " bytes (" + l + " MB)";
        });
        this.systemDetailsCategory.addDetail("CPUs", Runtime.getRuntime().availableProcessors());
        this.systemDetailsCategory.addDetail("JVM Flags", () -> {
            List list = Util.getJvmFlags().collect(Collectors.toList());
            return String.format("%d total; %s", list.size(), list.stream().collect(Collectors.joining(" ")));
        });
        if (Reflector.CrashReportExtender_enhanceCrashReport != null) {
            Reflector.CrashReportExtender_enhanceCrashReport.call(this, this.systemDetailsCategory);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Throwable getCrashCause() {
        return this.cause;
    }

    public void getSectionsInStringBuilder(StringBuilder builder) {
        if (!(this.stacktrace != null && this.stacktrace.length > 0 || this.crashReportSections.isEmpty())) {
            this.stacktrace = (StackTraceElement[])ArrayUtils.subarray((Object[])this.crashReportSections.get(0).getStackTrace(), (int)0, (int)1);
        }
        if (this.stacktrace != null && this.stacktrace.length > 0) {
            builder.append("-- Head --\n");
            builder.append("Thread: ").append(Thread.currentThread().getName()).append("\n");
            if (Reflector.CrashReportExtender_generateEnhancedStackTraceSTE.exists()) {
                builder.append("Stacktrace:");
                builder.append(Reflector.CrashReportExtender_generateEnhancedStackTraceSTE.callString1(this.stacktrace));
            } else {
                builder.append("Stacktrace:\n");
                for (StackTraceElement stacktraceelement : this.stacktrace) {
                    builder.append("\t").append("at ").append(stacktraceelement);
                    builder.append("\n");
                }
                builder.append("\n");
            }
        }
        for (CrashReportCategory crashreportcategory : this.crashReportSections) {
            crashreportcategory.appendToStringBuilder(builder);
            builder.append("\n\n");
        }
        this.systemDetailsCategory.appendToStringBuilder(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCauseStackTraceOrString() {
        String s;
        StringWriter stringwriter = null;
        PrintWriter printwriter = null;
        Throwable throwable = this.cause;
        if (throwable.getMessage() == null) {
            if (throwable instanceof NullPointerException) {
                throwable = new NullPointerException(this.description);
            } else if (throwable instanceof StackOverflowError) {
                throwable = new StackOverflowError(this.description);
            } else if (throwable instanceof OutOfMemoryError) {
                throwable = new OutOfMemoryError(this.description);
            }
            throwable.setStackTrace(this.cause.getStackTrace());
        }
        if (Reflector.CrashReportExtender_generateEnhancedStackTraceT.exists()) {
            return Reflector.CrashReportExtender_generateEnhancedStackTraceT.callString(throwable);
        }
        try {
            stringwriter = new StringWriter();
            printwriter = new PrintWriter(stringwriter);
            throwable.printStackTrace(printwriter);
            s = stringwriter.toString();
        }
        catch (Throwable throwable2) {
            IOUtils.closeQuietly((Writer)stringwriter);
            IOUtils.closeQuietly(printwriter);
            throw throwable2;
        }
        IOUtils.closeQuietly((Writer)stringwriter);
        IOUtils.closeQuietly((Writer)printwriter);
        return s;
    }

    public String getCompleteReport() {
        if (!this.reported) {
            this.reported = true;
            CrashReporter.onCrashReport(this, this.systemDetailsCategory);
        }
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append("---- Minecraft Crash Report ----\n");
        if (Reflector.CrashReportExtender_addCrashReportHeader != null && Reflector.CrashReportExtender_addCrashReportHeader.exists()) {
            Reflector.CrashReportExtender_addCrashReportHeader.call(stringbuilder, this);
        }
        stringbuilder.append("// ");
        stringbuilder.append(CrashReport.getWittyComment());
        stringbuilder.append("\n\n");
        stringbuilder.append("Time: ");
        stringbuilder.append(new SimpleDateFormat().format(new Date()));
        stringbuilder.append("\n");
        stringbuilder.append("Description: ");
        stringbuilder.append(this.description);
        stringbuilder.append("\n\n");
        stringbuilder.append(this.getCauseStackTraceOrString());
        stringbuilder.append("\n\nA detailed walkthrough of the error, its code path and all known details is as follows:\n");
        for (int i = 0; i < 87; ++i) {
            stringbuilder.append("-");
        }
        stringbuilder.append("\n\n");
        this.getSectionsInStringBuilder(stringbuilder);
        return stringbuilder.toString();
    }

    public File getFile() {
        return this.crashReportFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean saveToFile(File toFile) {
        boolean bl;
        if (this.crashReportFile != null) {
            return false;
        }
        if (toFile.getParentFile() != null) {
            toFile.getParentFile().mkdirs();
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(toFile), StandardCharsets.UTF_8);
            writer.write(this.getCompleteReport());
            this.crashReportFile = toFile;
            bl = true;
        }
        catch (Throwable throwable) {
            boolean flag;
            try {
                LOGGER.error("Could not save crash report to {}", (Object)toFile, (Object)throwable);
                flag = false;
            }
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(writer);
                throw throwable2;
            }
            IOUtils.closeQuietly((Writer)writer);
            return flag;
        }
        IOUtils.closeQuietly((Writer)writer);
        return bl;
    }

    public CrashReportCategory getCategory() {
        return this.systemDetailsCategory;
    }

    public CrashReportCategory makeCategory(String name) {
        return this.makeCategoryDepth(name, 1);
    }

    public CrashReportCategory makeCategoryDepth(String categoryName, int stacktraceLength) {
        CrashReportCategory crashreportcategory = new CrashReportCategory(this, categoryName);
        try {
            if (this.firstCategoryInCrashReport) {
                int i = crashreportcategory.getPrunedStackTrace(stacktraceLength);
                StackTraceElement[] astacktraceelement = this.cause.getStackTrace();
                StackTraceElement stacktraceelement = null;
                StackTraceElement stacktraceelement1 = null;
                int j = astacktraceelement.length - i;
                if (j < 0) {
                    System.out.println("Negative index in crash report handler (" + astacktraceelement.length + "/" + i + ")");
                }
                if (astacktraceelement != null && 0 <= j && j < astacktraceelement.length) {
                    stacktraceelement = astacktraceelement[j];
                    if (astacktraceelement.length + 1 - i < astacktraceelement.length) {
                        stacktraceelement1 = astacktraceelement[astacktraceelement.length + 1 - i];
                    }
                }
                this.firstCategoryInCrashReport = crashreportcategory.firstTwoElementsOfStackTraceMatch(stacktraceelement, stacktraceelement1);
                if (i > 0 && !this.crashReportSections.isEmpty()) {
                    CrashReportCategory crashreportcategory1 = this.crashReportSections.get(this.crashReportSections.size() - 1);
                    crashreportcategory1.trimStackTraceEntriesFromBottom(i);
                } else if (astacktraceelement != null && astacktraceelement.length >= i && 0 <= j && j < astacktraceelement.length) {
                    this.stacktrace = new StackTraceElement[j];
                    System.arraycopy(astacktraceelement, 0, this.stacktrace, 0, this.stacktrace.length);
                } else {
                    this.firstCategoryInCrashReport = false;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.crashReportSections.add(crashreportcategory);
        return crashreportcategory;
    }

    private static String getWittyComment() {
        String[] astring = new String[]{"Who set us up the TNT?", "Everything's going to plan. No, really, that was supposed to happen.", "Uh... Did I do that?", "Oops.", "Why did you do that?", "I feel sad now :(", "My bad.", "I'm sorry, Dave.", "I let you down. Sorry :(", "On the bright side, I bought you a teddy bear!", "Daisy, daisy...", "Oh - I know what I did wrong!", "Hey, that tickles! Hehehe!", "I blame Dinnerbone.", "You should try our sister game, Minceraft!", "Don't be sad. I'll do better next time, I promise!", "Don't be sad, have a hug! <3", "I just don't know what went wrong :(", "Shall we play a game?", "Quite honestly, I wouldn't worry myself about that.", "I bet Cylons wouldn't have this problem.", "Sorry :(", "Surprise! Haha. Well, this is awkward.", "Would you like a cupcake?", "Hi. I'm Minecraft, and I'm a crashaholic.", "Ooh. Shiny.", "This doesn't make any sense!", "Why is it breaking :(", "Don't do that.", "Ouch. That hurt :(", "You're mean.", "This is a token for 1 free hug. Redeem at your nearest Mojangsta: [~~HUG~~]", "There are four lights!", "But it works on my machine."};
        try {
            return astring[(int)(Util.nanoTime() % (long)astring.length)];
        }
        catch (Throwable throwable) {
            return "Witty comment unavailable :(";
        }
    }

    public static CrashReport makeCrashReport(Throwable causeIn, String descriptionIn) {
        while (causeIn instanceof CompletionException && causeIn.getCause() != null) {
            causeIn = causeIn.getCause();
        }
        CrashReport crashreport = causeIn instanceof ReportedException ? ((ReportedException)causeIn).getCrashReport() : new CrashReport(descriptionIn, causeIn);
        return crashreport;
    }

    public static void crash() {
        new CrashReport("Don't panic!", new Throwable()).getCompleteReport();
    }
}

