/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.EntitySelector;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TranslationTextComponent;

public class ScoreHolderArgument
implements ArgumentType<INameProvider> {
    public static final SuggestionProvider<CommandSource> SUGGEST_ENTITY_SELECTOR = (p_201323_0_, p_201323_1_) -> {
        StringReader stringreader = new StringReader(p_201323_1_.getInput());
        stringreader.setCursor(p_201323_1_.getStart());
        EntitySelectorParser entityselectorparser = new EntitySelectorParser(stringreader);
        try {
            entityselectorparser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return entityselectorparser.fillSuggestions(p_201323_1_, p_201949_1_ -> ISuggestionProvider.suggest(((CommandSource)p_201323_0_.getSource()).getPlayerNames(), p_201949_1_));
    };
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "*", "@e");
    private static final SimpleCommandExceptionType EMPTY_EXCEPTION = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.scoreHolder.empty"));
    private final boolean allowMultiple;

    public ScoreHolderArgument(boolean allowMultipleIn) {
        this.allowMultiple = allowMultipleIn;
    }

    public static String getSingleScoreHolderNoObjectives(CommandContext<CommandSource> context, String name) throws CommandSyntaxException {
        return ScoreHolderArgument.getScoreHolderNoObjectives(context, name).iterator().next();
    }

    public static Collection<String> getScoreHolderNoObjectives(CommandContext<CommandSource> context, String name) throws CommandSyntaxException {
        return ScoreHolderArgument.getScoreHolder(context, name, Collections::emptyList);
    }

    public static Collection<String> getScoreHolder(CommandContext<CommandSource> context, String name) throws CommandSyntaxException {
        return ScoreHolderArgument.getScoreHolder(context, name, ((CommandSource)context.getSource()).getServer().getScoreboard()::getObjectiveNames);
    }

    public static Collection<String> getScoreHolder(CommandContext<CommandSource> context, String name, Supplier<Collection<String>> objectives) throws CommandSyntaxException {
        Collection<String> collection = ((INameProvider)context.getArgument(name, INameProvider.class)).getNames((CommandSource)context.getSource(), objectives);
        if (collection.isEmpty()) {
            throw EntityArgument.ENTITY_NOT_FOUND.create();
        }
        return collection;
    }

    public static ScoreHolderArgument scoreHolder() {
        return new ScoreHolderArgument(false);
    }

    public static ScoreHolderArgument scoreHolders() {
        return new ScoreHolderArgument(true);
    }

    public INameProvider parse(StringReader p_parse_1_) throws CommandSyntaxException {
        if (p_parse_1_.canRead() && p_parse_1_.peek() == '@') {
            EntitySelectorParser entityselectorparser = new EntitySelectorParser(p_parse_1_);
            EntitySelector entityselector = entityselectorparser.parse();
            if (!this.allowMultiple && entityselector.getLimit() > 1) {
                throw EntityArgument.TOO_MANY_ENTITIES.create();
            }
            return new NameProvider(entityselector);
        }
        int i = p_parse_1_.getCursor();
        while (p_parse_1_.canRead() && p_parse_1_.peek() != ' ') {
            p_parse_1_.skip();
        }
        String s = p_parse_1_.getString().substring(i, p_parse_1_.getCursor());
        if (s.equals("*")) {
            return (p_197208_0_, p_197208_1_) -> {
                Collection collection1 = (Collection)p_197208_1_.get();
                if (collection1.isEmpty()) {
                    throw EMPTY_EXCEPTION.create();
                }
                return collection1;
            };
        }
        Set<String> collection = Collections.singleton(s);
        return (p_197212_1_, p_197212_2_) -> collection;
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @FunctionalInterface
    public static interface INameProvider {
        public Collection<String> getNames(CommandSource var1, Supplier<Collection<String>> var2) throws CommandSyntaxException;
    }

    public static class NameProvider
    implements INameProvider {
        private final EntitySelector selector;

        public NameProvider(EntitySelector selectorIn) {
            this.selector = selectorIn;
        }

        @Override
        public Collection<String> getNames(CommandSource p_getNames_1_, Supplier<Collection<String>> p_getNames_2_) throws CommandSyntaxException {
            List<? extends Entity> list = this.selector.select(p_getNames_1_);
            if (list.isEmpty()) {
                throw EntityArgument.ENTITY_NOT_FOUND.create();
            }
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                list1.add(entity.getScoreboardName());
            }
            return list1;
        }
    }

    public static class Serializer
    implements IArgumentSerializer<ScoreHolderArgument> {
        @Override
        public void write(ScoreHolderArgument argument, PacketBuffer buffer) {
            int b0 = 0;
            if (argument.allowMultiple) {
                b0 = (byte)(b0 | 1);
            }
            buffer.writeByte(b0);
        }

        @Override
        public ScoreHolderArgument read(PacketBuffer buffer) {
            byte b0 = buffer.readByte();
            boolean flag = (b0 & 1) != 0;
            return new ScoreHolderArgument(flag);
        }

        @Override
        public void write(ScoreHolderArgument p_212244_1_, JsonObject p_212244_2_) {
            p_212244_2_.addProperty("amount", p_212244_1_.allowMultiple ? "multiple" : "single");
        }
    }
}

