/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.LocationInput;
import net.minecraft.command.arguments.LocationPart;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.text.TranslationTextComponent;

public class ColumnPosArgument
implements ArgumentType<ILocationArgument> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0 0", "~ ~", "~1 ~-2", "^ ^", "^-1 ^0");
    public static final SimpleCommandExceptionType INCOMPLETE_EXCEPTION = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.pos2d.incomplete"));

    public static ColumnPosArgument columnPos() {
        return new ColumnPosArgument();
    }

    public static ColumnPos fromBlockPos(CommandContext<CommandSource> context, String name) {
        BlockPos blockpos = ((ILocationArgument)context.getArgument(name, ILocationArgument.class)).getBlockPos((CommandSource)context.getSource());
        return new ColumnPos(blockpos.getX(), blockpos.getZ());
    }

    public ILocationArgument parse(StringReader p_parse_1_) throws CommandSyntaxException {
        int i = p_parse_1_.getCursor();
        if (!p_parse_1_.canRead()) {
            throw INCOMPLETE_EXCEPTION.createWithContext((ImmutableStringReader)p_parse_1_);
        }
        LocationPart locationpart = LocationPart.parseInt(p_parse_1_);
        if (p_parse_1_.canRead() && p_parse_1_.peek() == ' ') {
            p_parse_1_.skip();
            LocationPart locationpart1 = LocationPart.parseInt(p_parse_1_);
            return new LocationInput(locationpart, new LocationPart(true, 0.0), locationpart1);
        }
        p_parse_1_.setCursor(i);
        throw INCOMPLETE_EXCEPTION.createWithContext((ImmutableStringReader)p_parse_1_);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_listSuggestions_1_, SuggestionsBuilder p_listSuggestions_2_) {
        if (!(p_listSuggestions_1_.getSource() instanceof ISuggestionProvider)) {
            return Suggestions.empty();
        }
        String s = p_listSuggestions_2_.getRemaining();
        Collection<ISuggestionProvider.Coordinates> collection = !s.isEmpty() && s.charAt(0) == '^' ? Collections.singleton(ISuggestionProvider.Coordinates.DEFAULT_LOCAL) : ((ISuggestionProvider)p_listSuggestions_1_.getSource()).func_217294_q();
        return ISuggestionProvider.func_211269_a(s, collection, p_listSuggestions_2_, Commands.predicate(this::parse));
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

