/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.util.SearchTreeReloadable;
import net.minecraft.client.util.SuffixArray;
import net.minecraft.util.ResourceLocation;

public class SearchTree<T>
extends SearchTreeReloadable<T> {
    protected SuffixArray<T> byName = new SuffixArray();
    private final Function<T, Stream<String>> nameFunc;

    public SearchTree(Function<T, Stream<String>> nameFuncIn, Function<T, Stream<ResourceLocation>> idFuncIn) {
        super(idFuncIn);
        this.nameFunc = nameFuncIn;
    }

    @Override
    public void recalculate() {
        this.byName = new SuffixArray();
        super.recalculate();
        this.byName.generate();
    }

    @Override
    protected void index(T element) {
        super.index(element);
        this.nameFunc.apply(element).forEach(p_217880_2_ -> this.byName.add(element, p_217880_2_.toLowerCase(Locale.ROOT)));
    }

    @Override
    public List<T> search(String searchText) {
        int i = searchText.indexOf(58);
        if (i < 0) {
            return this.byName.search(searchText);
        }
        List list = this.namespaceList.search(searchText.substring(0, i).trim());
        String s = searchText.substring(i + 1).trim();
        List list1 = this.pathList.search(s);
        List<T> list2 = this.byName.search(s);
        return Lists.newArrayList(new SearchTreeReloadable.JoinedIterator(list.iterator(), new MergingIterator(list1.iterator(), list2.iterator(), this::compare), this::compare));
    }

    static class MergingIterator<T>
    extends AbstractIterator<T> {
        private final PeekingIterator<T> leftItr;
        private final PeekingIterator<T> rightItr;
        private final Comparator<T> numbers;

        public MergingIterator(Iterator<T> p_i49977_1_, Iterator<T> p_i49977_2_, Comparator<T> p_i49977_3_) {
            this.leftItr = Iterators.peekingIterator(p_i49977_1_);
            this.rightItr = Iterators.peekingIterator(p_i49977_2_);
            this.numbers = p_i49977_3_;
        }

        protected T computeNext() {
            boolean flag1;
            boolean flag = !this.leftItr.hasNext();
            boolean bl = flag1 = !this.rightItr.hasNext();
            if (flag && flag1) {
                return (T)this.endOfData();
            }
            if (flag) {
                return (T)this.rightItr.next();
            }
            if (flag1) {
                return (T)this.leftItr.next();
            }
            int i = this.numbers.compare(this.leftItr.peek(), this.rightItr.peek());
            if (i == 0) {
                this.rightItr.next();
            }
            return (T)(i <= 0 ? this.leftItr.next() : this.rightItr.next());
        }
    }
}

