/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import org.lwjgl.stb.STBIEOFCallback;
import org.lwjgl.stb.STBIEOFCallbackI;
import org.lwjgl.stb.STBIIOCallbacks;
import org.lwjgl.stb.STBIReadCallback;
import org.lwjgl.stb.STBIReadCallbackI;
import org.lwjgl.stb.STBISkipCallback;
import org.lwjgl.stb.STBISkipCallbackI;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class PngSizeInfo {
    public final int width;
    public final int height;
    private static final Object STATIC_MONITOR = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PngSizeInfo(String p_i51172_1_, InputStream p_i51172_2_) throws IOException {
        Object object = STATIC_MONITOR;
        synchronized (object) {
            try (MemoryStack memorystack = MemoryStack.stackPush();
                 Reader pngsizeinfo$reader = PngSizeInfo.func_195695_a(p_i51172_2_);
                 STBIReadCallback stbireadcallback = STBIReadCallback.create(pngsizeinfo$reader::func_195682_a);
                 STBISkipCallback stbiskipcallback = STBISkipCallback.create(pngsizeinfo$reader::func_195686_a);
                 STBIEOFCallback stbieofcallback = STBIEOFCallback.create(pngsizeinfo$reader::func_195685_a);){
                STBIIOCallbacks stbiiocallbacks = STBIIOCallbacks.mallocStack((MemoryStack)memorystack);
                stbiiocallbacks.read((STBIReadCallbackI)stbireadcallback);
                stbiiocallbacks.skip((STBISkipCallbackI)stbiskipcallback);
                stbiiocallbacks.eof((STBIEOFCallbackI)stbieofcallback);
                IntBuffer intbuffer = memorystack.mallocInt(1);
                IntBuffer intbuffer1 = memorystack.mallocInt(1);
                IntBuffer intbuffer2 = memorystack.mallocInt(1);
                if (!STBImage.stbi_info_from_callbacks((STBIIOCallbacks)stbiiocallbacks, (long)0L, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2)) {
                    throw new IOException("Could not read info from the PNG file " + p_i51172_1_ + " " + STBImage.stbi_failure_reason());
                }
                this.width = intbuffer.get(0);
                this.height = intbuffer1.get(0);
            }
        }
    }

    public String toString() {
        return this.width + " x " + this.height;
    }

    private static Reader func_195695_a(InputStream p_195695_0_) {
        return p_195695_0_ instanceof FileInputStream ? new ReaderSeekable(((FileInputStream)p_195695_0_).getChannel()) : new ReaderBuffer(Channels.newChannel(p_195695_0_));
    }

    static abstract class Reader
    implements AutoCloseable {
        protected boolean field_195687_a;

        private Reader() {
        }

        int func_195682_a(long p_195682_1_, long p_195682_3_, int p_195682_5_) {
            try {
                return this.func_195683_b(p_195682_3_, p_195682_5_);
            }
            catch (IOException ioexception) {
                this.field_195687_a = true;
                return 0;
            }
        }

        void func_195686_a(long p_195686_1_, int p_195686_3_) {
            try {
                this.func_195684_a(p_195686_3_);
            }
            catch (IOException ioexception) {
                this.field_195687_a = true;
            }
        }

        int func_195685_a(long p_195685_1_) {
            return this.field_195687_a ? 1 : 0;
        }

        protected abstract int func_195683_b(long var1, int var3) throws IOException;

        protected abstract void func_195684_a(int var1) throws IOException;

        @Override
        public abstract void close() throws IOException;
    }

    static class ReaderSeekable
    extends Reader {
        private final SeekableByteChannel channel;

        private ReaderSeekable(SeekableByteChannel p_i48134_1_) {
            this.channel = p_i48134_1_;
        }

        @Override
        public int func_195683_b(long p_195683_1_, int p_195683_3_) throws IOException {
            ByteBuffer bytebuffer = MemoryUtil.memByteBuffer((long)p_195683_1_, (int)p_195683_3_);
            return this.channel.read(bytebuffer);
        }

        @Override
        public void func_195684_a(int p_195684_1_) throws IOException {
            this.channel.position(this.channel.position() + (long)p_195684_1_);
        }

        @Override
        public int func_195685_a(long p_195685_1_) {
            return super.func_195685_a(p_195685_1_) != 0 && this.channel.isOpen() ? 1 : 0;
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }
    }

    static class ReaderBuffer
    extends Reader {
        private final ReadableByteChannel channel;
        private long field_195690_c = MemoryUtil.nmemAlloc((long)128L);
        private int field_195691_d = 128;
        private int field_195692_e;
        private int field_195693_f;

        private ReaderBuffer(ReadableByteChannel p_i48136_1_) {
            this.channel = p_i48136_1_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void func_195688_b(int p_195688_1_) throws IOException {
            ByteBuffer bytebuffer = MemoryUtil.memByteBuffer((long)this.field_195690_c, (int)this.field_195691_d);
            if (p_195688_1_ + this.field_195693_f > this.field_195691_d) {
                this.field_195691_d = p_195688_1_ + this.field_195693_f;
                bytebuffer = MemoryUtil.memRealloc((ByteBuffer)bytebuffer, (int)this.field_195691_d);
                this.field_195690_c = MemoryUtil.memAddress((ByteBuffer)bytebuffer);
            }
            ((Buffer)bytebuffer).position(this.field_195692_e);
            while (p_195688_1_ + this.field_195693_f > this.field_195692_e) {
                try {
                    int i = this.channel.read(bytebuffer);
                    if (i != -1) continue;
                    break;
                }
                finally {
                    this.field_195692_e = bytebuffer.position();
                }
            }
        }

        @Override
        public int func_195683_b(long p_195683_1_, int p_195683_3_) throws IOException {
            this.func_195688_b(p_195683_3_);
            if (p_195683_3_ + this.field_195693_f > this.field_195692_e) {
                p_195683_3_ = this.field_195692_e - this.field_195693_f;
            }
            MemoryUtil.memCopy((long)(this.field_195690_c + (long)this.field_195693_f), (long)p_195683_1_, (long)p_195683_3_);
            this.field_195693_f += p_195683_3_;
            return p_195683_3_;
        }

        @Override
        public void func_195684_a(int p_195684_1_) throws IOException {
            if (p_195684_1_ > 0) {
                this.func_195688_b(p_195684_1_);
                if (p_195684_1_ + this.field_195693_f > this.field_195692_e) {
                    throw new EOFException("Can't skip past the EOF.");
                }
            }
            if (this.field_195693_f + p_195684_1_ < 0) {
                throw new IOException("Can't seek before the beginning: " + (this.field_195693_f + p_195684_1_));
            }
            this.field_195693_f += p_195684_1_;
        }

        @Override
        public void close() throws IOException {
            MemoryUtil.nmemFree((long)this.field_195690_c);
            this.channel.close();
        }
    }
}

