/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import org.apache.commons.lang3.tuple.Pair;

public class MultipartBakedModel
implements IBakedModel {
    private final List<Pair<Predicate<BlockState>, IBakedModel>> selectors;
    protected final boolean ambientOcclusion;
    protected final boolean gui3D;
    protected final boolean isSideLit;
    protected final TextureAtlasSprite particleTexture;
    protected final ItemCameraTransforms cameraTransforms;
    protected final ItemOverrideList overrides;
    private final Map<BlockState, BitSet> bitSetCache = new Object2ObjectOpenCustomHashMap(Util.identityHashStrategy());

    public MultipartBakedModel(List<Pair<Predicate<BlockState>, IBakedModel>> selectors) {
        this.selectors = selectors;
        IBakedModel ibakedmodel = (IBakedModel)selectors.iterator().next().getRight();
        this.ambientOcclusion = ibakedmodel.isAmbientOcclusion();
        this.gui3D = ibakedmodel.isGui3d();
        this.isSideLit = ibakedmodel.isSideLit();
        this.particleTexture = ibakedmodel.getParticleTexture();
        this.cameraTransforms = ibakedmodel.getItemCameraTransforms();
        this.overrides = ibakedmodel.getOverrides();
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        if (state == null) {
            return Collections.emptyList();
        }
        BitSet bitset = this.bitSetCache.get(state);
        if (bitset == null) {
            bitset = new BitSet();
            for (int i = 0; i < this.selectors.size(); ++i) {
                Pair<Predicate<BlockState>, IBakedModel> pair = this.selectors.get(i);
                if (!((Predicate)pair.getLeft()).test(state)) continue;
                bitset.set(i);
            }
            this.bitSetCache.put(state, bitset);
        }
        ArrayList list = Lists.newArrayList();
        long k = rand.nextLong();
        for (int j = 0; j < bitset.length(); ++j) {
            if (!bitset.get(j)) continue;
            list.addAll(((IBakedModel)this.selectors.get(j).getRight()).getQuads(state, side, new Random(k)));
        }
        return list;
    }

    @Override
    public boolean isAmbientOcclusion() {
        return this.ambientOcclusion;
    }

    @Override
    public boolean isGui3d() {
        return this.gui3D;
    }

    @Override
    public boolean isSideLit() {
        return this.isSideLit;
    }

    @Override
    public boolean isBuiltInRenderer() {
        return false;
    }

    @Override
    public TextureAtlasSprite getParticleTexture() {
        return this.particleTexture;
    }

    @Override
    public ItemCameraTransforms getItemCameraTransforms() {
        return this.cameraTransforms;
    }

    @Override
    public ItemOverrideList getOverrides() {
        return this.overrides;
    }

    public static class Builder {
        private final List<Pair<Predicate<BlockState>, IBakedModel>> selectors = Lists.newArrayList();

        public void putModel(Predicate<BlockState> predicate, IBakedModel model) {
            this.selectors.add((Pair<Predicate<BlockState>, IBakedModel>)Pair.of(predicate, (Object)model));
        }

        public IBakedModel build() {
            return new MultipartBakedModel(this.selectors);
        }
    }
}

