/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;

public class ItemModelGenerator {
    public static final List<String> LAYERS = Lists.newArrayList((Object[])new String[]{"layer0", "layer1", "layer2", "layer3", "layer4"});

    public BlockModel makeItemModel(Function<RenderMaterial, TextureAtlasSprite> textureGetter, BlockModel blockModelIn) {
        String s;
        HashMap map = Maps.newHashMap();
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < LAYERS.size() && blockModelIn.isTexturePresent(s = LAYERS.get(i)); ++i) {
            RenderMaterial rendermaterial = blockModelIn.resolveTextureName(s);
            map.put(s, Either.left((Object)rendermaterial));
            TextureAtlasSprite textureatlassprite = textureGetter.apply(rendermaterial);
            list.addAll(this.getBlockParts(i, s, textureatlassprite));
        }
        map.put("particle", blockModelIn.isTexturePresent("particle") ? Either.left((Object)blockModelIn.resolveTextureName("particle")) : (Either)map.get("layer0"));
        BlockModel blockmodel = new BlockModel(null, list, map, false, blockModelIn.getGuiLight(), blockModelIn.getAllTransforms(), blockModelIn.getOverrides());
        blockmodel.name = blockModelIn.name;
        return blockmodel;
    }

    private List<BlockPart> getBlockParts(int tintIndex, String textureIn, TextureAtlasSprite spriteIn) {
        HashMap map = Maps.newHashMap();
        map.put(Direction.SOUTH, new BlockPartFace(null, tintIndex, textureIn, new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0)));
        map.put(Direction.NORTH, new BlockPartFace(null, tintIndex, textureIn, new BlockFaceUV(new float[]{16.0f, 0.0f, 0.0f, 16.0f}, 0)));
        ArrayList list = Lists.newArrayList();
        list.add(new BlockPart(new Vector3f(0.0f, 0.0f, 7.5f), new Vector3f(16.0f, 16.0f, 8.5f), map, null, true));
        list.addAll(this.getBlockParts(spriteIn, textureIn, tintIndex));
        return list;
    }

    private List<BlockPart> getBlockParts(TextureAtlasSprite spriteIn, String textureIn, int tintIndexIn) {
        float f = spriteIn.getWidth();
        float f1 = spriteIn.getHeight();
        ArrayList list = Lists.newArrayList();
        for (Span itemmodelgenerator$span : this.getSpans(spriteIn)) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 16.0f / f;
            float f11 = 16.0f / f1;
            float f12 = itemmodelgenerator$span.getMin();
            float f13 = itemmodelgenerator$span.getMax();
            float f14 = itemmodelgenerator$span.getAnchor();
            SpanFacing itemmodelgenerator$spanfacing = itemmodelgenerator$span.getFacing();
            switch (itemmodelgenerator$spanfacing) {
                case UP: {
                    f6 = f12;
                    f2 = f12;
                    f4 = f7 = f13 + 1.0f;
                    f8 = f14;
                    f3 = f14;
                    f5 = f14;
                    f9 = f14 + 1.0f;
                    break;
                }
                case DOWN: {
                    f8 = f14;
                    f9 = f14 + 1.0f;
                    f6 = f12;
                    f2 = f12;
                    f4 = f7 = f13 + 1.0f;
                    f3 = f14 + 1.0f;
                    f5 = f14 + 1.0f;
                    break;
                }
                case LEFT: {
                    f6 = f14;
                    f2 = f14;
                    f4 = f14;
                    f7 = f14 + 1.0f;
                    f9 = f12;
                    f3 = f12;
                    f5 = f8 = f13 + 1.0f;
                    break;
                }
                case RIGHT: {
                    f6 = f14;
                    f7 = f14 + 1.0f;
                    f2 = f14 + 1.0f;
                    f4 = f14 + 1.0f;
                    f9 = f12;
                    f3 = f12;
                    f5 = f8 = f13 + 1.0f;
                }
            }
            f2 *= f10;
            f4 *= f10;
            f3 *= f11;
            f5 *= f11;
            f3 = 16.0f - f3;
            f5 = 16.0f - f5;
            HashMap map = Maps.newHashMap();
            map.put(itemmodelgenerator$spanfacing.getFacing(), new BlockPartFace(null, tintIndexIn, textureIn, new BlockFaceUV(new float[]{f6 *= f10, f8 *= f11, f7 *= f10, f9 *= f11}, 0)));
            switch (itemmodelgenerator$spanfacing) {
                case UP: {
                    list.add(new BlockPart(new Vector3f(f2, f3, 7.5f), new Vector3f(f4, f3, 8.5f), map, null, true));
                    break;
                }
                case DOWN: {
                    list.add(new BlockPart(new Vector3f(f2, f5, 7.5f), new Vector3f(f4, f5, 8.5f), map, null, true));
                    break;
                }
                case LEFT: {
                    list.add(new BlockPart(new Vector3f(f2, f3, 7.5f), new Vector3f(f2, f5, 8.5f), map, null, true));
                    break;
                }
                case RIGHT: {
                    list.add(new BlockPart(new Vector3f(f4, f3, 7.5f), new Vector3f(f4, f5, 8.5f), map, null, true));
                }
            }
        }
        return list;
    }

    private List<Span> getSpans(TextureAtlasSprite spriteIn) {
        int i = spriteIn.getWidth();
        int j = spriteIn.getHeight();
        ArrayList list = Lists.newArrayList();
        for (int k = 0; k < spriteIn.getFrameCount(); ++k) {
            for (int l = 0; l < j; ++l) {
                for (int i1 = 0; i1 < i; ++i1) {
                    boolean flag = !this.isTransparent(spriteIn, k, i1, l, i, j);
                    this.checkTransition(SpanFacing.UP, list, spriteIn, k, i1, l, i, j, flag);
                    this.checkTransition(SpanFacing.DOWN, list, spriteIn, k, i1, l, i, j, flag);
                    this.checkTransition(SpanFacing.LEFT, list, spriteIn, k, i1, l, i, j, flag);
                    this.checkTransition(SpanFacing.RIGHT, list, spriteIn, k, i1, l, i, j, flag);
                }
            }
        }
        return list;
    }

    private void checkTransition(SpanFacing spanFacingIn, List<Span> listSpansIn, TextureAtlasSprite spriteIn, int frameIndex, int pixelX, int pixelY, int spiteWidth, int spriteHeight, boolean transparent) {
        boolean flag;
        boolean bl = flag = this.isTransparent(spriteIn, frameIndex, pixelX + spanFacingIn.getXOffset(), pixelY + spanFacingIn.getYOffset(), spiteWidth, spriteHeight) && transparent;
        if (flag) {
            this.createOrExpandSpan(listSpansIn, spanFacingIn, pixelX, pixelY);
        }
    }

    private void createOrExpandSpan(List<Span> listSpansIn, SpanFacing spanFacingIn, int pixelX, int pixelY) {
        int k;
        Span itemmodelgenerator$span = null;
        for (Span itemmodelgenerator$span1 : listSpansIn) {
            int i;
            if (itemmodelgenerator$span1.getFacing() != spanFacingIn) continue;
            int n = i = spanFacingIn.isHorizontal() ? pixelY : pixelX;
            if (itemmodelgenerator$span1.getAnchor() != i) continue;
            itemmodelgenerator$span = itemmodelgenerator$span1;
            break;
        }
        int j = spanFacingIn.isHorizontal() ? pixelY : pixelX;
        int n = k = spanFacingIn.isHorizontal() ? pixelX : pixelY;
        if (itemmodelgenerator$span == null) {
            listSpansIn.add(new Span(spanFacingIn, k, j));
        } else {
            itemmodelgenerator$span.expand(k);
        }
    }

    private boolean isTransparent(TextureAtlasSprite spriteIn, int frameIndex, int pixelX, int pixelY, int spiteWidth, int spriteHeight) {
        return pixelX >= 0 && pixelY >= 0 && pixelX < spiteWidth && pixelY < spriteHeight ? spriteIn.isPixelTransparent(frameIndex, pixelX, pixelY) : true;
    }

    static class Span {
        private final SpanFacing spanFacing;
        private int min;
        private int max;
        private final int anchor;

        public Span(SpanFacing spanFacingIn, int minIn, int maxIn) {
            this.spanFacing = spanFacingIn;
            this.min = minIn;
            this.max = minIn;
            this.anchor = maxIn;
        }

        public void expand(int posIn) {
            if (posIn < this.min) {
                this.min = posIn;
            } else if (posIn > this.max) {
                this.max = posIn;
            }
        }

        public SpanFacing getFacing() {
            return this.spanFacing;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public int getAnchor() {
            return this.anchor;
        }
    }

    static enum SpanFacing {
        UP(Direction.UP, 0, -1),
        DOWN(Direction.DOWN, 0, 1),
        LEFT(Direction.EAST, -1, 0),
        RIGHT(Direction.WEST, 1, 0);

        private final Direction facing;
        private final int xOffset;
        private final int yOffset;

        private SpanFacing(Direction facing, int xOffsetIn, int yOffsetIn) {
            this.facing = facing;
            this.xOffset = xOffsetIn;
            this.yOffset = yOffsetIn;
        }

        public Direction getFacing() {
            return this.facing;
        }

        public int getXOffset() {
            return this.xOffset;
        }

        public int getYOffset() {
            return this.yOffset;
        }

        private boolean isHorizontal() {
            return this == DOWN || this == UP;
        }
    }
}

