/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.UUID;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.SkullTileEntityRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.math.vector.Vector3f;
import org.apache.commons.lang3.StringUtils;

public class HeadLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    private final float field_239402_a_;
    private final float field_239403_b_;
    private final float field_239404_c_;

    public HeadLayer(IEntityRenderer<T, M> p_i50946_1_) {
        this(p_i50946_1_, 1.0f, 1.0f, 1.0f);
    }

    public HeadLayer(IEntityRenderer<T, M> p_i232475_1_, float p_i232475_2_, float p_i232475_3_, float p_i232475_4_) {
        super(p_i232475_1_);
        this.field_239402_a_ = p_i232475_2_;
        this.field_239403_b_ = p_i232475_3_;
        this.field_239404_c_ = p_i232475_4_;
    }

    @Override
    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = ((LivingEntity)entitylivingbaseIn).getItemStackFromSlot(EquipmentSlotType.HEAD);
        if (!itemstack.isEmpty()) {
            boolean flag;
            Item item = itemstack.getItem();
            matrixStackIn.push();
            matrixStackIn.scale(this.field_239402_a_, this.field_239403_b_, this.field_239404_c_);
            boolean bl = flag = entitylivingbaseIn instanceof VillagerEntity || entitylivingbaseIn instanceof ZombieVillagerEntity;
            if (((LivingEntity)entitylivingbaseIn).isChild() && !(entitylivingbaseIn instanceof VillagerEntity)) {
                float f = 2.0f;
                float f1 = 1.4f;
                matrixStackIn.translate(0.0, 0.03125, 0.0);
                matrixStackIn.scale(0.7f, 0.7f, 0.7f);
                matrixStackIn.translate(0.0, 1.0, 0.0);
            }
            ((IHasHead)this.getEntityModel()).getModelHead().translateRotate(matrixStackIn);
            if (item instanceof BlockItem && ((BlockItem)item).getBlock() instanceof AbstractSkullBlock) {
                float f3 = 1.1875f;
                matrixStackIn.scale(1.1875f, -1.1875f, -1.1875f);
                if (flag) {
                    matrixStackIn.translate(0.0, 0.0625, 0.0);
                }
                GameProfile gameprofile = null;
                if (itemstack.hasTag()) {
                    String s;
                    CompoundNBT compoundnbt = itemstack.getTag();
                    if (compoundnbt.contains("SkullOwner", 10)) {
                        gameprofile = NBTUtil.readGameProfile(compoundnbt.getCompound("SkullOwner"));
                    } else if (compoundnbt.contains("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)(s = compoundnbt.getString("SkullOwner")))) {
                        gameprofile = SkullTileEntity.updateGameProfile(new GameProfile((UUID)null, s));
                        compoundnbt.put("SkullOwner", NBTUtil.writeGameProfile(new CompoundNBT(), gameprofile));
                    }
                }
                matrixStackIn.translate(-0.5, 0.0, -0.5);
                SkullTileEntityRenderer.render(null, 180.0f, ((AbstractSkullBlock)((BlockItem)item).getBlock()).getSkullType(), gameprofile, limbSwing, matrixStackIn, bufferIn, packedLightIn);
            } else if (!(item instanceof ArmorItem) || ((ArmorItem)item).getEquipmentSlot() != EquipmentSlotType.HEAD) {
                float f2 = 0.625f;
                matrixStackIn.translate(0.0, -0.25, 0.0);
                matrixStackIn.rotate(Vector3f.YP.rotationDegrees(180.0f));
                matrixStackIn.scale(0.625f, -0.625f, -0.625f);
                if (flag) {
                    matrixStackIn.translate(0.0, 0.1875, 0.0);
                }
                Minecraft.getInstance().getFirstPersonRenderer().renderItemSide((LivingEntity)entitylivingbaseIn, itemstack, ItemCameraTransforms.TransformType.HEAD, false, matrixStackIn, bufferIn, packedLightIn);
            }
            matrixStackIn.pop();
        }
    }
}

