/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class EnderCrystalRenderer
extends EntityRenderer<EnderCrystalEntity> {
    private static final ResourceLocation ENDER_CRYSTAL_TEXTURES = new ResourceLocation("textures/entity/end_crystal/end_crystal.png");
    private static final RenderType field_229046_e_ = RenderType.getEntityCutoutNoCull(ENDER_CRYSTAL_TEXTURES);
    private static final float field_229047_f_ = (float)Math.sin(0.7853981633974483);
    private final ModelRenderer field_229048_g_;
    private final ModelRenderer field_229049_h_;
    private final ModelRenderer field_229050_i_;

    public EnderCrystalRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
        this.shadowSize = 0.5f;
        this.field_229049_h_ = new ModelRenderer(64, 32, 0, 0);
        this.field_229049_h_.addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);
        this.field_229048_g_ = new ModelRenderer(64, 32, 32, 0);
        this.field_229048_g_.addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);
        this.field_229050_i_ = new ModelRenderer(64, 32, 0, 16);
        this.field_229050_i_.addBox(-6.0f, 0.0f, -6.0f, 12.0f, 4.0f, 12.0f);
    }

    @Override
    public void render(EnderCrystalEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.push();
        float f = EnderCrystalRenderer.func_229051_a_(entityIn, partialTicks);
        float f1 = ((float)entityIn.innerRotation + partialTicks) * 3.0f;
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(field_229046_e_);
        matrixStackIn.push();
        matrixStackIn.scale(2.0f, 2.0f, 2.0f);
        matrixStackIn.translate(0.0, -0.5, 0.0);
        int i = OverlayTexture.NO_OVERLAY;
        if (entityIn.shouldShowBottom()) {
            this.field_229050_i_.render(matrixStackIn, ivertexbuilder, packedLightIn, i);
        }
        matrixStackIn.rotate(Vector3f.YP.rotationDegrees(f1));
        matrixStackIn.translate(0.0, 1.5f + f / 2.0f, 0.0);
        matrixStackIn.rotate(new Quaternion(new Vector3f(field_229047_f_, 0.0f, field_229047_f_), 60.0f, true));
        this.field_229049_h_.render(matrixStackIn, ivertexbuilder, packedLightIn, i);
        float f2 = 0.875f;
        matrixStackIn.scale(0.875f, 0.875f, 0.875f);
        matrixStackIn.rotate(new Quaternion(new Vector3f(field_229047_f_, 0.0f, field_229047_f_), 60.0f, true));
        matrixStackIn.rotate(Vector3f.YP.rotationDegrees(f1));
        this.field_229049_h_.render(matrixStackIn, ivertexbuilder, packedLightIn, i);
        matrixStackIn.scale(0.875f, 0.875f, 0.875f);
        matrixStackIn.rotate(new Quaternion(new Vector3f(field_229047_f_, 0.0f, field_229047_f_), 60.0f, true));
        matrixStackIn.rotate(Vector3f.YP.rotationDegrees(f1));
        this.field_229048_g_.render(matrixStackIn, ivertexbuilder, packedLightIn, i);
        matrixStackIn.pop();
        matrixStackIn.pop();
        BlockPos blockpos = entityIn.getBeamTarget();
        if (blockpos != null) {
            float f3 = (float)blockpos.getX() + 0.5f;
            float f4 = (float)blockpos.getY() + 0.5f;
            float f5 = (float)blockpos.getZ() + 0.5f;
            float f6 = (float)((double)f3 - entityIn.getPosX());
            float f7 = (float)((double)f4 - entityIn.getPosY());
            float f8 = (float)((double)f5 - entityIn.getPosZ());
            matrixStackIn.translate(f6, f7, f8);
            EnderDragonRenderer.func_229059_a_(-f6, -f7 + f, -f8, partialTicks, entityIn.innerRotation, matrixStackIn, bufferIn, packedLightIn);
        }
        super.render(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public static float func_229051_a_(EnderCrystalEntity p_229051_0_, float p_229051_1_) {
        float f = (float)p_229051_0_.innerRotation + p_229051_1_;
        float f1 = MathHelper.sin(f * 0.2f) / 2.0f + 0.5f;
        f1 = (f1 * f1 + f1) * 0.4f;
        return f1 - 1.4f;
    }

    @Override
    public ResourceLocation getEntityTexture(EnderCrystalEntity entity) {
        return ENDER_CRYSTAL_TEXTURES;
    }

    @Override
    public boolean shouldRender(EnderCrystalEntity livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        return super.shouldRender(livingEntityIn, camera, camX, camY, camZ) || livingEntityIn.getBeamTarget() != null;
    }
}

